/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.stirling;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.util.BlockCoord;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.generator.AbstractGeneratorEntity;
import crazypants.enderio.machine.generator.stirling.PacketBurnTime;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.PowerDistributor;
import net.minecraft.block.Block;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityStirlingGenerator
extends AbstractGeneratorEntity
implements ISidedInventory,
IProgressTile {
    public static final int ENERGY_PER_TICK = Config.stirlingGeneratorBaseRfPerTick;
    public static final String SOUND_NAME = "generator.stirling";
    public int burnTime = 0;
    public int totalBurnTime;
    private PowerDistributor powerDis;

    public TileEntityStirlingGenerator() {
        super(new SlotDefinition(1, 0));
    }

    @Override
    public String getMachineName() {
        return ModObject.blockStirlingGenerator.unlocalisedName;
    }

    @Override
    public String func_145825_b() {
        return "Stirling Generator";
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        return TileEntityFurnace.func_145954_b((ItemStack)itemstack);
    }

    @Override
    public int[] func_94128_d(int var1) {
        return new int[]{0};
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return !TileEntityFurnace.func_145954_b((ItemStack)itemstack);
    }

    @Override
    public boolean isActive() {
        return this.burnTime > 0;
    }

    public float getProgress() {
        if (this.totalBurnTime <= 0) {
            return 0.0f;
        }
        return (float)this.burnTime / (float)this.totalBurnTime;
    }

    public void setProgress(float progress) {
        this.burnTime = (int)((float)this.totalBurnTime * progress);
    }

    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public String getSoundName() {
        return SOUND_NAME;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        super.readCustomNBT(nbtRoot);
        this.burnTime = nbtRoot.func_74762_e("burnTime");
        this.totalBurnTime = nbtRoot.func_74762_e("totalBurnTime");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        super.writeCustomNBT(nbtRoot);
        nbtRoot.func_74768_a("burnTime", this.burnTime);
        nbtRoot.func_74768_a("totalBurnTime", this.totalBurnTime);
    }

    @Override
    public void onNeighborBlockChange(Block blockId) {
        super.onNeighborBlockChange(blockId);
        if (this.powerDis != null) {
            this.powerDis.neighboursChanged();
        }
    }

    @Override
    public int getPowerUsePerTick() {
        return Math.round((float)ENERGY_PER_TICK * this.getEnergyMultiplier());
    }

    public int getBurnTime(ItemStack item) {
        return Math.round((float)TileEntityFurnace.func_145952_a((ItemStack)item) / this.getBurnTimeMultiplier());
    }

    @Override
    protected boolean processTasks(boolean redstoneCheckPassed) {
        boolean needsUpdate = false;
        boolean sendBurnTimePacket = false;
        if (this.burnTime > 0) {
            if (this.getEnergyStored() < this.getMaxEnergyStored()) {
                this.setEnergyStored(this.getEnergyStored() + this.getPowerUsePerTick());
            }
            --this.burnTime;
            sendBurnTimePacket = this.shouldDoWorkThisTick(20, -1) || this.burnTime == 0;
        }
        this.transmitEnergy();
        if (redstoneCheckPassed && this.burnTime <= 0 && this.getEnergyStored() < this.getMaxEnergyStored() && this.inventory[0] != null && this.inventory[0].field_77994_a > 0) {
            this.burnTime = this.getBurnTime(this.inventory[0]);
            if (this.burnTime > 0) {
                this.totalBurnTime = this.burnTime;
                ItemStack containedItem = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
                if (containedItem != null) {
                    this.inventory[0] = containedItem;
                } else {
                    this.func_70298_a(0, 1);
                }
                needsUpdate = true;
            }
        }
        if (!needsUpdate && sendBurnTimePacket) {
            PacketHandler.sendToAllAround((IMessage)new PacketBurnTime(this), (TileEntity)this);
        }
        return needsUpdate;
    }

    @Override
    protected boolean doPush(ForgeDirection dir) {
        if (this.inventory[0] == null) {
            return false;
        }
        if (!this.shouldDoWorkThisTick(20)) {
            return false;
        }
        if (!this.func_102008_b(0, this.inventory[0], 0)) {
            return false;
        }
        BlockCoord loc = this.getLocation().getLocation(dir);
        TileEntity te = this.field_145850_b.func_147438_o(loc.x, loc.y, loc.z);
        return this.doPush(dir, te, 0, 0);
    }

    public static float getEnergyMultiplier(Capacitors capacitorType) {
        if (capacitorType == Capacitors.ACTIVATED_CAPACITOR) {
            return 2.0f;
        }
        if (capacitorType == Capacitors.ENDER_CAPACITOR) {
            return 4.0f;
        }
        return 1.0f;
    }

    private float getEnergyMultiplier() {
        return TileEntityStirlingGenerator.getEnergyMultiplier(this.getCapacitorType());
    }

    public static float getBurnTimeMultiplier(Capacitors capacitorType) {
        if (capacitorType == Capacitors.ACTIVATED_CAPACITOR) {
            return 1.5f;
        }
        if (capacitorType == Capacitors.ENDER_CAPACITOR) {
            return 1.5f;
        }
        return 2.0f;
    }

    public float getBurnTimeMultiplier() {
        return TileEntityStirlingGenerator.getBurnTimeMultiplier(this.getCapacitorType());
    }

    private boolean transmitEnergy() {
        int canTransmit;
        if (this.powerDis == null) {
            this.powerDis = new PowerDistributor(new BlockCoord((TileEntity)this));
        }
        if ((canTransmit = Math.min(this.getEnergyStored(), this.getPowerUsePerTick() * 2)) <= 0) {
            return false;
        }
        int transmitted = this.powerDis.transmitEnergy(this.field_145850_b, canTransmit);
        this.setEnergyStored(this.getEnergyStored() - transmitted);
        return transmitted > 0;
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }
}

