/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import crazypants.enderio.machine.invpanel.ItemEntryBase;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class InventoryDatabase<ItemEntry extends ItemEntryBase> {
    private static final Item META_EXTRACTOR = new Item();
    private static final int SIMPLE_ITEMID_BITS = 12;
    private static final int SIMPLE_META_BITS = 4;
    private static final int SIMPLE_MAX_ITEMID = 4096;
    private static final int SIMPLE_MAX_META = 16;
    private static final int SIMPLE_META_MASK = 15;
    protected static final int COMPLEX_DBINDEX_START = 65536;
    protected final HashMap<Integer, ItemEntry> simpleRegsitry = new HashMap();
    protected final HashMap<ItemEntry, ItemEntry> complexRegistry = new HashMap();
    protected final ArrayList<ItemEntry> complexItems = new ArrayList();
    protected int generation;

    public int getGeneration() {
        return this.generation;
    }

    public ItemEntry lookupItem(ItemStack stack, ItemEntry hint, boolean create) {
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        int itemID = Item.func_150891_b((Item)stack.func_77973_b());
        int meta = META_EXTRACTOR.getDamage(stack);
        NBTTagCompound nbt = stack.field_77990_d;
        if (nbt != null && nbt.func_82582_d()) {
            nbt = null;
        }
        if (hint != null && ((ItemEntryBase)hint).equals(itemID, meta, nbt)) {
            return hint;
        }
        if (nbt == null && itemID < 4096 && meta < 16) {
            return this.getSimpleItem(itemID, meta, create);
        }
        return this.getComplexItem(itemID, meta, nbt);
    }

    protected abstract ItemEntry createItemEntry(int var1, int var2, int var3, int var4, NBTTagCompound var5);

    protected ItemEntry createItemEntry(int dbId, int itemID, int meta, NBTTagCompound nbt) {
        int hash = InventoryDatabase.computeComplexHash(itemID, meta, nbt);
        return this.createItemEntry(dbId, hash, itemID, meta, nbt);
    }

    private ItemEntry getComplexItem(int itemID, int meta, NBTTagCompound nbt) {
        int hash = InventoryDatabase.computeComplexHash(itemID, meta, nbt);
        ItemEntryKey key = new ItemEntryKey(hash, itemID, meta, nbt);
        ItemEntryBase entry = (ItemEntryBase)this.complexRegistry.get(key);
        if (entry == null) {
            if (nbt != null) {
                nbt = (NBTTagCompound)nbt.func_74737_b();
            }
            entry = this.createItemEntry(65536 + this.complexItems.size(), hash, itemID, meta, nbt);
            this.complexItems.add(entry);
            this.complexRegistry.put(entry, entry);
        }
        return (ItemEntry)entry;
    }

    private static int computeComplexHash(int itemID, int meta, NBTTagCompound nbt) {
        int hash = (itemID * 257 ^ meta) * 17;
        if (nbt != null) {
            hash ^= nbt.hashCode();
        }
        return hash;
    }

    private ItemEntry getSimpleItem(int itemID, int meta, boolean create) {
        Integer dbID = itemID << 4 | meta;
        ItemEntryBase entry = (ItemEntryBase)this.simpleRegsitry.get(dbID);
        if (entry == null && create) {
            entry = this.createItemEntry(dbID, dbID, itemID, meta, null);
            this.simpleRegsitry.put(dbID, entry);
        }
        return (ItemEntry)entry;
    }

    protected ItemEntry getSimpleItem(int dbID) {
        int itemID = dbID >> 4;
        int meta = dbID & 0xF;
        return this.getSimpleItem(itemID, meta, true);
    }

    public ItemEntry getItem(int dbID) {
        if (dbID < 65536) {
            return this.getSimpleItem(dbID);
        }
        int dbIndex = dbID - 65536;
        if (dbIndex < this.complexItems.size()) {
            return (ItemEntry)((ItemEntryBase)this.complexItems.get(dbIndex));
        }
        return null;
    }

    public ItemEntry getExistingItem(int dbID) {
        if (dbID < 65536) {
            return (ItemEntry)((ItemEntryBase)this.simpleRegsitry.get(dbID));
        }
        return this.getItem(dbID);
    }

    static final class ItemEntryKey {
        public final int hash;
        public final int itemID;
        public final int meta;
        public final NBTTagCompound nbt;

        ItemEntryKey(int hash, int itemID, int meta, NBTTagCompound nbt) {
            this.hash = hash;
            this.itemID = itemID;
            this.meta = meta;
            this.nbt = nbt;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ItemEntryBase) {
                ItemEntryBase other = (ItemEntryBase)obj;
                return other.equals(this.itemID, this.meta, this.nbt);
            }
            return false;
        }
    }
}

