/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.reservoir;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.vecmath.Vector3f;
import crazypants.enderio.EnderIO;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.machine.reservoir.TankNeighbour;
import crazypants.enderio.tool.SmartTank;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileReservoir
extends TileEntityEio
implements IFluidHandler,
ITankAccess {
    static final FluidStack WATER_BUCKET = FluidRegistry.getFluidStack((String)"water", (int)1000);
    BlockCoord[] multiblock = null;
    ForgeDirection front = ForgeDirection.UNKNOWN;
    ForgeDirection up = ForgeDirection.UNKNOWN;
    ForgeDirection right = ForgeDirection.UNKNOWN;
    Pos pos = Pos.UNKNOWN;
    SmartTank tank = new SmartTank(FluidRegistry.WATER, 1000);
    SmartTank regenTank = null;
    boolean autoEject;
    private boolean tankDirty = false;
    private boolean neighboursDirty = false;
    private long ticksSinceFill = 0L;
    private BoundingBox liquidRenderBounds = null;
    private ArrayList<TankNeighbour> tankNeighbours;
    long lastRenderTick;
    float lastRenderPartialTick;

    public void doUpdate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isMaster()) {
            if (this.regenTank == null || this.tank == null) {
                return;
            }
            if (this.regenTank.isFull() && !this.tank.isFull()) {
                ++this.ticksSinceFill;
                if (this.ticksSinceFill >= 20L) {
                    this.ticksSinceFill = 0L;
                    this.tank.fill(WATER_BUCKET, true);
                    this.tankDirty = true;
                }
            }
            if (this.autoEject && this.neighboursDirty) {
                this.doUpdateTankNeighbours();
            }
            if (this.autoEject && this.tankNeighbours != null && !this.tankNeighbours.isEmpty() && this.tank.getFluidAmount() > 0) {
                int ejectable = this.tank.getFluidAmount();
                int amountPerNeighbour = ejectable / this.tankNeighbours.size();
                FluidStack source = WATER_BUCKET.copy();
                int used = 0;
                for (TankNeighbour tc : this.tankNeighbours) {
                    source.amount = amountPerNeighbour;
                    used += tc.container.fill(tc.fillFromDir, source, true);
                }
                if (used > 0) {
                    this.tank.drain(used, true);
                    this.tankDirty = true;
                }
            }
        }
        if (this.tankDirty && this.shouldDoWorkThisTick(2)) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.tankDirty = false;
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.isMultiblock()) {
            return 0;
        }
        return this.getController().doFill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.getController().doDrain(from, maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this.tank.getFluid() == null) {
            return true;
        }
        return fluid != null && fluid.getID() == this.tank.getFluid().getFluidID();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (this.tank.getFluid() == null || fluid == null) {
            return false;
        }
        return this.tank.getFluid().getFluid().getID() == fluid.getID();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.getController().doGetTankInfo(from);
    }

    private FluidTankInfo[] doGetTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public void setAutoEject(boolean autoEject) {
        TileReservoir c = this.getController();
        if (c != null) {
            c.doSetAutoEject(autoEject);
        } else {
            this.doSetAutoEject(autoEject);
        }
    }

    private void doSetAutoEject(boolean newVal) {
        if (newVal && !this.autoEject) {
            this.updateTankNeighbours();
        }
        this.autoEject = newVal;
    }

    public boolean isAutoEject() {
        TileReservoir c = this.getController();
        if (c != null) {
            return c.doIsAutoEject();
        }
        return this.doIsAutoEject();
    }

    private boolean doIsAutoEject() {
        return this.autoEject;
    }

    private void updateTankNeighbours() {
        TileReservoir c = this.getController();
        if (c != null) {
            c.neighboursDirty = true;
        }
    }

    private void doUpdateTankNeighbours() {
        if (this.tankNeighbours == null) {
            this.tankNeighbours = new ArrayList();
        }
        this.tankNeighbours.clear();
        for (BlockCoord bc : this.multiblock) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                IFluidHandler tc;
                BlockCoord check = bc.getLocation(dir);
                if (this.inMultiblock(check) || (tc = this.getTankContainer(check)) == null) continue;
                this.tankNeighbours.add(new TankNeighbour(tc, dir.getOpposite()));
            }
        }
        this.neighboursDirty = false;
    }

    private boolean inMultiblock(BlockCoord check) {
        for (BlockCoord bc : this.multiblock) {
            if (!check.equals((Object)bc)) continue;
            return true;
        }
        return false;
    }

    public void readCustomNBT(NBTTagCompound nbtRoot) {
        this.front = ForgeDirection.getOrientation((int)nbtRoot.func_74765_d("front"));
        this.up = ForgeDirection.getOrientation((int)nbtRoot.func_74765_d("up"));
        this.right = ForgeDirection.getOrientation((int)nbtRoot.func_74765_d("right"));
        this.pos = Pos.values()[nbtRoot.func_74765_d("pos")];
        this.autoEject = nbtRoot.func_74767_n("autoEject");
        FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtRoot.func_74775_l("tank"));
        FluidStack regenLiquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtRoot.func_74775_l("regenTank"));
        this.tank.setCapacity(regenLiquid == null ? 1000 : 2000);
        if (liquid != null) {
            this.tank.setFluid(liquid);
        } else {
            this.tank.setFluidAmount(0);
        }
        if (regenLiquid == null) {
            this.regenTank = null;
        } else {
            this.regenTank = new SmartTank(FluidRegistry.WATER, 2000);
            this.regenTank.setFluidAmount(regenLiquid.amount);
        }
        boolean wasMulti = this.isMultiblock();
        if (nbtRoot.func_74767_n("isMultiblock")) {
            int[] coords = nbtRoot.func_74759_k("multiblock");
            this.multiblock = new BlockCoord[4];
            int c = 0;
            for (int i = 0; i < 4; ++i) {
                this.multiblock[i] = new BlockCoord(coords[c++], coords[c++], coords[c++]);
            }
            if (this.isMaster() && this.autoEject) {
                this.updateTankNeighbours();
            }
        } else {
            this.multiblock = null;
        }
        if (wasMulti != this.isMultiblock()) {
            this.liquidRenderBounds = null;
        }
    }

    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        nbtRoot.func_74777_a("front", (short)this.front.ordinal());
        nbtRoot.func_74777_a("up", (short)this.up.ordinal());
        nbtRoot.func_74777_a("right", (short)this.right.ordinal());
        nbtRoot.func_74777_a("pos", (short)this.pos.ordinal());
        nbtRoot.func_74757_a("autoEject", this.autoEject);
        if (this.tank.getFluid() != null && FluidRegistry.getFluidName((FluidStack)this.tank.getFluid()) != null) {
            nbtRoot.func_74782_a("tank", (NBTBase)this.tank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if (this.regenTank != null) {
            nbtRoot.func_74782_a("regenTank", (NBTBase)this.regenTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        nbtRoot.func_74757_a("isMultiblock", this.isMultiblock());
        if (this.isMultiblock()) {
            int[] vals = new int[12];
            int i = 0;
            for (BlockCoord bc : this.multiblock) {
                vals[i++] = bc.x;
                vals[i++] = bc.y;
                vals[i++] = bc.z;
            }
            nbtRoot.func_74783_a("multiblock", vals);
        }
    }

    public boolean onBlockAdded() {
        boolean res = this.formMultiblock();
        return res;
    }

    public boolean onNeighborBlockChange(Block blockId) {
        if (blockId == EnderIO.blockReservoir) {
            if (!this.isCurrentMultiblockValid()) {
                TileReservoir controller = this.getController();
                if (controller != null) {
                    controller.clearCurrentMultiblock();
                    controller.formMultiblock();
                } else {
                    this.clearCurrentMultiblock();
                    this.formMultiblock();
                }
                return true;
            }
        } else if (this.isMultiblock() && this.isAutoEject()) {
            this.updateTankNeighbours();
        }
        return false;
    }

    boolean isVertical() {
        return this.up == ForgeDirection.UP;
    }

    boolean isMaster() {
        if (this.multiblock != null) {
            return this.multiblock[0].equals(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return false;
    }

    float getFilledRatio() {
        return this.getController().doGetFilledRatio();
    }

    public boolean isMultiblock() {
        return this.multiblock != null;
    }

    BoundingBox getLiquidRenderBounds() {
        if (this.liquidRenderBounds == null) {
            if (!this.isMultiblock()) {
                return BoundingBox.UNIT_CUBE;
            }
            BoundingBox bounds = new BoundingBox(this.multiblock[0]);
            for (int i = 1; i < this.multiblock.length; ++i) {
                bounds = bounds.expandBy(new BoundingBox(this.multiblock[i]));
            }
            this.liquidRenderBounds = bounds.translate((float)(-this.multiblock[0].x), (float)(-this.multiblock[0].y), (float)(-this.multiblock[0].z));
        }
        return this.liquidRenderBounds;
    }

    protected float doGetFilledRatio() {
        float result = this.tank.getFilledRatio();
        if (this.isMaster() && this.regenTank != null) {
            result = this.regenTank.getFilledRatio() * 0.5f + result * 0.5f;
        }
        return result;
    }

    int doFill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!WATER_BUCKET.isFluidEqual(resource)) {
            return 0;
        }
        int ret = 0;
        if (resource != null && this.isMaster()) {
            resource = resource.copy();
            int filled = this.regenTank.fill(resource, doFill);
            resource.amount -= filled;
            ret += filled;
        }
        this.tankDirty = doFill;
        return ret += this.tank.fill(resource, doFill);
    }

    protected FluidStack doDrain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack ret = this.tank.drain(maxDrain, doDrain);
        this.tankDirty = doDrain;
        return ret;
    }

    private void setMultiblock(BlockCoord[] mb) {
        this.multiblock = mb;
        this.updatePosition();
        if (this.isMaster()) {
            this.regenTank = new SmartTank(FluidRegistry.WATER, 2000);
            this.tank.setCapacity(2000);
            for (BlockCoord bc : this.multiblock) {
                TileReservoir res = this.getReservoir(bc);
                if (res == null) continue;
                FluidStack drained = res.doDrain(ForgeDirection.UNKNOWN, this.regenTank.getAvailableSpace(), true);
                if (drained != null) {
                    this.regenTank.addFluidAmount(drained.amount);
                }
                if ((drained = res.doDrain(ForgeDirection.UNKNOWN, this.tank.getAvailableSpace(), true)) == null) continue;
                this.tank.addFluidAmount(drained.amount);
            }
            if (this.doIsAutoEject()) {
                this.updateTankNeighbours();
            }
        } else {
            this.regenTank = null;
            this.tank.setCapacity(1000);
        }
        this.tankDirty = true;
        this.liquidRenderBounds = null;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.isMultiblock() ? 1 : 0, 2);
    }

    TileReservoir getController() {
        if (this.isMaster() || !this.isMultiblock()) {
            return this;
        }
        TileReservoir res = this.getReservoir(this.multiblock[0]);
        return res != null ? res : this;
    }

    private void updatePosition() {
        if (this.multiblock == null) {
            this.front = ForgeDirection.UNKNOWN;
            this.up = ForgeDirection.UNKNOWN;
            this.right = ForgeDirection.UNKNOWN;
            return;
        }
        boolean isVertical = false;
        for (BlockCoord bc : this.multiblock) {
            if (bc.y == this.field_145848_d) continue;
            isVertical = true;
            break;
        }
        if (isVertical) {
            this.up = ForgeDirection.UP;
            boolean isWestEast = false;
            for (BlockCoord bc : this.multiblock) {
                if (bc.x == this.field_145851_c) continue;
                isWestEast = true;
                break;
            }
            this.front = isWestEast ? ForgeDirection.NORTH : ForgeDirection.EAST;
            this.right = isWestEast ? ForgeDirection.WEST : ForgeDirection.NORTH;
        } else {
            this.front = ForgeDirection.UP;
            this.right = ForgeDirection.EAST;
            this.up = ForgeDirection.NORTH;
        }
        boolean isRight = false;
        BlockCoord myCoord = new BlockCoord((TileEntity)this);
        for (BlockCoord bc : this.multiblock) {
            if (!this.isInDir(myCoord, this.right, bc)) continue;
            isRight = true;
        }
        boolean isTop = false;
        for (BlockCoord bc : this.multiblock) {
            if (!this.isInDir(myCoord, this.up, bc)) continue;
            isTop = true;
        }
        this.pos = isTop ? (isRight ? Pos.TR : Pos.TL) : (isRight ? Pos.BR : Pos.BL);
    }

    private boolean isInDir(BlockCoord from, ForgeDirection inDir, BlockCoord to) {
        if (inDir.offsetX != 0) {
            return from.x - inDir.offsetX == to.x;
        }
        if (inDir.offsetY != 0) {
            return from.y - inDir.offsetY == to.y;
        }
        if (inDir.offsetZ != 0) {
            return from.z - inDir.offsetZ == to.z;
        }
        return false;
    }

    private void clearCurrentMultiblock() {
        if (this.multiblock == null) {
            return;
        }
        boolean fillTanks = false;
        if (this.isMaster()) {
            fillTanks = this.regenTank.isFull();
            this.regenTank = null;
        }
        for (BlockCoord bc : this.multiblock) {
            TileReservoir res = this.getReservoir(bc);
            if (res == null) continue;
            res.setMultiblock(null);
            if (fillTanks) {
                res.tank.fill(WATER_BUCKET, true);
                continue;
            }
            res.tank.drain(1000, true);
        }
        this.multiblock = null;
        this.tankDirty = true;
    }

    private boolean isCurrentMultiblockValid() {
        if (this.multiblock == null) {
            return false;
        }
        for (BlockCoord bc : this.multiblock) {
            TileReservoir res = this.getReservoir(bc);
            if (res != null && res.isMultiblock()) continue;
            return false;
        }
        return true;
    }

    private boolean formMultiblock() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            ForgeDirection[] cans;
            if (!this.isNonMultiReservoir(dir)) continue;
            for (ForgeDirection neighbor : cans = this.candidates(dir)) {
                if (!this.isNonMultiReservoir(neighbor) || !this.isNonMultiReservoir(dir.offsetX + neighbor.offsetX, dir.offsetY + neighbor.offsetY, dir.offsetZ + neighbor.offsetZ)) continue;
                BlockCoord[] mb = new BlockCoord[]{this.inDirection(dir), this.inDirection(neighbor), this.inDirection(dir.offsetX + neighbor.offsetX, dir.offsetY + neighbor.offsetY, dir.offsetZ + neighbor.offsetZ), new BlockCoord(this.field_145851_c, this.field_145848_d, this.field_145849_e)};
                for (BlockCoord bc : mb) {
                    TileReservoir res = this.getReservoir(bc);
                    res.setMultiblock(mb);
                }
                return true;
            }
        }
        return false;
    }

    private BlockCoord inDirection(int offsetX, int offsetY, int offsetZ) {
        return new BlockCoord(this.field_145851_c + offsetX, this.field_145848_d + offsetY, this.field_145849_e + offsetZ);
    }

    private BlockCoord inDirection(ForgeDirection dir) {
        return this.inDirection(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    private IFluidHandler getTankContainer(BlockCoord bc) {
        return this.getTankContainer(bc.x, bc.y, bc.z);
    }

    private IFluidHandler getTankContainer(int x, int y, int z) {
        if (this.field_145850_b == null) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (te instanceof IFluidHandler) {
            return (IFluidHandler)te;
        }
        return null;
    }

    private TileReservoir getReservoir(BlockCoord bc) {
        return this.getReservoir(bc.x, bc.y, bc.z);
    }

    private TileReservoir getReservoir(int x, int y, int z) {
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (te instanceof TileReservoir) {
            return (TileReservoir)te;
        }
        return null;
    }

    private boolean isNonMultiReservoir(int offsetX, int offsetY, int offsetZ) {
        TileReservoir res = this.getReservoir(this.field_145851_c + offsetX, this.field_145848_d + offsetY, this.field_145849_e + offsetZ);
        if (res == null) {
            return false;
        }
        return !res.isMultiblock();
    }

    private boolean isNonMultiReservoir(ForgeDirection dir) {
        return this.isNonMultiReservoir(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    private ForgeDirection[] candidates(ForgeDirection matchDir) {
        ForgeDirection[] res;
        res = new ForgeDirection[]{matchDir.getRotation(matchDir.offsetY == 0 ? ForgeDirection.UP : ForgeDirection.NORTH), res[0].getOpposite(), matchDir.getRotation(matchDir.offsetX == 0 ? ForgeDirection.EAST : ForgeDirection.NORTH), res[2].getOpposite()};
        return res;
    }

    public Vector3f getOffsetFromController() {
        if (!this.isMultiblock()) {
            return new Vector3f();
        }
        BlockCoord masterBC = this.multiblock[0];
        BlockCoord myBC = new BlockCoord(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return new Vector3f((float)(masterBC.x - myBC.x), (float)(masterBC.y - myBC.y), (float)(masterBC.z - myBC.z));
    }

    public boolean haveRendered(long renderTick, float renderPartialTick) {
        TileReservoir c = this.getController();
        if (c.lastRenderTick == renderTick && renderPartialTick == c.lastRenderPartialTick) {
            return true;
        }
        c.lastRenderTick = renderTick;
        c.lastRenderPartialTick = renderPartialTick;
        return false;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null && forFluidType.getFluid() == FluidRegistry.WATER) {
            TileReservoir res = this.getController();
            return !res.isMaster() || res.regenTank.isFull() ? res.tank : res.regenTank;
        }
        return null;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.getController().tank};
    }

    public void setTanksDirty() {
        if (this.isMaster() && this.regenTank != null && this.tank != null && !this.regenTank.isFull() && this.tank.getFluidAmount() > 0) {
            int toMove = Math.min(this.tank.getFluidAmount(), this.regenTank.getCapacity() - this.regenTank.getFluidAmount());
            this.regenTank.setFluidAmount(this.regenTank.getFluidAmount() + toMove);
            this.tank.setFluidAmount(this.tank.getFluidAmount() - toMove);
        }
        this.tankDirty = true;
    }

    static enum Pos {
        TL(true, false),
        TR(true, true),
        BL(false, false),
        BR(false, true),
        UNKNOWN(false, false);

        boolean isTop;
        boolean isRight;

        private Pos(boolean isTop, boolean isRight) {
            this.isTop = isTop;
            this.isRight = isRight;
        }

        public boolean isRight(ForgeDirection side) {
            if (side == ForgeDirection.EAST || side == ForgeDirection.NORTH) {
                return !this.isRight;
            }
            return this.isRight;
        }

        public boolean isTop(ForgeDirection side) {
            if (side == ForgeDirection.EAST) {
                return !this.isTop;
            }
            return this.isTop;
        }
    }
}

