/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.telepad;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.client.gui.GuiContainerBase;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.telepad.ContainerTelePad;
import crazypants.enderio.teleport.telepad.IToggleableGui;
import crazypants.enderio.teleport.telepad.PacketOpenServerGui;
import crazypants.enderio.teleport.telepad.PacketUpdateCoords;
import crazypants.enderio.teleport.telepad.TileTelePad;
import crazypants.enderio.teleport.telepad.ToggleTravelButton;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GuiTelePad
extends GuiContainerBase
implements IToggleableGui {
    private static final int ID_SWITCH_BUTTON = 95;
    private static final int ID_TELEPORT_BUTTON = 96;
    ToggleTravelButton switchButton;
    GuiButton teleportButton;
    private World world;
    private TileTelePad te;
    private TextFieldEnder xTF;
    private TextFieldEnder yTF;
    private TextFieldEnder zTF;
    private TextFieldEnder dimTF;
    private int powerX = 8;
    private int powerY = 9;
    private int powerScale = 100;
    private int progressX = 26;
    private int progressY = 90;
    private int progressScale = 124;
    public static int SWITCH_X = 155;
    public static int SWITCH_Y = 5;

    public GuiTelePad(InventoryPlayer playerInv, TileTelePad te, World world) {
        super((Container)new ContainerTelePad(playerInv));
        this.world = world;
        this.te = te;
        this.field_147000_g += 34;
        this.addToolTip(new GuiToolTip(new Rectangle(this.powerX, this.powerY, 10, this.powerScale), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                GuiTelePad.this.updatePowerBarTooltip(this.text);
            }
        });
        this.addToolTip(new GuiToolTip(new Rectangle(this.progressX, this.progressY, this.progressScale, 10), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                this.text.add(Math.round(GuiTelePad.this.te.getProgress() * 100.0f) + "%");
            }
        });
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int x = 42;
        int y = 8;
        this.xTF = new TextFieldEnder(fr, x, y, this.field_146999_f - x * 2, 12, TextFieldEnder.FILTER_NUMERIC);
        this.yTF = new TextFieldEnder(fr, x, y + this.xTF.field_146219_i + 2, this.field_146999_f - x * 2, 12, TextFieldEnder.FILTER_NUMERIC);
        this.zTF = new TextFieldEnder(fr, x, y + this.xTF.field_146219_i * 2 + 4, this.field_146999_f - x * 2, 12, TextFieldEnder.FILTER_NUMERIC);
        this.dimTF = new TextFieldEnder(fr, x, y + this.xTF.field_146219_i * 3 + 6, this.field_146999_f - x * 2, 12, TextFieldEnder.FILTER_NUMERIC);
        this.xTF.func_146180_a(Integer.toString(te.getX()));
        this.yTF.func_146180_a(Integer.toString(te.getY()));
        this.zTF.func_146180_a(Integer.toString(te.getZ()));
        this.dimTF.func_146180_a(Integer.toString(te.getTargetDim()));
        this.xTF.func_146205_d(!Config.telepadLockCoords);
        this.yTF.func_146205_d(!Config.telepadLockCoords);
        this.zTF.func_146205_d(!Config.telepadLockCoords);
        this.dimTF.func_146205_d(!Config.telepadLockDimension);
        this.textFields.addAll(Lists.newArrayList((Object[])new TextFieldEnder[]{this.xTF, this.yTF, this.zTF, this.dimTF}));
        this.switchButton = new ToggleTravelButton(this, 95, SWITCH_X, SWITCH_Y, IconEIO.IO_WHATSIT);
        this.switchButton.setToolTip(new String[]{EnderIO.lang.localize("gui.telepad.configure.travel")});
    }

    private String getPowerOutputLabel() {
        return StatCollector.func_74838_a((String)"enderio.gui.max");
    }

    protected int getPowerOutputValue() {
        return this.te.getUsage();
    }

    protected void updatePowerBarTooltip(List<String> text) {
        text.add(this.getPowerOutputLabel() + " " + PowerDisplayUtil.formatPower(this.getPowerOutputValue()) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr());
        text.add(PowerDisplayUtil.formatStoredPower(this.te.getEnergyStored(), this.te.getMaxEnergyStored()));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.switchButton.onGuiInit();
        String text = EnderIO.lang.localize("gui.telepad.teleport");
        int width = this.getFontRenderer().func_78256_a(text) + 10;
        int x = this.field_147003_i + this.field_146999_f / 2 - width / 2;
        int y = this.field_147009_r + 65;
        this.teleportButton = new GuiButton(96, x, y, width, 20, text);
        this.addButton(this.teleportButton);
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    protected void func_73869_a(char par1, int par2) {
        super.func_73869_a(par1, par2);
        this.updateCoords();
    }

    private void updateCoords() {
        BlockCoord bc = new BlockCoord(this.getIntFromTextBox(this.xTF), this.getIntFromTextBox(this.yTF), this.getIntFromTextBox(this.zTF));
        int targetDim = this.getIntFromTextBox(this.dimTF);
        if (bc.x != this.te.getX() || bc.y != this.te.getY() || bc.z != this.te.getZ() || targetDim != this.te.getTargetDim()) {
            this.te.setX(bc.x);
            this.te.setY(bc.y);
            this.te.setZ(bc.z);
            this.te.setTargetDim(targetDim);
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketUpdateCoords(this.te, bc, targetDim));
        }
    }

    private int getIntFromTextBox(TextFieldEnder tf) {
        String text = tf.func_146179_b();
        if ("".equals(text) || "-".equals(text)) {
            return 0;
        }
        return Integer.parseInt(text);
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture((String)"enderio:textures/gui/telePad.png");
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        int powerScaled = this.te.getPowerScaled(this.powerScale);
        this.func_73729_b(sx + this.powerX, sy + this.powerY + this.powerScale - powerScaled, this.field_146999_f, 0, 10, powerScaled);
        int progressScaled = Util.getProgressScaled((int)this.progressScale, (IProgressTile)this.te);
        this.func_73729_b(sx + this.progressX, sy + this.progressY, 0, this.field_147000_g, progressScaled, 10);
        FontRenderer fnt = this.getFontRenderer();
        String[] text = new String[]{"X", "Y", "Z", "DIM"};
        for (int i = 0; i < text.length; ++i) {
            TextFieldEnder f = (TextFieldEnder)this.textFields.get(i);
            fnt.func_78276_b(text[i], f.field_146209_f - fnt.func_78256_a(text[i]) / 2 - 10, f.field_146210_g + (f.field_146219_i - fnt.field_78288_b) / 2 + 1, 0);
            if (f.getCanLoseFocus()) continue;
            IconEIO.map.render((IWidgetIcon)IconEIO.LOCK_LOCKED, (double)(f.field_146209_f + f.field_146218_h - 2), (double)(f.field_146210_g - 2), true);
        }
        Entity e = this.te.getCurrentTarget();
        if (e != null) {
            String name = e.func_70005_c_();
            fnt.func_78276_b(name, sx + this.field_146999_f / 2 - fnt.func_78256_a(name) / 2, sy + this.progressY + fnt.field_78288_b + 6, 0);
        } else if (this.te.wasBlocked) {
            String s = EnderIO.lang.localize("gui.telepad.blocked");
            fnt.func_78276_b(s, sx + this.field_146999_f / 2 - fnt.func_78256_a(s) / 2, sy + this.progressY + fnt.field_78288_b + 6, 0xAA0000);
        }
        super.func_146976_a(p_146976_1_, p_146976_2_, p_146976_3_);
    }

    @Override
    public void switchGui() {
        this.field_146297_k.field_71439_g.openGui((Object)EnderIO.instance, 103, this.world, this.te.field_145851_c, this.te.field_145848_d, this.te.field_145849_e);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketOpenServerGui(this.te, 103));
    }

    protected void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button.field_146127_k == 96) {
            this.te.teleportAll();
        }
    }
}

