/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.registry;

import chanceCubes.CCubesCore;
import chanceCubes.blocks.CCubesBlocks;
import chanceCubes.config.CCubesSettings;
import chanceCubes.config.ConfigLoader;
import chanceCubes.items.ItemChancePendant;
import chanceCubes.registry.IRewardRegistry;
import chanceCubes.rewards.defaultRewards.AnvilRain;
import chanceCubes.rewards.defaultRewards.BasicReward;
import chanceCubes.rewards.defaultRewards.BlindnessFightReward;
import chanceCubes.rewards.defaultRewards.ChargedCreeperReward;
import chanceCubes.rewards.defaultRewards.ClearInventoryReward;
import chanceCubes.rewards.defaultRewards.CookieMonsterReward;
import chanceCubes.rewards.defaultRewards.CreeperSurroundedReward;
import chanceCubes.rewards.defaultRewards.DiscoReward;
import chanceCubes.rewards.defaultRewards.EnderCrystalTimerReward;
import chanceCubes.rewards.defaultRewards.FiveProngReward;
import chanceCubes.rewards.defaultRewards.HerobrineReward;
import chanceCubes.rewards.defaultRewards.IChanceCubeReward;
import chanceCubes.rewards.defaultRewards.InventoryBombReward;
import chanceCubes.rewards.defaultRewards.InventoryChestReward;
import chanceCubes.rewards.defaultRewards.ItemOfDestinyReward;
import chanceCubes.rewards.defaultRewards.MathReward;
import chanceCubes.rewards.defaultRewards.NukeReward;
import chanceCubes.rewards.defaultRewards.RandomTeleportReward;
import chanceCubes.rewards.defaultRewards.SurroundedReward;
import chanceCubes.rewards.defaultRewards.ThrownInAirReward;
import chanceCubes.rewards.defaultRewards.TrollHoleReward;
import chanceCubes.rewards.defaultRewards.TrollTNTReward;
import chanceCubes.rewards.defaultRewards.WaitForItReward;
import chanceCubes.rewards.defaultRewards.WitherReward;
import chanceCubes.rewards.defaultRewards.ZombieCopyCatReward;
import chanceCubes.rewards.rewardparts.CommandPart;
import chanceCubes.rewards.rewardparts.EntityPart;
import chanceCubes.rewards.rewardparts.ExpirencePart;
import chanceCubes.rewards.rewardparts.ItemPart;
import chanceCubes.rewards.rewardparts.MessagePart;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import chanceCubes.rewards.rewardparts.PotionPart;
import chanceCubes.rewards.rewardparts.SoundPart;
import chanceCubes.rewards.type.BlockRewardType;
import chanceCubes.rewards.type.CommandRewardType;
import chanceCubes.rewards.type.EntityRewardType;
import chanceCubes.rewards.type.ExperienceRewardType;
import chanceCubes.rewards.type.IRewardType;
import chanceCubes.rewards.type.ItemRewardType;
import chanceCubes.rewards.type.MessageRewardType;
import chanceCubes.rewards.type.PotionRewardType;
import chanceCubes.rewards.type.SoundRewardType;
import chanceCubes.util.RewardsUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;

public class ChanceCubeRegistry
implements IRewardRegistry {
    public static ChanceCubeRegistry INSTANCE = new ChanceCubeRegistry();
    private Map<String, IChanceCubeReward> nameToReward = Maps.newHashMap();
    private List<IChanceCubeReward> sortedRewards = Lists.newArrayList();

    public static void loadDefaultRewards() {
        if (!CCubesSettings.enableHardCodedRewards) {
            return;
        }
        INSTANCE.registerReward(new BasicReward("chancecubes:Tnt_Structure", -40, new BlockRewardType(RewardsUtil.addBlocksLists(RewardsUtil.fillArea(3, 1, 3, Blocks.field_150335_W, -1, 0, -1, true, 0, false, false), RewardsUtil.fillArea(3, 1, 3, Blocks.field_150451_bX, -1, 1, -1, true, 30, false, false)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:BedRock", -50, new BlockRewardType(new OffsetBlock(0, 0, 0, Blocks.field_150357_h, false))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Redstone_Diamond", 50, new ItemRewardType(new ItemPart(new ItemStack(Items.field_151137_ax)), new ItemPart(new ItemStack(Items.field_151045_i)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Sethbling_Reward", 55, new MessageRewardType(new MessagePart("Welcome back, SethBling here :)")), new ItemRewardType(new ItemPart(new ItemStack(Items.field_151137_ax, 32)), new ItemPart(new ItemStack(Items.field_151107_aW, 3)), new ItemPart(new ItemStack(Items.field_151132_bS, 3)), new ItemPart(new ItemStack(Blocks.field_150379_bu, 3)), new ItemPart(new ItemStack(Blocks.field_150429_aA, 3)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Creeper", -20, new EntityRewardType(new EntityPart(EntityRewardType.getBasicNBTForEntity("Creeper")))));
        INSTANCE.registerReward(new BasicReward("chancecubes:EXP", 35, new ExperienceRewardType(new ExpirencePart(100).setNumberofOrbs(10))));
        INSTANCE.registerReward(new BasicReward("chancecubes:EXP_Shower", 35, new ExperienceRewardType(new ExpirencePart(10), new ExpirencePart(10, 10), new ExpirencePart(10, 10), new ExpirencePart(10, 20), new ExpirencePart(10, 30), new ExpirencePart(10, 40), new ExpirencePart(10, 50), new ExpirencePart(10, 60), new ExpirencePart(10, 70), new ExpirencePart(10, 80), new ExpirencePart(10, 90), new ExpirencePart(10, 100), new ExpirencePart(10, 110), new ExpirencePart(10, 120), new ExpirencePart(10, 130), new ExpirencePart(10, 140), new ExpirencePart(10, 150))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Poison", -25, new PotionRewardType(new PotionPart(new PotionEffect(Potion.field_76436_u.field_76415_H, 320)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:ChatMessage", 0, new MessageRewardType(new MessagePart("You have escaped the wrath of the Chance Cubes........."), new MessagePart("For now......"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Wool", 25, new ItemRewardType(new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 0)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 1)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 2)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 3)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 4)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 5)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 6)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 7)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 8)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 9)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 10)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 11)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 12)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 13)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 14)), new ItemPart(new ItemStack(Blocks.field_150325_L, 4, 15)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Beacon", 100, new ItemRewardType(new ItemPart(new ItemStack((Block)Blocks.field_150461_bJ)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Cake", 80, new ItemRewardType(new ItemPart(new ItemStack(Items.field_151105_aU, 1))), new MessageRewardType(new MessagePart("But is it a lie?"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Enchanting", 95, new ItemRewardType(new ItemPart(new ItemStack(Blocks.field_150381_bn)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Bookshelves", 50, new ItemRewardType(new ItemPart(new ItemStack(Blocks.field_150342_X, 8)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Ores_Galore", 65, new ItemRewardType(new ItemPart(new ItemStack(Items.field_151044_h)), new ItemPart(new ItemStack(Items.field_151137_ax)), new ItemPart(new ItemStack(Items.field_151042_j)), new ItemPart(new ItemStack(Items.field_151043_k)), new ItemPart(new ItemStack(Items.field_151045_i)), new ItemPart(new ItemStack(Items.field_151166_bC)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Have_Another", 0, new ItemRewardType(new ItemPart(new ItemStack(CCubesBlocks.chanceCube, 3))), new MessageRewardType(new MessagePart("I hear you like Chance Cubes."), new MessagePart("So I put some Chance Cubes in your Chance Cubes!"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Icsahedron", 0, new ItemRewardType(new ItemPart(new ItemStack(CCubesBlocks.chanceIcosahedron)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Saplings", 35, new ItemRewardType(new ItemPart(new ItemStack(Blocks.field_150345_g, 4, 0)), new ItemPart(new ItemStack(Blocks.field_150345_g, 4, 1)), new ItemPart(new ItemStack(Blocks.field_150345_g, 4, 2)), new ItemPart(new ItemStack(Blocks.field_150345_g, 4, 3)), new ItemPart(new ItemStack(Blocks.field_150345_g, 4, 4)), new ItemPart(new ItemStack(Blocks.field_150345_g, 4, 5)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Farmer", 35, new MessageRewardType(new MessagePart("Time to farm!")), new ItemRewardType(new ItemPart(new ItemStack(Items.field_151019_K)), new ItemPart(new ItemStack(Items.field_151133_ar)), new ItemPart(new ItemStack(Items.field_151014_N, 16)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Rancher", 60, new ItemRewardType(new ItemPart(new ItemStack(Blocks.field_150422_aJ, 32)), new ItemPart(new ItemStack(Items.field_151063_bx, 1, 90)), new ItemPart(new ItemStack(Items.field_151063_bx, 1, 91)), new ItemPart(new ItemStack(Items.field_151063_bx, 1, 92)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Fighter", 30, new MessageRewardType(new MessagePart("SPARTAAA!!!")), new ItemRewardType(new ItemPart(new ItemStack(Items.field_151040_l)), new ItemPart(new ItemStack((Item)Items.field_151028_Y)), new ItemPart(new ItemStack((Item)Items.field_151030_Z)), new ItemPart(new ItemStack((Item)Items.field_151165_aa)), new ItemPart(new ItemStack((Item)Items.field_151167_ab)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:pssst", -5, new MessageRewardType(new MessagePart("Pssssst.... Over here!")), new EntityRewardType(new EntityPart(EntityRewardType.getBasicNBTForEntity("Creeper")))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Explorer", 45, new MessageRewardType(new MessagePart("Lets go on a journey!")), new ItemRewardType(new ItemPart(new ItemStack(Items.field_151111_aL)), new ItemPart(new ItemStack(Items.field_151113_aN)), new ItemPart(new ItemStack(Blocks.field_150478_aa, 64)), new ItemPart(new ItemStack(Items.field_151035_b)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Mitas", 75, new ItemRewardType(new ItemPart(new ItemStack(Items.field_151074_bl, 32)), new ItemPart(new ItemStack(Items.field_151043_k, 8)), new ItemPart(new ItemStack(Items.field_151150_bK, 16)), new ItemPart(new ItemStack((Item)Items.field_151169_ag)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Horde", -65, new MessageRewardType(new MessagePart("Release the horde!")), new EntityRewardType(RewardsUtil.SpawnXEntities(EntityRewardType.getBasicNBTForEntity("Zombie"), 15))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Insta-Damage", -25, new PotionRewardType(new PotionPart(new PotionEffect(Potion.field_76433_i.field_76415_H, 2)), new PotionPart(new PotionEffect(Potion.field_76433_i.field_76415_H, 2)), new PotionPart(new PotionEffect(Potion.field_76433_i.field_76415_H, 2)), new PotionPart(new PotionEffect(Potion.field_76433_i.field_76415_H, 2)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Lava_Ring", -70, new BlockRewardType(new OffsetBlock(1, -1, 0, Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(1, -1, 1, Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(0, -1, 1, Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, 1, Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, 0, Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(-1, -1, -1, Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(0, -1, -1, Blocks.field_150353_l, false).setRelativeToPlayer(true), new OffsetBlock(1, -1, -1, Blocks.field_150353_l, false).setRelativeToPlayer(true))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Rain", 0, new CommandRewardType(new CommandPart("/weather thunder 20000"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Silverfish_Surround", -35, new BlockRewardType(new OffsetBlock(1, 0, 0, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(1, 1, 0, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(0, 0, 1, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(0, 1, 1, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(-1, 0, 0, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(-1, 1, 0, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(0, 0, -1, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(0, 1, -1, Blocks.field_150418_aU, false).setRelativeToPlayer(true), new OffsetBlock(0, 2, 0, Blocks.field_150418_aU, false).setRelativeToPlayer(true))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Fish_Dog", 20, new ItemRewardType(new ItemPart(new ItemStack(Items.field_151115_aP, 5)), new ItemPart(new ItemStack(Items.field_151063_bx, 1, 95)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Bone_Cat", 20, new ItemRewardType(new ItemPart(new ItemStack(Items.field_151103_aS, 5)), new ItemPart(new ItemStack(Items.field_151063_bx, 1, 98)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:XP_Crystal", -75, new CommandRewardType(new CommandPart("/summon EnderCrystal %x %y %z {Value:1,Riding:{id:\"XPOrb\"}}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:TNT_Cat", -40, new CommandRewardType(new CommandPart("/summon PrimedTnt %x %y %z {Fuse:80,Riding:{id:\"Ozelot\",CatType:0,Sitting:0}}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:SlimeMan", 10, new CommandRewardType(new CommandPart("/summon Slime %x %y %z {CustomName:\"SlimeMan\",CustomNameVisible:1,Size:1,Riding:{id:\"Slime\",Size:2,Riding:{id:\"Slime\",Size:3}}}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Sail_Away", 5, new BlockRewardType(new OffsetBlock(0, -1, 0, Blocks.field_150355_j, false)), new CommandRewardType(new CommandPart("/summon Boat %x %y %z")), new MessageRewardType(new MessagePart("Come sail away!"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Witch", -40, new CommandRewardType(new CommandPart("/summon Witch %x %y %z "))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Spawn_Cluckington", 40, new CommandRewardType(new CommandPart("/summon Zombie ~ ~1 ~ {CustomName:\"Wyld\",CustomNameVisible:1,IsBaby:1,Riding:{id:\"Chicken\",CustomName:\"Cluckinton\",CustomNameVisible:1,IsChickenJockey:1}}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Spawn_Jerry", 40, new CommandRewardType(new CommandPart("/summon Slime %x %y %z {Size:1,CustomName:\"Jerry\",CustomNameVisible:1}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Spawn_Glenn", 40, new CommandRewardType(new CommandPart("/summon Zombie %x %y %z {CustomName:\"Glenn\",CustomNameVisible:1}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Want_To_Build_A_Snowman", 45, new MessageRewardType(new MessagePart("Do you want to build a snowman?")), new ItemRewardType(new ItemPart(new ItemStack(Blocks.field_150433_aE, 2)), new ItemPart(new ItemStack(Blocks.field_150423_aK)))));
        INSTANCE.registerReward(new BasicReward("chancecubes:You_saw_nothing", 0, new MessageRewardType(new MessagePart("You didn't see anything......"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Diamond_Block", 85, new BlockRewardType(new OffsetBlock(0, 0, 0, Blocks.field_150484_ah, true, 200))));
        INSTANCE.registerReward(new BasicReward("chancecubes:TNT_Diamond", -35, new BlockRewardType(new OffsetBlock(0, 1, 0, Blocks.field_150484_ah, false), new OffsetBlock(0, -1, 0, Blocks.field_150484_ah, false), new OffsetBlock(1, 0, 0, Blocks.field_150484_ah, false), new OffsetBlock(-1, 0, 0, Blocks.field_150484_ah, false), new OffsetBlock(0, 0, 1, Blocks.field_150484_ah, false), new OffsetBlock(0, 0, -1, Blocks.field_150484_ah, false)), new CommandRewardType(new CommandPart("/summon PrimedTnt %x %y %z {Fuse:40}"), new CommandPart("/summon PrimedTnt %x %y %z {Fuse:40}"), new CommandPart("/summon PrimedTnt %x %y %z {Fuse:40}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Anti_Slab", -15, new BlockRewardType(RewardsUtil.fillArea(3, 1, 3, Blocks.field_150343_Z, -1, 2, -1, false, 0, false, true))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Chance_Cube_Cube", -10, new BlockRewardType(new OffsetBlock(-1, 0, -1, CCubesBlocks.chanceCube, false), new OffsetBlock(-1, 0, -2, CCubesBlocks.chanceCube, false), new OffsetBlock(-2, 0, -1, CCubesBlocks.chanceCube, false), new OffsetBlock(-2, 0, -2, CCubesBlocks.chanceCube, false), new OffsetBlock(-1, 1, -1, CCubesBlocks.chanceCube, false), new OffsetBlock(-1, 1, -2, CCubesBlocks.chanceCube, false), new OffsetBlock(-2, 1, -1, CCubesBlocks.chanceCube, false), new OffsetBlock(-2, 1, -2, CCubesBlocks.chanceCube, false))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Fake_TNT", 0, new SoundRewardType(new SoundPart("game.tnt.primed"), new SoundPart("game.tnt.primed"), new SoundPart("game.tnt.primed"), new SoundPart("game.tnt.primed"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Invisible_Ghasts", 0, new SoundRewardType(new SoundPart("mob.ghast.scream"), new SoundPart("mob.ghast.moan"), new SoundPart("mob.ghast.moan"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:No", 0, new BlockRewardType(new OffsetBlock(0, 0, 0, CCubesBlocks.chanceCube, false)), new MessageRewardType(new MessagePart("No"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Invisible_Creeper", -75, new CommandRewardType(new CommandPart("/summon Creeper %x %y %z {ActiveEffects:[{Id:14,Amplifier:0,Duration:200,ShowParticles:0b}]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Knockback_Zobmie", -55, new CommandRewardType(new CommandPart("/summon Zombie ~ ~1 ~ {CustomName:\"Leonidas\",IsBaby:1,Equipment:[{id:280,Count:1,tag:{ench:[{id:19,lvl:10}]}},{},{},{},{}],DropChances:[0.0F,0.085F,0.085F,0.085F,0.085F]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Spawn_Dr_Trayaurus", 40, new CommandRewardType(new CommandPart("/summon Villager %x %y %z {CustomName:\"Dr Trayaurus\",CustomNameVisible:1,Profession:1}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Actual_Invisible_Ghast", -75, new CommandRewardType(new CommandPart("/summon Ghast ~ ~10 ~ {ActiveEffects:[{Id:14,Amplifier:0,Duration:2000,ShowParticles:0b}]}"))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Nether_Portal_Build", 90, new BlockRewardType(new OffsetBlock(-1, -1, 0, Blocks.field_150343_Z, true), new OffsetBlock(0, -1, 0, Blocks.field_150343_Z, true, 5), new OffsetBlock(1, 0, 0, Blocks.field_150343_Z, true, 10), new OffsetBlock(1, 1, 0, Blocks.field_150343_Z, true, 15), new OffsetBlock(1, 2, 0, Blocks.field_150343_Z, true, 20), new OffsetBlock(1, 3, 0, Blocks.field_150343_Z, true, 25), new OffsetBlock(-2, 0, 0, Blocks.field_150343_Z, true, 30), new OffsetBlock(-2, 1, 0, Blocks.field_150343_Z, true, 35), new OffsetBlock(-2, 2, 0, Blocks.field_150343_Z, true, 40), new OffsetBlock(-2, 3, 0, Blocks.field_150343_Z, true, 45), new OffsetBlock(-1, 4, 0, Blocks.field_150343_Z, true, 50), new OffsetBlock(0, 4, 0, Blocks.field_150343_Z, true, 55), new OffsetBlock(0, 0, 0, (Block)Blocks.field_150480_ab, false, 120).setCausesBlockUpdate(true))));
        INSTANCE.registerReward(new BasicReward("chancecubes:Giant_Chance_Cube", -10, new BlockRewardType(RewardsUtil.fillArea(3, 3, 3, CCubesBlocks.chanceCube, -1, 0, -1, false, 0, true, false))), false);
        ItemStack stack = new ItemStack(Items.field_151055_y);
        stack.func_77966_a(Enchantment.field_77338_j, 5);
        stack.func_151001_c("A Big Stick");
        INSTANCE.registerReward(new BasicReward("chancecubes:Roosevelt's_Stick", 90, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack((Item)Items.field_151112_aM);
        stack.func_77964_b(stack.func_77958_k() / 2);
        INSTANCE.registerReward(new BasicReward("chancecubes:Half_Fishingrod", 5, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack(Items.field_151153_ao, 1, 1);
        stack.func_151001_c("Notch");
        INSTANCE.registerReward(new BasicReward("chancecubes:Notch", 100, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack(Items.field_151156_bN);
        stack.func_151001_c("North Star");
        INSTANCE.registerReward(new BasicReward("chancecubes:Nether_Star", 100, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack(Items.field_151048_u);
        stack.func_77966_a(Enchantment.field_77338_j, 10);
        stack.func_77966_a(Enchantment.field_77347_r, 10);
        stack.func_77964_b(stack.func_77958_k() - 2);
        stack.func_151001_c("The Divine Sword");
        INSTANCE.registerReward(new BasicReward("chancecubes:Divine", 100, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack(Items.field_151039_o);
        stack.func_77966_a(Enchantment.field_77349_p, 10);
        stack.func_77966_a(Enchantment.field_77346_s, 3);
        stack.func_151001_c("Giga Breaker");
        INSTANCE.registerReward(new BasicReward("chancecubes:Giga_Breaker", 95, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack((Item)Items.field_151031_f);
        stack.func_77964_b(stack.func_77958_k());
        stack.func_77966_a(Enchantment.field_77345_t, 5);
        stack.func_77966_a(Enchantment.field_77344_u, 3);
        stack.func_77966_a(Enchantment.field_77343_v, 2);
        INSTANCE.registerReward(new BasicReward("chancecubes:One_Shot", 100, new ItemRewardType(new ItemPart(stack), new ItemPart(new ItemStack(Items.field_151032_g, 1)))));
        stack = new ItemStack(Items.field_151115_aP, 1, 2);
        stack.func_151001_c("Nemo");
        INSTANCE.registerReward(new BasicReward("chancecubes:Finding_Nemo", 15, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack(Items.field_151115_aP, 1, 2);
        stack.func_151001_c("Marlin");
        INSTANCE.registerReward(new BasicReward("chancecubes:Finding_Marlin", 15, new ItemRewardType(new ItemPart(stack))));
        stack = new ItemStack((Block)Blocks.field_150480_ab, 1);
        stack.func_77966_a(Enchantment.field_77334_n, 2);
        stack.func_151001_c("Why not?");
        INSTANCE.registerReward(new BasicReward("chancecubes:Fire_Aspect_Fire", 70, new ItemRewardType(new ItemPart(stack))));
        OffsetBlock[] blocks = new OffsetBlock[35];
        int i = 0;
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 5; ++x) {
                for (int z = 0; z < 5; ++z) {
                    if (y == 1 && (x == 0 || x == 4 || z == 0 || z == 4)) continue;
                    blocks[i] = new OffsetBlock(x - 2, y, z - 2, Blocks.field_150339_S, true, (x * 5 + z) * (y + 1) * 5);
                    ++i;
                }
            }
        }
        blocks[i] = new OffsetBlock(0, 2, 0, (Block)Blocks.field_150461_bJ, true, 200);
        INSTANCE.registerReward(new BasicReward("chancecubes:Beacon_Build", 99, new BlockRewardType(blocks)));
        INSTANCE.registerReward(new NukeReward());
        INSTANCE.registerReward(new FiveProngReward());
        INSTANCE.registerReward(new AnvilRain());
        INSTANCE.registerReward(new HerobrineReward());
        INSTANCE.registerReward(new SurroundedReward());
        INSTANCE.registerReward(new CreeperSurroundedReward());
        INSTANCE.registerReward(new RandomTeleportReward());
        INSTANCE.registerReward(new TrollHoleReward());
        INSTANCE.registerReward(new CookieMonsterReward());
        INSTANCE.registerReward(new BlindnessFightReward());
        INSTANCE.registerReward(new WitherReward());
        INSTANCE.registerReward(new TrollTNTReward());
        INSTANCE.registerReward(new EnderCrystalTimerReward());
        INSTANCE.registerReward(new WaitForItReward());
        INSTANCE.registerReward(new ChargedCreeperReward());
        INSTANCE.registerReward(new ZombieCopyCatReward());
        INSTANCE.registerReward(new InventoryChestReward());
        INSTANCE.registerReward(new ItemOfDestinyReward());
        INSTANCE.registerReward(new ThrownInAirReward());
        INSTANCE.registerReward(new DiscoReward());
        INSTANCE.registerReward(new InventoryBombReward());
        INSTANCE.registerReward(new ClearInventoryReward(), false);
        INSTANCE.registerReward(new BasicReward("chancecubes:Half_Heart", -30, new IRewardType[0]){

            @Override
            public void trigger(World world, int x, int y, int z, EntityPlayer player) {
                player.func_70606_j(1.0f);
            }
        });
        MathReward math = new MathReward();
        MinecraftForge.EVENT_BUS.register((Object)math);
        INSTANCE.registerReward(math);
    }

    @Override
    public void registerReward(IChanceCubeReward reward) {
        this.registerReward(reward, true);
    }

    public void registerReward(IChanceCubeReward reward, boolean enabledDefault) {
        if (ConfigLoader.config.getBoolean(reward.getName(), "Rewards", enabledDefault, "") && !this.nameToReward.containsKey(reward.getName())) {
            this.nameToReward.put(reward.getName(), reward);
            this.redoSort(reward);
        }
    }

    @Override
    public boolean unregisterReward(String name) {
        IChanceCubeReward o = this.nameToReward.remove(name);
        if (o != null) {
            return this.sortedRewards.remove(o);
        }
        return false;
    }

    @Override
    public IChanceCubeReward getRewardByName(String name) {
        return this.nameToReward.get(name);
    }

    @Override
    public void triggerRandomReward(World world, int x, int y, int z, EntityPlayer player, int chance) {
        int upperRange;
        if (this.sortedRewards.size() == 0) {
            CCubesCore.logger.log(Level.WARN, "There are no registered rewards with ChanceCubes and no reward was able to be given");
            return;
        }
        if (CCubesSettings.doesHolidayRewardTrigger && CCubesSettings.holidayReward != null) {
            CCubesSettings.holidayReward.trigger(world, x, y, z, player);
            CCubesSettings.doesHolidayRewardTrigger = false;
            CCubesSettings.holidayRewardTriggered = true;
            ConfigLoader.config.get("General Settings", "HolidayRewardTriggered", false, "Don't touch! Well I mean you can touch it, if you want. I can't stop you. I'm only text.").setValue(true);
            ConfigLoader.config.save();
            return;
        }
        if (player != null) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack stack = player.field_71071_by.field_70462_a[i];
                if (stack == null || !(stack.func_77973_b() instanceof ItemChancePendant)) continue;
                ItemChancePendant pendant = (ItemChancePendant)stack.func_77973_b();
                pendant.damage(stack);
                if (stack.func_77960_j() >= CCubesSettings.pendantUses) {
                    player.field_71071_by.func_70299_a(i, null);
                }
                if ((chance += pendant.getChanceIncrease()) <= 100) continue;
                chance = 100;
            }
        }
        int lowerIndex = 0;
        int upperIndex = this.sortedRewards.size() - 1;
        int lowerRange = chance - CCubesSettings.rangeMin < -100 ? -100 : chance - CCubesSettings.rangeMin;
        int n = upperRange = chance + CCubesSettings.rangeMax > 100 ? 100 : chance + CCubesSettings.rangeMax;
        while (this.sortedRewards.get(lowerIndex).getChanceValue() < lowerRange) {
            if (++lowerIndex < this.sortedRewards.size()) continue;
            --lowerIndex;
            break;
        }
        while (this.sortedRewards.get(upperIndex).getChanceValue() > upperRange) {
            if (--upperIndex >= 0) continue;
            ++upperIndex;
            break;
        }
        int range = upperIndex - lowerIndex > 0 ? upperIndex - lowerIndex : 1;
        int pick = world.field_73012_v.nextInt(range) + lowerIndex;
        CCubesCore.logger.log(Level.INFO, "Triggered the reward with the name of: " + this.sortedRewards.get(pick).getName());
        this.sortedRewards.get(pick).trigger(world, x, y, z, player);
    }

    private void redoSort(@Nullable IChanceCubeReward newReward) {
        if (newReward != null) {
            this.sortedRewards.add(newReward);
        }
        Collections.sort(this.sortedRewards, new Comparator<IChanceCubeReward>(){

            @Override
            public int compare(IChanceCubeReward o1, IChanceCubeReward o2) {
                return o1.getChanceValue() - o2.getChanceValue();
            }
        });
    }

    public void ClearRewards() {
        this.sortedRewards.clear();
        this.nameToReward.clear();
    }
}

