/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.biodomeGen;

import chanceCubes.rewards.biodomeGen.IBioDomeBiome;
import chanceCubes.rewards.rewardparts.OffsetBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import org.lwjgl.util.vector.Vector3f;

public class BasicTreesBiome
implements IBioDomeBiome {
    private Random rand = new Random();

    @Override
    public List<OffsetBlock> genDome(int centerX, int centerY, int centerZ, World world) {
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        int delay = 0;
        int delayShorten = 10;
        for (int y = 0; y <= 25; ++y) {
            for (int x = -25; x <= 25; ++x) {
                for (int z = -25; z <= 25; ++z) {
                    Vector3f vector = new Vector3f((float)x, (float)y, (float)z);
                    float dist = Math.abs(vector.length()) - 25.0f;
                    if (!(dist < 1.0f)) continue;
                    if (dist >= 0.0f) {
                        blocks.add(new OffsetBlock(x, y, z, Blocks.field_150359_w, false, delay / delayShorten));
                        ++delay;
                        continue;
                    }
                    if (y != 0) continue;
                    blocks.add(new OffsetBlock(x, y, z, (Block)Blocks.field_150349_c, false, delay / delayShorten));
                    ++delay;
                    if (dist < 0.0f && this.rand.nextInt(5) == 0) {
                        OffsetBlock osb = new OffsetBlock(x, y + 1, z, (Block)Blocks.field_150329_H, false, delay / delayShorten);
                        osb.setData((byte)1);
                        blocks.add(osb);
                        ++delay;
                        continue;
                    }
                    if (!(dist < -5.0f) || this.rand.nextInt(100) != 0) continue;
                    List<OffsetBlock> treeblocks = this.addTree(x, y, z, delay / delayShorten);
                    blocks.addAll(treeblocks);
                }
            }
        }
        return blocks;
    }

    public List<OffsetBlock> addTree(int x, int y, int z, int delay) {
        ArrayList<OffsetBlock> blocks = new ArrayList<OffsetBlock>();
        for (int yy = 1; yy < 6; ++yy) {
            blocks.add(new OffsetBlock(x, y + yy, z, Blocks.field_150364_r, false, delay));
            ++delay;
        }
        for (int xx = -2; xx < 3; ++xx) {
            for (int zz = -2; zz < 3; ++zz) {
                for (int yy = 0; yy < 2; ++yy) {
                    if (xx == 0 && zz == 0) continue;
                    blocks.add(new OffsetBlock(x + xx, y + 4 + yy, z + zz, (Block)Blocks.field_150362_t, false, delay));
                    ++delay;
                }
            }
        }
        blocks.add(new OffsetBlock(x + 1, y + 6, z, (Block)Blocks.field_150362_t, false, delay));
        blocks.add(new OffsetBlock(x - 1, y + 6, z, (Block)Blocks.field_150362_t, false, ++delay));
        blocks.add(new OffsetBlock(x, y + 6, z + 1, (Block)Blocks.field_150362_t, false, ++delay));
        blocks.add(new OffsetBlock(x, y + 6, z - 1, (Block)Blocks.field_150362_t, false, ++delay));
        blocks.add(new OffsetBlock(x, y + 6, z, (Block)Blocks.field_150362_t, false, ++delay));
        ++delay;
        return blocks;
    }

    @Override
    public void spawnEntities(int centerX, int centerY, int centerZ, World world) {
        for (int i = 0; i < this.rand.nextInt(10) + 5; ++i) {
            int ri = this.rand.nextInt(5);
            if (ri == 0) {
                EntityChicken chicken = new EntityChicken(world);
                chicken.func_70012_b((double)(centerX + (this.rand.nextInt(31) - 15)), (double)(centerY + 1), (double)(centerZ + (this.rand.nextInt(31) - 15)), 0.0f, 0.0f);
                world.func_72838_d((Entity)chicken);
                continue;
            }
            if (ri == 1) {
                EntityCow cow = new EntityCow(world);
                cow.func_70012_b((double)(centerX + (this.rand.nextInt(31) - 15)), (double)(centerY + 1), (double)(centerZ + (this.rand.nextInt(31) - 15)), 0.0f, 0.0f);
                world.func_72838_d((Entity)cow);
                continue;
            }
            if (ri == 2) {
                EntityHorse horse = new EntityHorse(world);
                horse.func_70012_b((double)(centerX + (this.rand.nextInt(31) - 15)), (double)(centerY + 1), (double)(centerZ + (this.rand.nextInt(31) - 15)), 0.0f, 0.0f);
                world.func_72838_d((Entity)horse);
                continue;
            }
            if (ri == 3) {
                EntityPig pig = new EntityPig(world);
                pig.func_70012_b((double)(centerX + (this.rand.nextInt(31) - 15)), (double)(centerY + 1), (double)(centerZ + (this.rand.nextInt(31) - 15)), 0.0f, 0.0f);
                world.func_72838_d((Entity)pig);
                continue;
            }
            if (ri != 4) continue;
            EntitySheep sheep = new EntitySheep(world);
            sheep.func_70012_b((double)(centerX + (this.rand.nextInt(31) - 15)), (double)(centerY + 1), (double)(centerZ + (this.rand.nextInt(31) - 15)), 0.0f, 0.0f);
            world.func_72838_d((Entity)sheep);
        }
    }
}

