/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import ivorius.ivtoolkit.blocks.BlockAreaIterator;
import ivorius.ivtoolkit.blocks.BlockCoord;
import java.util.Iterator;
import net.minecraft.util.AxisAlignedBB;

public class BlockArea
implements Iterable<BlockCoord> {
    private BlockCoord point1;
    private BlockCoord point2;

    public BlockArea(BlockCoord point1, BlockCoord point2) {
        this.point1 = point1;
        this.point2 = point2;
    }

    public static BlockArea areaFromSize(BlockCoord coord, int[] size) {
        if (size[0] <= 0 || size[1] <= 0 || size[2] <= 0) {
            throw new IllegalArgumentException();
        }
        return new BlockArea(coord, new BlockCoord(coord.x + size[0] - 1, coord.y + size[1] - 1, coord.z + size[2] - 1));
    }

    public BlockCoord getPoint1() {
        return this.point1;
    }

    public void setPoint1(BlockCoord point1) {
        this.point1 = point1;
    }

    public BlockCoord getPoint2() {
        return this.point2;
    }

    public void setPoint2(BlockCoord point2) {
        this.point2 = point2;
    }

    public BlockCoord getLowerCorner() {
        return this.point1.getLowerCorner(this.point2);
    }

    public BlockCoord getHigherCorner() {
        return this.point1.getHigherCorner(this.point2);
    }

    public int[] areaSize() {
        BlockCoord lower = this.getLowerCorner();
        BlockCoord higher = this.getHigherCorner();
        return new int[]{higher.x - lower.x + 1, higher.y - lower.y + 1, higher.z - lower.z + 1};
    }

    public boolean contains(BlockCoord coord) {
        BlockCoord lower = this.getLowerCorner();
        BlockCoord higher = this.getHigherCorner();
        return coord.x >= lower.x && coord.y >= lower.y && coord.z >= lower.z && coord.x <= higher.x && coord.y <= higher.y && coord.z <= higher.z;
    }

    public AxisAlignedBB asAxisAlignedBB() {
        BlockCoord lower = this.getLowerCorner();
        BlockCoord higher = this.getHigherCorner();
        return AxisAlignedBB.func_72330_a((double)lower.x, (double)lower.y, (double)lower.z, (double)higher.x, (double)higher.y, (double)higher.z);
    }

    @Override
    public Iterator<BlockCoord> iterator() {
        return new BlockAreaIterator(this.getLowerCorner(), this.getHigherCorner());
    }
}

