/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.random;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;

public class WeightedSelector {
    public static <T extends Item> double totalWeight(Collection<T> items) {
        double totalWeight = 0.0;
        for (Item t : items) {
            totalWeight += t.getWeight();
        }
        return totalWeight;
    }

    public static <T> double totalWeight(Collection<T> items, WeightFunction<T> weightFunction) {
        return WeightedSelector.totalWeight(SimpleItem.apply(items, weightFunction));
    }

    public static boolean canSelect(Collection<? extends Item> items) {
        for (Item item : items) {
            if (!(item.getWeight() > 0.0)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean canSelect(Collection<T> items, WeightFunction<T> weightFunction) {
        for (T item : items) {
            if (!(weightFunction.apply(item) > 0.0)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Item> T selectItem(Random rand, Collection<T> items) {
        return WeightedSelector.selectItem(rand, items, WeightedSelector.totalWeight(items));
    }

    public static <T extends Item> T selectItem(Random rand, Collection<T> items, double totalWeight) {
        if (items.size() == 0) {
            throw new IndexOutOfBoundsException();
        }
        double random = rand.nextDouble() * totalWeight;
        Item last = null;
        Iterator<T> i$ = items.iterator();
        while (i$.hasNext()) {
            Item t;
            last = t = (Item)i$.next();
            if (!((random -= t.getWeight()) <= 0.0)) continue;
            return (T)t;
        }
        return (T)last;
    }

    public static <T> T select(Random rand, Collection<T> items, WeightFunction<T> weightFunction) {
        return WeightedSelector.select(rand, SimpleItem.apply(items, weightFunction));
    }

    public static <T> T select(Random rand, Collection<T> items, WeightFunction<T> weightFunction, double totalWeight) {
        return WeightedSelector.select(rand, SimpleItem.apply(items, weightFunction), totalWeight);
    }

    public static <T> T select(Random rand, Collection<SimpleItem<T>> items) {
        return WeightedSelector.select(rand, items, WeightedSelector.totalWeight(items));
    }

    public static <T> T select(Random rand, Collection<SimpleItem<T>> items, double totalWeight) {
        return WeightedSelector.selectItem(rand, items, totalWeight).getItem();
    }

    public static interface WeightFunction<T> {
        public double apply(T var1);
    }

    public static class SimpleItem<T>
    implements Item {
        protected final double weight;
        protected final T item;

        public SimpleItem(double weight, T item) {
            this.item = item;
            this.weight = weight;
        }

        public static <T> SimpleItem<T> of(double weight, T item) {
            return new SimpleItem<T>(weight, item);
        }

        public static <T> Collection<SimpleItem<T>> apply(Collection<T> items, final WeightFunction<T> weightFunction) {
            return Collections2.transform(items, (Function)new Function<T, SimpleItem<T>>(){

                @Nullable
                public SimpleItem<T> apply(@Nullable T input) {
                    return new SimpleItem(weightFunction.apply(input), input);
                }
            });
        }

        public T getItem() {
            return this.item;
        }

        @Override
        public double getWeight() {
            return this.weight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleItem that = (SimpleItem)o;
            if (Double.compare(that.weight, this.weight) != 0) {
                return false;
            }
            return !(this.item != null ? !this.item.equals(that.item) : that.item != null);
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.weight);
            int result = (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.item != null ? this.item.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "SimpleItem{weight=" + this.weight + ", item=" + this.item + '}';
        }
    }

    public static interface Item {
        public double getWeight();
    }
}

