/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.kappaexperience.emote;

import com.google.gson.Gson;
import com.lordmau5.kappaexperience.emote.Channel;
import com.lordmau5.kappaexperience.emote.Emote;
import com.lordmau5.kappaexperience.emote.IEmote;
import com.lordmau5.kappaexperience.util.GenericUtil;
import com.lordmau5.kappaexperience.util.SortedArrayList;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EmoteRegistry {
    private static Map<String, IEmote> emoteList = new HashMap<String, IEmote>();
    private static SortedArrayList<Channel> loadedSubs = new SortedArrayList();
    private static Map<String, BufferedImage> emoteCache = new HashMap<String, BufferedImage>();

    public static void init() {
        String jsonText = GenericUtil.readURL("http://twitchemotes.com/api_cache/v2/global.json");
        if (!jsonText.isEmpty()) {
            Gson gson = new Gson();
            Map ar = (Map)gson.fromJson(jsonText, Map.class);
            ar = (Map)ar.get("emotes");
            Iterator i$ = ar.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = i$.next();
                Map map = (Map)entry.getValue();
                Double number = (Double)map.get("image_id");
                EmoteRegistry.addEmote(new Emote((String)entry.getKey(), "Global", "http://static-cdn.jtvnw.net/emoticons/v1/" + number.intValue() + "/1.0"));
            }
        }
        EmoteRegistry.loadSubscribers();
    }

    public static void loadSubscribers() {
        String subscriberJson = GenericUtil.readURL("http://twitchemotes.com/api_cache/v2/subscriber.json");
        if (!subscriberJson.isEmpty()) {
            Gson gson = new Gson();
            Map ar = (Map)gson.fromJson(subscriberJson, Map.class);
            ar = (Map)ar.get("channels");
            Iterator i$ = ar.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = i$.next();
                SortedArrayList<IEmote> subEmotes = new SortedArrayList<IEmote>();
                String name = (String)entry.getKey();
                ar = (Map)entry.getValue();
                ArrayList emoteMap = (ArrayList)ar.get("emotes");
                for (Map map : emoteMap) {
                    String code = (String)map.get("code");
                    int number = ((Double)map.get("image_id")).intValue();
                    Emote emote = new Emote(code, name, "http://static-cdn.jtvnw.net/emoticons/v1/" + number + "/1.0");
                    EmoteRegistry.addEmote(emote);
                    subEmotes.insertSorted(emote);
                }
                loadedSubs.insertSorted(new Channel(name, subEmotes));
            }
        }
    }

    public static void cacheEmote(String emoteName, BufferedImage image) {
        if (!emoteCache.containsKey(emoteName)) {
            emoteCache.put(emoteName, image);
        }
    }

    public static BufferedImage getCachedEmote(String emoteName) {
        if (!emoteCache.containsKey(emoteName)) {
            return null;
        }
        return emoteCache.get(emoteName);
    }

    public static void addEmote(IEmote emote) {
        if (!emoteList.containsKey(emote.getName())) {
            emoteList.put(emote.getName(), emote);
        }
    }

    public static void removeEmote(IEmote emote) {
        if (emoteList.containsKey(emote.getName())) {
            emoteList.remove(emote.getName());
        }
    }

    public static List<Channel> getLoadedChannels() {
        return loadedSubs;
    }

    public static List<IEmote> getEmotesForChannel(String name) {
        Channel tempChan = new Channel(name = name.toLowerCase(), null);
        if (!loadedSubs.contains(tempChan)) {
            return null;
        }
        for (int i = 0; i < loadedSubs.size(); ++i) {
            if (!((Channel)loadedSubs.get(i)).getChannelName().toLowerCase().equals(name)) continue;
            return ((Channel)loadedSubs.get(i)).getChannelEmotes();
        }
        return null;
    }

    public static List<String> getFoundChannels(String arg) {
        ArrayList<String> chans = new ArrayList<String>();
        for (Channel channel : loadedSubs) {
            String name = channel.getChannelName().toLowerCase();
            if (!name.contains(arg)) continue;
            chans.add(name);
        }
        return chans;
    }

    public static List<String> getTabCompleteChannels(String arg) {
        ArrayList<String> chans = new ArrayList<String>();
        for (Channel channel : loadedSubs) {
            String name = channel.getChannelName();
            if (!name.toLowerCase().startsWith(arg.toLowerCase())) continue;
            chans.add(name);
        }
        return chans;
    }

    public static IEmote getEmoteFromName(String name) {
        if (!emoteList.containsKey(name)) {
            return null;
        }
        return emoteList.get(name);
    }
}

