/*
 * Decompiled with CFR 0.152.
 */
package com.lordmau5.kappaexperience.handler;

import com.lordmau5.kappaexperience.emote.ChatComponentEmote;
import com.lordmau5.kappaexperience.emote.EmoteRegistry;
import com.lordmau5.kappaexperience.emote.IEmote;
import com.lordmau5.kappaexperience.handler.RenderHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class RenderHandler {
    private List<String> tooltipString;
    private boolean tooltip;

    @SubscribeEvent
    public void renderTick(RenderGameOverlayEvent event) {
        if (event.type != RenderGameOverlayEvent.ElementType.CHAT) {
            return;
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        GuiNewChat chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        boolean isOpen = chat.func_146241_e();
        int upScrolled = chat.field_146250_j;
        List chatLines = chat.field_146252_h;
        this.tooltip = false;
        if (chatLines != null && chatLines.size() > 0) {
            for (int i = chatLines.size() - 1; i >= 0; --i) {
                ChatLine l = (ChatLine)chatLines.get(i);
                IChatComponent icc = l.func_151461_a();
                if (!(icc instanceof ChatComponentText)) continue;
                ChatComponentText cct = (ChatComponentText)icc;
                List siblings = cct.func_150253_a();
                for (Object o : siblings) {
                    if (!(o instanceof ChatComponentEmote)) continue;
                    ChatComponentEmote emote = (ChatComponentEmote)((Object)o);
                    this.renderEmote(emote.getPos() - 3, i, emote.getEmote(), l, isOpen, upScrolled, chatLines, event);
                }
            }
        }
        if (this.tooltip) {
            RenderHelper.drawHoveringText(this.tooltipString, event.mouseX - 6, event.mouseY - 12, fr);
        }
    }

    private boolean isEmoteInChatWindow(int lineY, int yOffset, int upScrolled, boolean isOpen) {
        lineY -= upScrolled;
        lineY *= 9;
        float flt = (isOpen ? Minecraft.func_71410_x().field_71474_y.field_96694_H : Minecraft.func_71410_x().field_71474_y.field_96693_G) * 180.0f;
        if ((lineY += yOffset) >= 0) {
            int n = isOpen ? 0 : -9;
            if ((float)(lineY + n) < flt) {
                return true;
            }
        }
        return false;
    }

    public void renderEmote(double x, int lineY, IEmote emote, ChatLine line, boolean isOpen, int upScrolled, List chatLines, RenderGameOverlayEvent ev) {
        Object chatLine;
        ChatLine oLine;
        int k1 = Minecraft.func_71410_x().field_71456_v.func_73834_c() - line.func_74540_b();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int yOffset = 0;
        float maxWidth = Minecraft.func_71410_x().field_71474_y.field_96692_F * 320.0f;
        String leString = line.func_151461_a().func_150261_e();
        if ((float)fr.func_78256_a(leString) > maxWidth) {
            if (x > (double)maxWidth) {
                x -= (double)maxWidth;
                x += 9.0;
            } else {
                yOffset = 9;
            }
        }
        Iterator i$ = chatLines.iterator();
        while (i$.hasNext() && (oLine = (ChatLine)(chatLine = i$.next())) != line) {
            if (!((float)fr.func_78256_a(oLine.func_151461_a().func_150261_e()) > maxWidth)) continue;
            yOffset += 9;
        }
        if (this.isEmoteInChatWindow(lineY, yOffset, upScrolled, isOpen) && (k1 < 200 || isOpen)) {
            double opacity;
            double d0 = (double)k1 / 200.0;
            d0 = 1.0 - d0;
            if ((d0 *= 10.0) < 0.0) {
                d0 = 0.0;
            }
            if (d0 > 1.0) {
                d0 = 1.0;
            }
            d0 *= d0;
            double i2 = 255.0 * d0;
            if (isOpen) {
                i2 = 255.0;
                d0 = 1.0;
            }
            if ((i2 = (double)((float)i2) * (opacity = (double)(Minecraft.func_71410_x().field_71474_y.field_74357_r * 0.9f + 0.1f))) > 3.0) {
                double mul;
                BufferedImage bi = emote.getImage();
                if (bi == null) {
                    return;
                }
                double emoteSize = 28.0;
                double renderSize = 14.0;
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                int tex = emote.getTex();
                if (tex == -1) {
                    emote.setTex(TextureUtil.func_110987_a((int)GL11.glGenTextures(), (BufferedImage)bi));
                    tex = emote.getTex();
                }
                if ((mul = renderSize / (double)bi.getWidth()) * (double)bi.getHeight() > renderSize) {
                    mul = renderSize / (double)bi.getHeight();
                }
                GL11.glBindTexture((int)3553, (int)tex);
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)d0);
                double x2 = x + 3.0 + (renderSize / 2.0 - mul * (double)bi.getWidth() / 2.0);
                double y = ev.resolution.func_78324_d() - (double)(9 * (lineY - upScrolled) + yOffset) - 32.0 - emoteSize / 3.0;
                if ((double)ev.mouseX >= x2 && (double)ev.mouseX < x2 + renderSize && (double)ev.mouseY >= y && (double)ev.mouseY < y + renderSize) {
                    this.tooltip = true;
                    this.tooltipString = emote.getTooltip();
                }
                GL11.glTranslated((double)x2, (double)y, (double)0.0);
                GL11.glScaled((double)mul, (double)mul, (double)1.0);
                RenderHelper.drawTexturedRect(0.0, 0.0, 0.0, 0.0, bi.getWidth(), bi.getHeight());
                GL11.glScaled((double)(1.0 / mul), (double)(1.0 / mul), (double)1.0);
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
        }
    }

    private static int getWidthEmoteWhitespace(String formattingCode, String text) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int offset = 0;
        String[] words = text.split("[^a-zA-Z0-9" + formattingCode + "']");
        for (int i = 0; i < words.length; ++i) {
            int nextOffset;
            offset = nextOffset = text.indexOf(words[i], offset);
            String properWord = words[i];
            while (properWord.startsWith(formattingCode) && properWord.length() >= 2) {
                properWord = properWord.substring(2);
            }
            while (properWord.contains(formattingCode)) {
                properWord = properWord.substring(0, properWord.lastIndexOf(formattingCode));
            }
            IEmote emote = EmoteRegistry.getEmoteFromName(properWord);
            if (emote == null) continue;
            text = text.substring(0, offset) + "   " + text.substring(offset + words[i].length());
        }
        return fr.func_78256_a(text);
    }

    public static List<IChatComponent> transformToEmote(IChatComponent component) {
        String properWord;
        int nextOffset;
        int i;
        String text;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        String formattingCode = "\u00a7";
        if (formattingCode.length() == 2) {
            formattingCode = formattingCode.substring(1);
        }
        ArrayList<ChatComponentEmote> firstLineEmotes = new ArrayList<ChatComponentEmote>();
        ArrayList<ChatComponentEmote> secondLineEmotes = new ArrayList<ChatComponentEmote>();
        int offset = 0;
        String adjustText = text = component.func_150254_d();
        String[] words = text.split("[^a-zA-Z0-9" + formattingCode + "']");
        for (int i2 = 0; i2 < words.length; ++i2) {
            IEmote emote2;
            int nextOffset2;
            offset = nextOffset2 = adjustText.indexOf(words[i2], offset);
            String properWord2 = words[i2];
            if (!formattingCode.isEmpty()) {
                while (properWord2.startsWith(formattingCode)) {
                    properWord2 = properWord2.substring(2);
                }
                while (properWord2.contains(formattingCode)) {
                    properWord2 = properWord2.substring(0, properWord2.lastIndexOf(formattingCode));
                }
            }
            if ((emote2 = EmoteRegistry.getEmoteFromName(properWord2)) == null) continue;
            adjustText = adjustText.substring(0, offset) + "   " + adjustText.substring(offset + words[i2].length());
        }
        offset = 0;
        float width = Minecraft.func_71410_x().field_71474_y.field_96692_F * 320.0f;
        String firstLine = text;
        String secondLine = adjustText;
        if ((float)fr.func_78256_a(adjustText) > width) {
            String zeChar;
            firstLine = text;
            if (firstLine.substring(firstLine.indexOf(">") + 2).contains(" ")) {
                while ((float)RenderHandler.getWidthEmoteWhitespace(formattingCode, firstLine) >= width) {
                    firstLine = firstLine.substring(0, firstLine.lastIndexOf(" "));
                }
            }
            while ((float)RenderHandler.getWidthEmoteWhitespace(formattingCode, firstLine) >= width) {
                zeChar = firstLine.substring(firstLine.length() - 1, firstLine.length());
                secondLine = zeChar + secondLine;
                firstLine = firstLine.substring(0, firstLine.length() - 1);
            }
            secondLine = text.substring(firstLine.length());
            if (!secondLine.startsWith(" ")) {
                secondLine = " " + secondLine;
            }
            if ((float)RenderHandler.getWidthEmoteWhitespace(formattingCode, secondLine) >= width) {
                firstLine = text;
                while ((float)RenderHandler.getWidthEmoteWhitespace(formattingCode, firstLine) >= width) {
                    firstLine = firstLine.substring(0, firstLine.length() - 1);
                }
                while ((float)RenderHandler.getWidthEmoteWhitespace(formattingCode, firstLine) >= width) {
                    zeChar = firstLine.substring(firstLine.length() - 1, firstLine.length());
                    secondLine = zeChar + secondLine;
                    firstLine = firstLine.substring(0, firstLine.length() - 1);
                }
                zeChar = firstLine.substring(firstLine.length() - 1, firstLine.length());
                firstLine = firstLine.substring(0, firstLine.length() - 1) + "-";
                secondLine = " " + zeChar + text.substring(firstLine.length());
            }
        } else {
            secondLine = "";
        }
        words = firstLine.split("[^a-zA-Z0-9" + formattingCode + "']");
        for (i = 0; i < words.length; ++i) {
            IEmote iEmote;
            offset = nextOffset = firstLine.indexOf(words[i], offset);
            properWord = words[i];
            if (!formattingCode.isEmpty()) {
                if (properWord.length() < 2) continue;
                while (properWord.startsWith(formattingCode)) {
                    properWord = properWord.substring(2);
                }
                while (properWord.contains(formattingCode)) {
                    properWord = properWord.substring(0, properWord.lastIndexOf(formattingCode));
                }
            }
            if ((iEmote = EmoteRegistry.getEmoteFromName(properWord)) == null) continue;
            firstLine = firstLine.substring(0, offset) + "   " + firstLine.substring(offset + words[i].length());
            firstLineEmotes.add(new ChatComponentEmote(iEmote, fr.func_78256_a(firstLine.substring(0, offset))));
        }
        if (!secondLine.isEmpty()) {
            offset = 0;
            words = secondLine.split("[^a-zA-Z0-9" + formattingCode + "']");
            for (i = 0; i < words.length; ++i) {
                IEmote iEmote;
                offset = nextOffset = secondLine.indexOf(words[i], offset);
                properWord = words[i];
                if (!formattingCode.isEmpty()) {
                    if (properWord.length() < 2) continue;
                    while (properWord.startsWith(formattingCode)) {
                        properWord = properWord.substring(2);
                    }
                    while (properWord.contains(formattingCode)) {
                        properWord = properWord.substring(0, properWord.lastIndexOf(formattingCode));
                    }
                }
                if ((iEmote = EmoteRegistry.getEmoteFromName(properWord)) == null) continue;
                secondLine = secondLine.substring(0, offset) + "   " + secondLine.substring(offset + words[i].length());
                secondLineEmotes.add(new ChatComponentEmote(iEmote, fr.func_78256_a(secondLine.substring(0, offset))));
            }
        }
        ChatComponentText cText1 = new ChatComponentText(firstLine);
        for (ChatComponentEmote emote3 : firstLineEmotes) {
            cText1.func_150257_a((IChatComponent)emote3);
        }
        ChatComponentText cText2 = new ChatComponentText(secondLine);
        for (ChatComponentEmote chatComponentEmote : secondLineEmotes) {
            cText2.func_150257_a((IChatComponent)chatComponentEmote);
        }
        ArrayList<IChatComponent> lines = new ArrayList<IChatComponent>();
        lines.add((IChatComponent)cText1);
        if (!secondLine.isEmpty()) {
            lines.add((IChatComponent)cText2);
        }
        return lines;
    }

    @SubscribeEvent
    public void chatEvent(ClientChatReceivedEvent event) {
        if (event.message instanceof ChatComponentTranslation) {
            List<IChatComponent> lines = RenderHandler.transformToEmote(event.message);
            EntityClientPlayerMP p = Minecraft.func_71410_x().field_71439_g;
            for (IChatComponent c : lines) {
                p.func_146105_b(c);
            }
            event.setCanceled(true);
        }
    }
}

