/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.entities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.core.utils.ForestryResource;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityBee
extends EntityCreature
implements IAnimals {
    private static final String DEFAULT_TEXTURE = "textures/entity/bees/honeyBee.png";
    IBee contained;
    IAlleleBeeSpecies species;
    EnumBeeType type = EnumBeeType.DRONE;
    private String beeTexture = "textures/entity/bees/honeyBee.png";
    private long lastUpdate;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation textureResource;
    private long lastTextureUpdate;

    public EntityBee(World world) {
        super(world);
    }

    private void resetAppearance() {
        this.beeTexture = this.species.getEntityTexture();
    }

    public EntityBee setIndividual(IBee bee) {
        this.contained = bee != null ? bee : BeeManager.beeRoot.templateAsIndividual(BeeManager.beeRoot.getDefaultTemplate());
        this.setSpecies(this.contained.getGenome().getPrimary());
        return this;
    }

    public IBee getBee() {
        return this.contained;
    }

    public EntityBee setType(EnumBeeType type) {
        this.type = type;
        return this;
    }

    public EnumBeeType getType() {
        return this.type;
    }

    public EntityBee setSpecies(IAlleleBeeSpecies species) {
        this.species = species;
        this.resetAppearance();
        this.lastUpdate = this.field_70170_p.func_82737_E();
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTexture() {
        if (this.textureResource == null || this.lastTextureUpdate != this.lastUpdate) {
            this.textureResource = new ForestryResource(this.beeTexture);
        }
        return this.textureResource;
    }
}

