/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import cofh.api.energy.IEnergyHandler;
import forestry.api.apiculture.IAlvearyComponent;
import forestry.apiculture.gadgets.TileAlveary;
import forestry.apiculture.network.PacketActiveUpdate;
import forestry.core.interfaces.IActivatable;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.proxy.Proxies;
import forestry.energy.EnergyManager;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileAlvearyClimatiser
extends TileAlveary
implements IEnergyHandler,
IActivatable {
    protected final EnergyManager energyManager;
    private final ClimateControl climateControl;
    private int workingTime = 0;
    private final int textureOff;
    private final int textureOn;
    private boolean active;

    public TileAlvearyClimatiser(ClimateControl control, int textureOff, int textureOn, int componentBlockMeta) {
        super(componentBlockMeta);
        this.climateControl = control;
        this.energyManager = new EnergyManager(1000, 50, 2000);
        this.energyManager.setReceiveOnly();
        this.textureOff = textureOff;
        this.textureOn = textureOn;
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (!this.hasMaster()) {
            return;
        }
        if (this.workingTime < 20 && this.energyManager.consumeEnergyToDoWork()) {
            this.workingTime += this.energyManager.getEnergyPerWork() / 10;
        }
        if (this.workingTime > 0) {
            --this.workingTime;
            IAlvearyComponent component = (IAlvearyComponent)this.getCentralTE();
            if (component != null) {
                component.addTemperatureChange(this.climateControl.changePerTransfer, this.climateControl.boundaryDown, this.climateControl.boundaryUp);
            }
        }
        this.setActive(this.workingTime > 0);
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    public int getIcon(int side, int metadata) {
        if (this.active) {
            return this.textureOn;
        }
        return this.textureOff;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energyManager.readFromNBT(nbttagcompound);
        this.workingTime = nbttagcompound.func_74762_e("Heating");
        this.setActive(this.workingTime > 0);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.energyManager.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("Heating", this.workingTime);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeBoolean(this.active);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.setActive(data.readBoolean());
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else {
                Proxies.net.sendNetworkPacket(new PacketActiveUpdate(this));
            }
        }
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyManager.receiveEnergy(from, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.energyManager.extractEnergy(from, maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyManager.getEnergyStored(from);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyManager.getMaxEnergyStored(from);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.energyManager.canConnectEnergy(from);
    }

    public static class ClimateControl {
        final float changePerTransfer;
        final float boundaryUp;
        final float boundaryDown;

        public ClimateControl(float changePerTransfer, float boundaryDown, float boundaryUp) {
            this.changePerTransfer = changePerTransfer;
            this.boundaryDown = boundaryDown;
            this.boundaryUp = boundaryUp;
        }
    }
}

