/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.ForestryAPI;
import forestry.apiculture.gadgets.TileAlveary;
import forestry.apiculture.network.PacketActiveUpdate;
import forestry.apiculture.worldgen.Hive;
import forestry.apiculture.worldgen.HiveDecorator;
import forestry.apiculture.worldgen.HiveDescriptionSwarmer;
import forestry.core.interfaces.IActivatable;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.inventory.wrappers.IInvSlot;
import forestry.core.inventory.wrappers.InventoryIterator;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StackUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileAlvearySwarmer
extends TileAlveary
implements ISidedInventory,
IActivatable {
    public static final int BLOCK_META = 2;
    private final Stack<ItemStack> pendingSpawns = new Stack();
    private boolean active;

    public TileAlvearySwarmer() {
        super(2);
        this.setInternalInventory(new SwarmerInventoryAdapter(this));
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.AlvearySwarmerGUI.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (this.pendingSpawns.size() > 0) {
            this.setActive(true);
            if (this.updateOnInterval(1000)) {
                this.trySpawnSwarm();
            }
        } else {
            this.setActive(false);
        }
        if (!this.updateOnInterval(500)) {
            return;
        }
        ItemStack princessStack = this.getPrincessStack();
        if (princessStack == null) {
            return;
        }
        int chance = this.consumeInducerAndGetChance();
        if (chance == 0) {
            return;
        }
        if (this.field_145850_b.field_73012_v.nextInt(1000) >= chance) {
            return;
        }
        IBee princess = BeeManager.beeRoot.getMember(princessStack);
        princess.setIsNatural(false);
        this.pendingSpawns.push(BeeManager.beeRoot.getMemberStack(princess, EnumBeeType.PRINCESS.ordinal()));
    }

    private ItemStack getPrincessStack() {
        if (!this.hasMaster()) {
            return null;
        }
        IAlvearyComponent master = (IAlvearyComponent)this.getCentralTE();
        if (!(master instanceof IBeeHousing)) {
            return null;
        }
        IBeeHousing housing = (IBeeHousing)((Object)master);
        ItemStack princessStack = housing.getQueen();
        if (princessStack == null || !BeeManager.beeRoot.isMated(princessStack)) {
            return null;
        }
        return princessStack;
    }

    private int consumeInducerAndGetChance() {
        if (this.getInternalInventory() == null) {
            return 0;
        }
        for (IInvSlot slot : InventoryIterator.getIterable((IInventory)this.getInternalInventory())) {
            ItemStack stack = slot.getStackInSlot();
            for (Map.Entry<ItemStack, Integer> entry : BeeManager.inducers.entrySet()) {
                if (!StackUtils.isIdenticalItem(entry.getKey(), stack)) continue;
                slot.decreaseStackInSlot();
                return entry.getValue();
            }
        }
        return 0;
    }

    private void trySpawnSwarm() {
        ItemStack toSpawn = this.pendingSpawns.peek();
        HiveDescriptionSwarmer hiveDescription = new HiveDescriptionSwarmer(toSpawn);
        Hive hive = new Hive(hiveDescription);
        int chunkX = (this.field_145851_c + this.field_145850_b.field_73012_v.nextInt(80) - 40) / 16;
        int chunkZ = (this.field_145849_e + this.field_145850_b.field_73012_v.nextInt(80) - 40) / 16;
        if (HiveDecorator.instance().genHive(this.field_145850_b, this.field_145850_b.field_73012_v, chunkX, chunkZ, hive)) {
            this.pendingSpawns.pop();
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeBoolean(this.active);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        boolean active = data.readBoolean();
        if (this.active != active) {
            this.active = active;
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    public int getIcon(int side, int metadata) {
        if (side == 0 || side == 1) {
            return 2;
        }
        if (this.active) {
            return 6;
        }
        return 5;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("PendingSpawns", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            this.pendingSpawns.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] offspring = this.pendingSpawns.toArray(new ItemStack[this.pendingSpawns.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            offspring[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("PendingSpawns", (NBTBase)nbttaglist);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            Proxies.net.sendNetworkPacket(new PacketActiveUpdate(this));
        }
    }

    private static class SwarmerInventoryAdapter
    extends TileInventoryAdapter<TileAlvearySwarmer> {
        public SwarmerInventoryAdapter(TileAlvearySwarmer alvearySwarmer) {
            super(alvearySwarmer, 4, "SwarmInv");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            return StackUtils.containsItemStack(BeeManager.inducers.keySet(), itemStack);
        }
    }
}

