/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumGrowthConditions;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleLeafEffect;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IGenome;
import forestry.arboriculture.gadgets.ForestryBlockLeaves;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.arboriculture.genetics.TreeTemplates;
import forestry.core.config.ForestryBlock;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.Individual;
import forestry.core.genetics.alleles.Allele;
import forestry.core.utils.StringUtil;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class Tree
extends Individual
implements ITree,
IPlantable {
    private ITreeGenome genome;
    private ITreeGenome mate;
    private EnumSet<EnumPlantType> plantTypes;
    private EnumPlantType plantType;

    public Tree(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    public Tree(ITreeGenome genome) {
        this.setGenome(genome);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("Genome")) {
            this.setGenome(new TreeGenome(nbttagcompound.func_74775_l("Genome")));
        } else {
            this.setGenome(PluginArboriculture.treeInterface.templateAsGenome(TreeTemplates.getOakTemplate()));
        }
        if (nbttagcompound.func_74764_b("Mate")) {
            this.mate = new TreeGenome(nbttagcompound.func_74775_l("Mate"));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagCompound NBTmachine;
        super.writeToNBT(nbttagcompound);
        if (this.genome != null) {
            NBTmachine = new NBTTagCompound();
            this.genome.writeToNBT(NBTmachine);
            nbttagcompound.func_74782_a("Genome", (NBTBase)NBTmachine);
        }
        if (this.mate != null) {
            NBTmachine = new NBTTagCompound();
            this.mate.writeToNBT(NBTmachine);
            nbttagcompound.func_74782_a("Mate", (NBTBase)NBTmachine);
        }
    }

    @Override
    public void mate(ITree other) {
        this.mate = new TreeGenome(other.getGenome().getChromosomes());
    }

    @Override
    public IEffectData[] doEffect(IEffectData[] storedData, World world, int biomeid, int x, int y, int z) {
        IAlleleLeafEffect effect = (IAlleleLeafEffect)this.getGenome().getActiveAllele(EnumTreeChromosome.EFFECT);
        if (effect == null) {
            return null;
        }
        storedData[0] = this.doEffect(effect, storedData[0], world, biomeid, x, y, z);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleLeafEffect secondary = (IAlleleLeafEffect)this.getGenome().getInactiveAllele(EnumTreeChromosome.EFFECT);
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doEffect(secondary, storedData[1], world, biomeid, x, y, z);
        return storedData;
    }

    private IEffectData doEffect(IAlleleLeafEffect effect, IEffectData storedData, World world, int biomeid, int x, int y, int z) {
        storedData = effect.validateStorage(storedData);
        return effect.doEffect(this.getGenome(), storedData, world, x, y, z);
    }

    @Override
    public IEffectData[] doFX(IEffectData[] storedData, World world, int biomeid, int x, int y, int z) {
        return null;
    }

    @Override
    public WorldGenerator getTreeGenerator(World world, int x, int y, int z, boolean wasBonemealed) {
        return this.genome.getPrimary().getGenerator(this, world, x, y, z);
    }

    @Override
    public boolean canStay(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y - 1, z);
        if (block == null) {
            return false;
        }
        Iterator i$ = this.getPlantTypes().iterator();
        while (i$.hasNext()) {
            EnumPlantType type;
            this.plantType = type = (EnumPlantType)i$.next();
            if (!block.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this)) continue;
            return true;
        }
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return this.plantType;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return null;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return 0;
    }

    @Override
    public boolean canGrow(World world, int x, int y, int z, int expectedGirth, int expectedHeight) {
        return this.genome.getGrowthProvider().canGrow(this.genome, world, x, y, z, expectedGirth, expectedHeight);
    }

    @Override
    public int getRequiredMaturity() {
        return this.genome.getMaturationTime();
    }

    @Override
    public EnumGrowthConditions getGrowthCondition(World world, int x, int y, int z) {
        return this.genome.getGrowthProvider().getGrowthConditions(this.getGenome(), world, x, y, z);
    }

    @Override
    public int getGirth(World world, int x, int y, int z) {
        return this.genome.getGirth();
    }

    @Override
    public int getResilience() {
        int base = (int)(this.getGenome().getFertility() * this.getGenome().getSappiness() * 100.0f);
        return (base > 1 ? base : 1) * 10;
    }

    @Override
    public float getHeightModifier() {
        return this.genome.getHeight();
    }

    @Override
    public void setLeaves(World world, GameProfile owner, int x, int y, int z) {
        this.setLeaves(world, owner, x, y, z, false);
    }

    @Override
    public void setLeavesDecorative(World world, GameProfile owner, int x, int y, int z) {
        this.setLeaves(world, owner, x, y, z, true);
    }

    private void setLeaves(World world, GameProfile owner, int x, int y, int z, boolean decorative) {
        boolean placed = ForestryBlock.leaves.setBlock(world, x, y, z, 0, 2);
        if (!placed) {
            return;
        }
        if (!ForestryBlock.leaves.isBlockEqual(world, x, y, z)) {
            world.func_147468_f(x, y, z);
            return;
        }
        TileLeaves tileLeaves = ForestryBlockLeaves.getLeafTile((IBlockAccess)world, x, y, z);
        if (tileLeaves == null) {
            world.func_147468_f(x, y, z);
            return;
        }
        tileLeaves.setOwner(owner);
        if (decorative) {
            tileLeaves.setDecorative();
        }
        tileLeaves.setTree(this.copy());
        world.func_147471_g(x, y, z);
    }

    @Override
    public boolean allowsFruitBlocks() {
        IFruitProvider provider = this.getGenome().getFruitProvider();
        if (!provider.requiresFruitBlocks()) {
            return false;
        }
        Collection<IFruitFamily> suitable = this.genome.getPrimary().getSuitableFruit();
        return suitable.contains(provider.getFamily());
    }

    @Override
    public boolean trySpawnFruitBlock(World world, int x, int y, int z) {
        IFruitProvider provider = this.getGenome().getFruitProvider();
        Collection<IFruitFamily> suitable = this.genome.getPrimary().getSuitableFruit();
        if (!suitable.contains(provider.getFamily())) {
            return false;
        }
        return provider.trySpawnFruitBlock(this.getGenome(), world, x, y, z);
    }

    @Override
    public ITreeGenome getGenome() {
        return this.genome;
    }

    private void setGenome(ITreeGenome genome) {
        this.genome = genome;
        this.plantTypes = genome.getPlantTypes();
        this.plantTypes.add(genome.getPrimary().getPlantType());
    }

    @Override
    public ITree copy() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new Tree(nbttagcompound);
    }

    @Override
    public ITreeGenome getMate() {
        return this.mate;
    }

    @Override
    public boolean isPureBred(EnumTreeChromosome chromosome) {
        return this.genome.getActiveAllele(chromosome).getUID().equals(this.genome.getInactiveAllele(chromosome).getUID());
    }

    @Override
    public EnumSet<EnumPlantType> getPlantTypes() {
        return this.plantTypes;
    }

    @Override
    public void addTooltip(List<String> list) {
        IAllele fruit;
        if (!this.isAnalyzed) {
            list.add("<" + StringUtil.localize("gui.unknown") + ">");
            return;
        }
        IAlleleTreeSpecies primary = this.genome.getPrimary();
        IAlleleTreeSpecies secondary = this.genome.getSecondary();
        if (!this.isPureBred(EnumTreeChromosome.SPECIES)) {
            list.add(EnumChatFormatting.BLUE + StringUtil.localize("trees.hybrid").replaceAll("%PRIMARY", primary.getName()).replaceAll("%SECONDARY", secondary.getName()));
        }
        String sappiness = EnumChatFormatting.GOLD + "S: " + this.genome.getActiveAllele(EnumTreeChromosome.SAPPINESS).getName();
        String maturation = EnumChatFormatting.RED + "M: " + this.genome.getActiveAllele(EnumTreeChromosome.MATURATION).getName();
        String height = EnumChatFormatting.LIGHT_PURPLE + "H: " + this.genome.getActiveAllele(EnumTreeChromosome.HEIGHT).getName();
        String girth = EnumChatFormatting.AQUA + "G: " + String.format("%sx%s", this.genome.getGirth(), this.genome.getGirth());
        String saplings = EnumChatFormatting.YELLOW + "S: " + this.genome.getActiveAllele(EnumTreeChromosome.FERTILITY).getName();
        String yield = EnumChatFormatting.WHITE + "Y: " + this.genome.getActiveAllele(EnumTreeChromosome.YIELD).getName();
        list.add(String.format("%s, %s", saplings, maturation));
        list.add(String.format("%s, %s", height, girth));
        list.add(String.format("%s, %s", yield, sappiness));
        IAlleleBoolean primaryFireproof = (IAlleleBoolean)this.genome.getActiveAllele(EnumTreeChromosome.FIREPROOF);
        if (primaryFireproof.getValue()) {
            list.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"for.gui.fireresist"));
        }
        if ((fruit = this.getGenome().getActiveAllele(EnumTreeChromosome.FRUITS)) != Allele.fruitNone) {
            String strike = "";
            if (!this.canBearFruit()) {
                strike = EnumChatFormatting.STRIKETHROUGH.toString();
            }
            list.add(strike + EnumChatFormatting.GREEN + "F: " + StringUtil.localize(this.genome.getFruitProvider().getDescription()));
        }
    }

    @Override
    public ITree[] getSaplings(World world, int x, int y, int z, float modifier) {
        ArrayList<ITree> prod = new ArrayList<ITree>();
        float chance = this.genome.getFertility() * modifier;
        if (world.field_73012_v.nextFloat() <= chance) {
            if (this.getMate() == null) {
                prod.add(PluginArboriculture.treeInterface.getTree(world, new TreeGenome(this.genome.getChromosomes())));
            } else {
                prod.add(this.createOffspring(world, x, y, z));
            }
        }
        return prod.toArray(new ITree[prod.size()]);
    }

    private ITree createOffspring(World world, int x, int y, int z) {
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = this.mate.getChromosomes();
        IChromosome[] mutated = this.mutateSpecies(world, x, y, z, this.genome, this.mate);
        if (mutated == null) {
            mutated = this.mutateSpecies(world, x, y, z, this.mate, this.genome);
        }
        if (mutated != null) {
            return new Tree(new TreeGenome(mutated));
        }
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = Chromosome.inheritChromosome(world.field_73012_v, parent1[i], parent2[i]);
        }
        return new Tree(new TreeGenome(chromosomes));
    }

    private IChromosome[] mutateSpecies(World world, int x, int y, int z, IGenome genomeOne, IGenome genomeTwo) {
        IGenome genome1;
        IGenome genome0;
        IAllele allele1;
        IAllele allele0;
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (world.field_73012_v.nextBoolean()) {
            allele0 = parent1[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent2[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = parent2[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent1[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        for (ITreeMutation mutation : PluginArboriculture.treeInterface.getMutations(true)) {
            float chance = mutation.getChance(world, x, y, z, allele0, allele1, genome0, genome1);
            if (!(chance > world.field_73012_v.nextFloat() * 100.0f)) continue;
            return PluginArboriculture.treeInterface.templateAsChromosomes(mutation.getTemplate());
        }
        return null;
    }

    @Override
    public boolean canBearFruit() {
        return this.genome.getPrimary().getSuitableFruit().contains(this.genome.getFruitProvider().getFamily());
    }

    @Override
    public ItemStack[] getProduceList() {
        return this.genome.getFruitProvider().getProducts();
    }

    @Override
    public ItemStack[] getSpecialtyList() {
        return this.genome.getFruitProvider().getSpecialty();
    }

    @Override
    public ItemStack[] produceStacks(World world, int x, int y, int z, int ripeningTime) {
        return this.genome.getFruitProvider().getFruits(this.genome, world, x, y, z, ripeningTime);
    }
}

