/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IGenome;
import forestry.core.genetics.Mutation;
import forestry.plugins.PluginArboriculture;
import net.minecraft.world.World;

public class TreeMutation
extends Mutation
implements ITreeMutation {
    private final ITreeRoot root = (ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");

    public TreeMutation(IAlleleSpecies allele0, IAlleleSpecies allele1, IAllele[] template, int chance) {
        super(allele0, allele1, template, chance);
        PluginArboriculture.treeInterface.registerMutation(this);
    }

    @Override
    public ITreeRoot getRoot() {
        return this.root;
    }

    @Override
    public float getChance(World world, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        float processedChance = super.getChance(world, x, y, z, allele0, allele1, genome0, genome1);
        if (processedChance <= 0.0f) {
            return 0.0f;
        }
        processedChance *= PluginArboriculture.treeInterface.getTreekeepingMode(world).getMutationModifier((ITreeGenome)genome0, (ITreeGenome)genome1, 1.0f);
        if (this.species0.getUID().equals(allele0.getUID()) && this.species1.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        if (this.species1.getUID().equals(allele0.getUID()) && this.species0.getUID().equals(allele1.getUID())) {
            return processedChance;
        }
        return 0.0f;
    }
}

