/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import java.util.HashMap;
import java.util.Map;

public abstract class StackMap<P, T>
extends HashMap<P, T> {
    private static final long serialVersionUID = 5383477742290646466L;

    @Override
    public final T put(P key, T value) {
        if (this.isValidKey(key) && key != null && value != null) {
            return super.put(key, value);
        }
        return null;
    }

    @Override
    public final boolean containsKey(Object key) {
        P stack = this.getStack(key);
        if (stack == null) {
            return false;
        }
        for (Map.Entry entry : this.entrySet()) {
            if (!this.areEqual(stack, entry.getKey())) continue;
            return true;
        }
        return super.containsKey(key);
    }

    @Override
    public final T get(Object key) {
        P stack = this.getStack(key);
        if (stack == null) {
            return null;
        }
        for (Map.Entry entry : this.entrySet()) {
            if (!this.areEqual(stack, entry.getKey())) continue;
            return (T)entry.getValue();
        }
        return (T)super.get(key);
    }

    protected abstract boolean areEqual(P var1, Object var2);

    protected abstract boolean isValidKey(Object var1);

    protected abstract P getStack(Object var1);
}

