/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import forestry.api.core.ForestryAPI;
import forestry.api.recipes.ISqueezerManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InvTools;
import forestry.core.inventory.TileInventoryAdapter;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class MachineSqueezer
extends TilePowered
implements ISidedInventory,
ILiquidTankContainer {
    public static final short SLOT_RESOURCE_1 = 0;
    public static final short SLOTS_RESOURCE_COUNT = 9;
    public static final short SLOT_REMNANT = 9;
    public static final short SLOT_REMNANT_COUNT = 1;
    public static final short SLOT_CAN_INPUT = 10;
    public static final short SLOT_CAN_OUTPUT = 11;
    private final TankManager tankManager;
    public final FilteredTank productTank;
    private Recipe currentRecipe;
    private int productionTime;
    private int timePerItem;

    public MachineSqueezer() {
        super(1100, 50, 4000);
        this.setInternalInventory(new SqueezerInventoryAdapter(this));
        this.setHints(Config.hints.get("squeezer"));
        this.productTank = new FilteredTank(10000, RecipeManager.recipeFluids);
        this.productTank.tankMode = StandardTank.TankMode.OUTPUT;
        this.tankManager = new TankManager(this.productTank);
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.SqueezerGUI.ordinal(), player.field_70170_p, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("ProductionTime", this.productionTime);
        nbttagcompound.func_74768_a("TimePerItem", this.timePerItem);
        this.tankManager.writeTanksToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.productionTime = nbttagcompound.func_74762_e("ProductionTime");
        this.timePerItem = nbttagcompound.func_74762_e("TimePerItem");
        this.tankManager.readTanksFromNBT(nbttagcompound);
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        FluidStack fluidStack;
        super.updateServerSide();
        if (!this.updateOnInterval(20)) {
            return;
        }
        IInventoryAdapter inventory = this.getInternalInventory();
        if (inventory.func_70301_a(10) != null && (fluidStack = this.productTank.getFluid()) != null) {
            FluidHelper.fillContainers(this.tankManager, (IInventory)inventory, 10, 11, fluidStack.getFluid());
        }
        this.checkRecipe();
    }

    @Override
    public boolean workCycle() {
        if (!this.checkRecipe()) {
            return false;
        }
        FluidStack resultFluid = this.currentRecipe.liquid;
        boolean canFill = this.productTank.fill(resultFluid, false) == resultFluid.amount;
        this.setErrorCondition(!canFill, EnumErrorCode.NOSPACETANK);
        if (!canFill) {
            return false;
        }
        ItemStack remnant = null;
        if (this.currentRecipe.remnants != null) {
            remnant = this.currentRecipe.remnants.func_77946_l();
            boolean canAdd = InvTools.tryAddStack((IInventory)this.getInternalInventory(), remnant, 9, 1, true, false);
            this.setErrorCondition(!canAdd, EnumErrorCode.NOSPACE);
            if (!canAdd) {
                return false;
            }
        }
        if (this.productionTime <= 0) {
            return false;
        }
        if (this.currentRecipe == null) {
            return false;
        }
        --this.productionTime;
        if (this.productionTime > 0) {
            return true;
        }
        if (!this.removeResources(this.currentRecipe.resources)) {
            return false;
        }
        this.productTank.fill(resultFluid, true);
        if (remnant != null && this.field_145850_b.field_73012_v.nextInt(100) < this.currentRecipe.chance) {
            InvTools.tryAddStack((IInventory)this.getInternalInventory(), remnant, 9, 1, true);
        }
        this.checkRecipe();
        this.resetRecipeTimes();
        return true;
    }

    private boolean checkRecipe() {
        ItemStack[] resources = InvTools.getStacks((IInventory)this.getInternalInventory(), 0, 9);
        Recipe matchingRecipe = RecipeManager.findMatchingRecipe(resources);
        if (this.currentRecipe != matchingRecipe) {
            this.currentRecipe = matchingRecipe;
            this.resetRecipeTimes();
        }
        this.setErrorCondition(this.currentRecipe == null, EnumErrorCode.NORECIPE);
        return this.currentRecipe != null;
    }

    private void resetRecipeTimes() {
        if (this.currentRecipe == null) {
            this.productionTime = 0;
            this.timePerItem = 0;
            return;
        }
        this.productionTime = this.currentRecipe.timePerItem;
        this.timePerItem = this.currentRecipe.timePerItem;
    }

    private boolean removeResources(ItemStack[] stacks) {
        EntityPlayer player = Proxies.common.getPlayer(this.field_145850_b, this.getOwner());
        return InvTools.removeSets((IInventory)this.getInternalInventory(), 1, stacks, 0, 9, player, false, true);
    }

    @Override
    public boolean isWorking() {
        return this.currentRecipe != null && this.productTank.getFluidAmount() < this.productTank.getCapacity();
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null && this.productTank.getFluidAmount() < this.productTank.getCapacity();
    }

    public int getProgressScaled(int i) {
        if (this.timePerItem == 0) {
            return i;
        }
        return this.productionTime * i / this.timePerItem;
    }

    public int getResourceScaled(int i) {
        return this.productTank.getFluidAmount() * i / 10000;
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i -= this.tankManager.maxMessageId() + 1) {
            case 0: {
                this.productionTime = j;
                break;
            }
            case 1: {
                this.timePerItem = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        int i = this.tankManager.maxMessageId() + 1;
        iCrafting.func_71112_a(container, i, this.productionTime);
        iCrafting.func_71112_a(container, i + 1, this.timePerItem);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }

    private static class SqueezerInventoryAdapter
    extends TileInventoryAdapter<MachineSqueezer> {
        public SqueezerInventoryAdapter(MachineSqueezer squeezer) {
            super(squeezer, 12, "Items");
        }

        @Override
        public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
            if (slotIndex == 10) {
                return FluidHelper.isEmptyContainer(itemStack);
            }
            if (slotIndex >= 0 && slotIndex < 9) {
                if (FluidHelper.isEmptyContainer(itemStack)) {
                    return false;
                }
                if (RecipeManager.canUse(itemStack)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean func_102008_b(int slotIndex, ItemStack itemstack, int side) {
            return slotIndex == 9 || slotIndex == 11;
        }
    }

    public static class RecipeManager
    implements ISqueezerManager {
        public static final ArrayList<Recipe> recipes = new ArrayList();
        public static final HashSet<Fluid> recipeFluids = new HashSet();
        public static final HashSet<ItemStack> recipeInputs = new HashSet();

        @Override
        public void addRecipe(int timePerItem, ItemStack[] resources, FluidStack liquid, ItemStack remnants, int chance) {
            recipes.add(new Recipe(timePerItem, resources, liquid, remnants, chance));
            if (liquid != null) {
                recipeFluids.add(liquid.getFluid());
            }
            if (resources != null) {
                recipeInputs.addAll(Arrays.asList(resources));
            }
        }

        @Override
        public void addRecipe(int timePerItem, ItemStack[] resources, FluidStack liquid) {
            this.addRecipe(timePerItem, resources, liquid, null, 0);
        }

        public static Recipe findMatchingRecipe(ItemStack[] items) {
            for (Recipe recipe : recipes) {
                if (!recipe.matches(items, false)) continue;
                return recipe;
            }
            for (Recipe recipe : recipes) {
                if (!recipe.matches(items, true)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean canUse(ItemStack itemStack) {
            if (recipeInputs.contains(itemStack)) {
                return true;
            }
            for (ItemStack recipeInput : recipeInputs) {
                if (!StackUtils.isCraftingEquivalent(recipeInput, itemStack, true, true)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Map<Object[], Object[]> getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(recipe.resources, new Object[]{recipe.remnants, recipe.liquid});
            }
            return recipeList;
        }
    }

    public static class Recipe {
        public final int timePerItem;
        public final ItemStack[] resources;
        public final FluidStack liquid;
        public final ItemStack remnants;
        public final int chance;

        public Recipe(int timePerItem, ItemStack[] resources, FluidStack liquid, ItemStack remnants, int chance) {
            this.timePerItem = timePerItem;
            this.resources = resources;
            this.liquid = liquid;
            this.remnants = remnants;
            this.chance = chance;
        }

        public boolean matches(ItemStack[] res, boolean oreDict) {
            return StackUtils.containsSets(this.resources, res, oreDict, true) > 0;
        }
    }
}

