/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.network.IGuiHandler;
import forestry.core.interfaces.IPickupHandler;
import forestry.core.interfaces.IResupplyHandler;
import forestry.core.interfaces.ISaveEventHandler;
import forestry.core.network.IPacketHandler;
import forestry.core.proxy.Proxies;
import forestry.plugins.Plugin;
import forestry.plugins.PluginManager;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.command.ICommand;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class ForestryPlugin {
    public boolean isAvailable() {
        return true;
    }

    public String getFailMessage() {
        return "";
    }

    public EnumSet<PluginManager.Module> getDependancies() {
        return EnumSet.of(PluginManager.Module.CORE);
    }

    protected void setupAPI() {
    }

    protected void disabledSetupAPI() {
    }

    protected void preInit() {
    }

    protected void doInit() {
    }

    protected void postInit() {
    }

    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        return false;
    }

    protected static String getInvalidIMCMessageText(FMLInterModComms.IMCMessage message) {
        Object messageValue = message.isItemStackMessage() ? message.getItemStackValue().toString() : (message.isNBTMessage() ? message.getNBTValue() : (message.isStringMessage() ? message.getStringValue() : ""));
        return String.format("Received an invalid '%s' request '%s' from mod '%s'. Please contact the author and report this issue.", message.key, messageValue, message.getSender());
    }

    protected static void logInvalidIMCMessage(FMLInterModComms.IMCMessage message) {
        String invalidIMCMessageText = ForestryPlugin.getInvalidIMCMessageText(message);
        Proxies.log.warning(invalidIMCMessageText);
    }

    public IGuiHandler getGuiHandler() {
        return null;
    }

    public ISaveEventHandler getSaveEventHandler() {
        return null;
    }

    public void populateChunk(IChunkProvider chunkProvider, World world, Random rand, int chunkX, int chunkZ, boolean hasVillageGeneratedZ) {
    }

    public void populateChunkRetroGen(World world, Random rand, int chunkX, int chunkZ) {
    }

    public IPacketHandler getPacketHandler() {
        return null;
    }

    public IPickupHandler getPickupHandler() {
        return null;
    }

    public IResupplyHandler getResupplyHandler() {
        return null;
    }

    public ICommand[] getConsoleCommands() {
        return null;
    }

    public IFuelHandler getFuelHandler() {
        return null;
    }

    protected void registerItems() {
    }

    protected void registerTriggers() {
    }

    protected void registerBackpackItems() {
    }

    protected void registerCrates() {
    }

    protected void registerRecipes() {
    }

    public String toString() {
        Plugin info = this.getClass().getAnnotation(Plugin.class);
        if (info == null) {
            return this.getClass().getSimpleName();
        }
        return info.name() + " Plugin";
    }
}

