/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant;

import com.InfinityRaider.AgriCraft.api.v1.ICropPlant;
import com.InfinityRaider.AgriCraft.reference.Constants;
import com.InfinityRaider.AgriCraft.renderers.PlantRenderer;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class CropPlant
implements ICropPlant {
    public final int getGrowthRate() {
        int tier = this.getTier();
        if (tier > 0 && tier <= Constants.GROWTH_TIER.length) {
            return Constants.GROWTH_TIER[tier];
        }
        return Constants.GROWTH_TIER[0];
    }

    public final int getTier() {
        int seedTierOverride = SeedHelper.getSeedTierOverride(this.getSeed());
        if (seedTierOverride > 0) {
            return seedTierOverride;
        }
        return this.tier();
    }

    @Override
    public abstract int tier();

    @Override
    public abstract ItemStack getSeed();

    @Override
    public abstract Block getBlock();

    @Override
    public abstract ArrayList<ItemStack> getAllFruits();

    @Override
    public abstract ItemStack getRandomFruit(Random var1);

    @Override
    public abstract ArrayList<ItemStack> getFruitsOnHarvest(int var1, Random var2);

    @Override
    public boolean onHarvest(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    @Override
    public void onSeedPlanted(World world, int x, int y, int z) {
    }

    @Override
    public void onPlantRemoved(World world, int x, int y, int z) {
    }

    @Override
    public abstract boolean canBonemeal();

    @Override
    public abstract boolean onAllowedGrowthTick(World var1, int var2, int var3, int var4, int var5);

    @Override
    public abstract boolean isFertile(World var1, int var2, int var3, int var4);

    @Override
    public boolean isMature(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) >= 7;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract float getHeight(int var1);

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract IIcon getPlantIcon(int var1);

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract boolean renderAsFlower();

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract String getInformation();

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean overrideRendering() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPlantInCrop(IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        PlantRenderer.renderPlantLayer(x, y, z, renderer, this.renderAsFlower() ? 1 : 6, this.getPlantIcon(world.func_72805_g(x, y, z)), 0);
    }
}

