/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.forgemultipart;

import com.InfinityRaider.AgriCraft.compatibility.ModHelper;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.RenderHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ForgeMultiPartHelper
extends ModHelper {
    private static Class multiBlockClass;
    private static Method getTileMethod;
    private static Class tileMultiPartClass;
    private static Method getMultiPartsMethod;
    private static Class leverPartClass;
    private static Method getMetaDataMethod;

    @Override
    protected String modId() {
        return "McMultipart";
    }

    @Override
    protected void postTasks() {
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            return;
        }
        try {
            multiBlockClass = Class.forName("codechicken.multipart.BlockMultipart");
            getTileMethod = multiBlockClass.getMethod("getTile", IBlockAccess.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Exception e) {
            LogHelper.printStackTrace(e);
        }
        try {
            tileMultiPartClass = Class.forName("codechicken.multipart.TileMultipart");
            getMultiPartsMethod = tileMultiPartClass.getMethod("jPartList", new Class[0]);
        }
        catch (Exception e) {
            LogHelper.printStackTrace(e);
        }
        try {
            leverPartClass = Class.forName("codechicken.multipart.minecraft.LeverPart");
            getMetaDataMethod = leverPartClass.getMethod("getMetadata", new Class[0]);
        }
        catch (Exception e) {
            LogHelper.printStackTrace(e);
        }
    }

    public static boolean isMultiPart(Block block) {
        return multiBlockClass != null && multiBlockClass.isInstance(block);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isLeverFacingThis(World world, int x, int y, int z, ForgeDirection dir) {
        try {
            Object tileMultiPart = getTileMethod.invoke(null, world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            List multiPartList = (List)getMultiPartsMethod.invoke(tileMultiPart, new Object[0]);
            for (Object obj : multiPartList) {
                if (!ForgeMultiPartHelper.isLeverPart(obj)) continue;
                try {
                    int metadata = (Integer)getMetaDataMethod.invoke(obj, new Object[0]);
                    if (!RenderHelper.isLeverFacingBlock(metadata, dir)) continue;
                    return true;
                }
                catch (Exception e) {
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isLeverPart(Object obj) {
        return leverPartClass != null && leverPartClass.isInstance(obj);
    }
}

