/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.growthcraft;

import com.InfinityRaider.AgriCraft.apiimpl.v1.cropplant.CropPlant;
import com.InfinityRaider.AgriCraft.farming.GrowthRequirementHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CropPlantGrowthCraftRice
extends CropPlant {
    private Item rice;
    @SideOnly(value=Side.CLIENT)
    private Block plant;

    CropPlantGrowthCraftRice() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.plant = (Block)Block.field_149771_c.func_82594_a("Growthcraft|Rice:grc.riceBlock");
        }
        this.rice = (Item)Item.field_150901_e.func_82594_a("Growthcraft|Rice:grc.rice");
    }

    @Override
    public int tier() {
        return 2;
    }

    @Override
    public ItemStack getSeed() {
        return new ItemStack(this.rice);
    }

    @Override
    public Block getBlock() {
        return this.plant;
    }

    @Override
    public ArrayList<ItemStack> getAllFruits() {
        ArrayList<ItemStack> fruits = new ArrayList<ItemStack>();
        fruits.add(new ItemStack(this.rice));
        return fruits;
    }

    @Override
    public ItemStack getRandomFruit(Random rand) {
        return new ItemStack(this.rice);
    }

    @Override
    public ArrayList<ItemStack> getFruitsOnHarvest(int gain, Random rand) {
        int amount = (int)Math.ceil(((double)gain + 0.0) / 3.0);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(this.rice, amount));
        return list;
    }

    @Override
    public boolean canBonemeal() {
        return true;
    }

    @Override
    public boolean onAllowedGrowthTick(World world, int x, int y, int z, int oldGrowthStage) {
        return true;
    }

    @Override
    public boolean isFertile(World world, int x, int y, int z) {
        return GrowthRequirementHandler.getGrowthRequirement(this.rice, 0).canGrow(world, x, y, z);
    }

    @Override
    public float getHeight(int meta) {
        return 0.8125f;
    }

    @Override
    public IIcon getPlantIcon(int growthStage) {
        return this.plant.func_149691_a(0, growthStage >= 6 ? 6 : growthStage);
    }

    @Override
    public boolean renderAsFlower() {
        return false;
    }

    @Override
    public String getInformation() {
        return "agricraft_journal.hc_Rice";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPlantInCrop(IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        RenderingRegistry.instance().renderWorldBlock(renderer, world, x, y, z, this.plant, this.plant.func_149645_b());
    }
}

