/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.minetweaker;

import com.InfinityRaider.AgriCraft.api.v1.BlockWithMeta;
import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v1.RequirementType;
import com.InfinityRaider.AgriCraft.farming.GrowthRequirementHandler;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

public class Growing {

    @ZenClass(value="mods.agricraft.growing.BaseBlock")
    public static class BaseBlock {
        @ZenMethod
        public static void set(IItemStack seed, IItemStack base, int type, boolean oreDict) {
            if (type < 1 || type > 2) {
                MineTweakerAPI.logError((String)"Type needs to be either 1 (below) or 2 (nearby)");
                return;
            }
            ItemStack seedIS = MineTweakerMC.getItemStack((IItemStack)seed);
            if (seedIS == null || !(seedIS.func_77973_b() instanceof ItemSeeds)) {
                MineTweakerAPI.logError((String)"Seeds has to be non-null and of type ItemSeeds.");
                return;
            }
            ItemStack baseIS = MineTweakerMC.getItemStack((IItemStack)base);
            if (baseIS == null || !(baseIS.func_77973_b() instanceof ItemBlock)) {
                MineTweakerAPI.logError((String)"Base has to be non-null and ot type ItemBlock.");
                return;
            }
            BlockWithMeta baseWM = new BlockWithMeta(((ItemBlock)baseIS.func_77973_b()).field_150939_a, baseIS.func_77960_j());
            RequirementType reqType = type == 1 ? RequirementType.BELOW : RequirementType.NEARBY;
            MineTweakerAPI.apply((IUndoableAction)new SetAction(seedIS, baseWM, reqType, oreDict));
        }

        @ZenMethod
        public static void clear(IItemStack seed) {
            ItemStack seedIS = MineTweakerMC.getItemStack((IItemStack)seed);
            if (seedIS == null || !(seedIS.func_77973_b() instanceof ItemSeeds)) {
                MineTweakerAPI.logError((String)"Seeds has to be non-null and of type ItemSeeds.");
                return;
            }
            MineTweakerAPI.apply((IUndoableAction)new SetAction(seedIS, null, RequirementType.NONE, false));
        }

        private static class SetAction
        implements IUndoableAction {
            private final ItemStack seedStack;
            private final ItemSeeds seed;
            private final int seedMeta;
            private final BlockWithMeta base;
            private final RequirementType type;
            private final boolean oreDict;
            private BlockWithMeta oldReqBlock;
            private RequirementType oldRequiredType;
            private boolean oldReqBlockIsOreDict;

            public SetAction(ItemStack seed, BlockWithMeta base, RequirementType type, boolean oreDict) {
                this.seedStack = seed;
                this.seed = (ItemSeeds)seed.func_77973_b();
                this.seedMeta = seed.func_77960_j();
                this.base = base;
                this.type = type;
                this.oreDict = oreDict;
            }

            public void apply() {
                IGrowthRequirement growthReq = GrowthRequirementHandler.getGrowthRequirement((Item)this.seed, this.seedMeta);
                this.oldReqBlock = growthReq.getRequiredBlock();
                this.oldRequiredType = growthReq.getRequiredType();
                this.oldReqBlockIsOreDict = growthReq.isOreDict();
                growthReq.setRequiredBlock(this.base, this.type, this.oreDict);
            }

            public boolean canUndo() {
                return true;
            }

            public void undo() {
                IGrowthRequirement growthReq = GrowthRequirementHandler.getGrowthRequirement((Item)this.seed, this.seedMeta);
                growthReq.setRequiredBlock(this.oldReqBlock, this.oldRequiredType, this.oldReqBlockIsOreDict);
            }

            public String describe() {
                String blockString = this.base != null ? this.base.getBlock().func_149732_F() : "DEFAULT";
                return "Setting base block requirement for seed " + this.seedStack.func_82833_r() + " to " + blockString + " (" + this.type.toString() + ")";
            }

            public String describeUndo() {
                String blockString = this.oldReqBlock != null && this.oldReqBlock.getBlock() != null ? this.oldReqBlock.getBlock().func_149732_F() : "DEFAULT";
                return "Resetting base block requirement for seed " + this.seedStack.func_82833_r() + " to " + blockString + " (" + this.oldRequiredType.toString() + ")";
            }

            public Object getOverrideKey() {
                return null;
            }
        }
    }

    @ZenClass(value="mods.agricraft.growing.Brightness")
    public static class Brightness {
        @ZenMethod
        public static void set(IItemStack seed, int min, int max) {
            boolean success;
            ItemStack seedStack = MineTweakerMC.getItemStack((IItemStack)seed);
            String error = "Invalid first argument: has to be a seed";
            boolean bl = success = seedStack.func_77973_b() != null && seedStack.func_77973_b() instanceof ItemSeeds;
            if (success) {
                error = "Invalid second argument: has to be larger than or equal to 0";
                boolean bl2 = success = min >= 0;
                if (success) {
                    error = "maximum should be higher than the minimum";
                    boolean bl3 = success = max > min;
                    if (success) {
                        error = "Invalid third argument: has to be smaller than or equal to 16";
                        boolean bl4 = success = max <= 16;
                        if (success) {
                            MineTweakerAPI.apply((IUndoableAction)new SetAction(seedStack, min, max));
                        }
                    }
                }
            }
            if (!success) {
                MineTweakerAPI.logError((String)("Error when trying to set brightness: " + error));
            }
        }

        private static class SetAction
        implements IUndoableAction {
            private final ItemSeeds seed;
            private final int meta;
            private final int min;
            private final int max;
            private int[] old;

            public SetAction(ItemStack stack, int min, int max) {
                this.seed = (ItemSeeds)stack.func_77973_b();
                this.meta = stack.func_77960_j();
                this.min = min;
                this.max = max;
            }

            public void apply() {
                IGrowthRequirement growthReq = GrowthRequirementHandler.getGrowthRequirement((Item)this.seed, this.meta);
                this.old = growthReq.getBrightnessRange();
                growthReq.setBrightnessRange(this.min, this.max);
            }

            public boolean canUndo() {
                return true;
            }

            public void undo() {
                IGrowthRequirement growthReq = GrowthRequirementHandler.getGrowthRequirement((Item)this.seed, this.meta);
                growthReq.setBrightnessRange(this.old[0], this.old[1]);
            }

            public String describe() {
                return "Setting brightness range of " + new ItemStack((Item)this.seed, 1, this.meta).func_82833_r() + " to [" + this.min + ", " + this.max + "[";
            }

            public String describeUndo() {
                return "Resetting brightness range of " + new ItemStack((Item)this.seed, 1, this.meta).func_82833_r() + " to [" + this.old[0] + ", " + this.old[1] + "[";
            }

            public Object getOverrideKey() {
                return null;
            }
        }
    }

    @ZenClass(value="mods.agricraft.growing.Soil")
    public static class Soil {
        @ZenMethod
        public static void set(IItemStack seed, IItemStack soil) {
            boolean success;
            ItemStack seedStack = MineTweakerMC.getItemStack((IItemStack)seed);
            ItemStack soilStack = MineTweakerMC.getItemStack((IItemStack)soil);
            String error = "Invalid first argument: has to be a seed";
            boolean bl = success = seedStack.func_77973_b() != null && seedStack.func_77973_b() instanceof ItemSeeds;
            if (success) {
                error = "Invalid second argument: has to be a block";
                boolean bl2 = success = soilStack.func_77973_b() != null && soilStack.func_77973_b() instanceof ItemBlock;
                if (success) {
                    MineTweakerAPI.apply((IUndoableAction)new SetAction(seedStack, new BlockWithMeta(((ItemBlock)soilStack.func_77973_b()).field_150939_a, soilStack.func_77960_j())));
                }
            }
            if (!success) {
                MineTweakerAPI.logError((String)("Error when trying to set soil: " + error));
            }
        }

        @ZenMethod
        public static void clear(IItemStack seed) {
            ItemStack seedStack = MineTweakerMC.getItemStack((IItemStack)seed);
            if (seedStack.func_77973_b() != null && seedStack.func_77973_b() instanceof ItemSeeds) {
                MineTweakerAPI.apply((IUndoableAction)new SetAction(seedStack, null));
            } else {
                MineTweakerAPI.logError((String)"Error when trying to set soil: Invalid argument: has to be a seed");
            }
        }

        private static class SetAction
        implements IUndoableAction {
            private final ItemStack seedStack;
            private final ItemSeeds seed;
            private final int meta;
            private final BlockWithMeta soil;
            private BlockWithMeta oldSoil;

            public SetAction(ItemStack seed, BlockWithMeta block) {
                this.seedStack = seed;
                this.seed = (ItemSeeds)seed.func_77973_b();
                this.meta = seed.func_77960_j();
                this.soil = block;
            }

            public void apply() {
                IGrowthRequirement growthReq = GrowthRequirementHandler.getGrowthRequirement((Item)this.seed, this.meta);
                this.oldSoil = growthReq.getSoil();
                growthReq.setSoil(this.soil);
            }

            public boolean canUndo() {
                return true;
            }

            public void undo() {
                IGrowthRequirement growthReq = GrowthRequirementHandler.getGrowthRequirement((Item)this.seed, this.meta);
                growthReq.setSoil(this.oldSoil);
            }

            public String describe() {
                String soilText = this.soil != null ? this.soil.toStack().func_82833_r() : "DEFAULT";
                return "Setting soil for " + this.seedStack.func_82833_r() + " to " + soilText;
            }

            public String describeUndo() {
                String soilText = this.oldSoil != null ? this.oldSoil.toStack().func_82833_r() : "DEFAULT";
                return "Reverting soil for " + this.seedStack.func_82833_r() + " to " + soilText;
            }

            public Object getOverrideKey() {
                return null;
            }
        }
    }

    @ZenClass(value="mods.agricraft.growing.FertileSoils")
    public static class FertileSoils {
        @ZenMethod
        public static void add(IItemStack soil) {
            FertileSoils.add(new IItemStack[]{soil});
        }

        @ZenMethod
        public static void add(IItemStack[] soils) {
            ItemStack[] soilsToAdd = MineTweakerMC.getItemStacks((IItemStack[])soils);
            if (FertileSoils.areValidSoils(soilsToAdd)) {
                MineTweakerAPI.apply((IUndoableAction)new AddAction(soilsToAdd));
            } else {
                MineTweakerAPI.logError((String)"Error adding soils to the whitelist. All provided items must be of type ItemBlock.");
            }
        }

        @ZenMethod
        public static void remove(IItemStack soil) {
            FertileSoils.remove(new IItemStack[]{soil});
        }

        @ZenMethod
        public static void remove(IItemStack[] soils) {
            ItemStack[] soilsToRemove = MineTweakerMC.getItemStacks((IItemStack[])soils);
            if (FertileSoils.areValidSoils(soilsToRemove)) {
                MineTweakerAPI.apply((IUndoableAction)new RemoveAction(soilsToRemove));
            } else {
                MineTweakerAPI.logError((String)"Error removing soils from the whitelist. All provided items must be of type ItemBlock.");
            }
        }

        private static boolean areValidSoils(ItemStack[] soils) {
            for (ItemStack stack : soils) {
                if (stack.func_77973_b() instanceof ItemBlock) continue;
                return false;
            }
            return true;
        }

        private static class RemoveAction
        implements IUndoableAction {
            private final List<BlockWithMeta> soils = new ArrayList<BlockWithMeta>();

            public RemoveAction(ItemStack[] soils) {
                for (ItemStack stack : soils) {
                    this.soils.add(new BlockWithMeta(((ItemBlock)stack.func_77973_b()).field_150939_a, stack.func_77960_j()));
                }
            }

            public void apply() {
                GrowthRequirementHandler.removeAllFromSoilWhitelist(this.soils);
            }

            public boolean canUndo() {
                return true;
            }

            public void undo() {
                GrowthRequirementHandler.addAllToSoilWhitelist(this.soils);
            }

            public String describe() {
                return "Removing soils [" + Joiner.on((String)", ").join(this.soils) + "] from the whitelist.";
            }

            public String describeUndo() {
                return "Adding previously removed soils [" + Joiner.on((String)", ").join(this.soils) + "] to the whitelist.";
            }

            public Object getOverrideKey() {
                return null;
            }
        }

        private static class AddAction
        implements IUndoableAction {
            private final List<BlockWithMeta> soils = new ArrayList<BlockWithMeta>();

            public AddAction(ItemStack[] soils) {
                for (ItemStack stack : soils) {
                    this.soils.add(new BlockWithMeta(((ItemBlock)stack.func_77973_b()).field_150939_a, stack.func_77960_j()));
                }
            }

            public void apply() {
                GrowthRequirementHandler.addAllToSoilWhitelist(this.soils);
            }

            public boolean canUndo() {
                return true;
            }

            public void undo() {
                GrowthRequirementHandler.removeAllFromSoilWhitelist(this.soils);
            }

            public String describe() {
                return "Adding soils [" + Joiner.on((String)", ").join(this.soils) + "] to whitelist.";
            }

            public String describeUndo() {
                return "Removing previously added soils [" + Joiner.on((String)", ").join(this.soils) + "] from the whitelist.";
            }

            public Object getOverrideKey() {
                return null;
            }
        }
    }
}

