/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.compatibility.plantmegapack;

import com.InfinityRaider.AgriCraft.compatibility.ModHelper;
import com.InfinityRaider.AgriCraft.compatibility.plantmegapack.CropPlantPMPDouble;
import com.InfinityRaider.AgriCraft.compatibility.plantmegapack.CropPlantPMPSingle;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class PlantMegaPackHelper
extends ModHelper {
    private static final String MOD_ID = "plantmegapack";
    private ArrayList<String> names;

    @Override
    protected void init() {
        this.findNames();
        this.registerOres();
    }

    private void findNames() {
        Class<?> seedEnum;
        try {
            seedEnum = Class.forName("plantmegapack.common.PMPCropSeed");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        if (!seedEnum.isEnum()) {
            return;
        }
        this.names = new ArrayList();
        ?[] constants = seedEnum.getEnumConstants();
        Field nameField = null;
        for (Field field : seedEnum.getDeclaredFields()) {
            if (field.getType() != String.class) continue;
            nameField = field;
            break;
        }
        if (nameField == null) {
            return;
        }
        for (Field constant : constants) {
            try {
                String name = (String)nameField.get(constant);
                this.names.add(name.substring(4));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void registerOres() {
        if (this.names == null || this.names.size() == 0) {
            return;
        }
        for (String name : this.names) {
            Item seed = (Item)Item.field_150901_e.func_82594_a("plantmegapack:seed" + name);
            Item food = (Item)Item.field_150901_e.func_82594_a("plantmegapack:food" + name);
            if (seed == null || food == null) {
                if (name.equalsIgnoreCase("GreenBean")) {
                    name = name + 's';
                    food = (Item)Item.field_150901_e.func_82594_a("plantmegapack:food" + name);
                } else {
                    if (!name.equalsIgnoreCase("Cassava")) continue;
                    food = (Item)Item.field_150901_e.func_82594_a("plantmegapack:food" + name + "Root");
                }
            }
            OreDictionary.registerOre((String)"listAllseed", (Item)seed);
            OreDictionary.registerOre((String)("seed" + name), (Item)seed);
            this.cleanOreDict("crop" + name);
            OreDictionary.registerOre((String)("crop" + name), (Item)food);
        }
    }

    private void cleanOreDict(String name) {
        List idToStack;
        try {
            Field field = OreDictionary.class.getDeclaredField("idToStack");
            field.setAccessible(true);
            idToStack = (List)field.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        int id = OreDictionary.getOreID((String)name);
        ArrayList entriesForId = (ArrayList)idToStack.get(id);
        Iterator iterator = entriesForId.iterator();
        while (iterator.hasNext()) {
            ItemStack entry = (ItemStack)iterator.next();
            if (!(entry.func_77973_b() instanceof ItemBlock)) continue;
            ItemBlock itemBlock = (ItemBlock)entry.func_77973_b();
            Block block = itemBlock.field_150939_a;
            if (!(block instanceof BlockBush)) continue;
            iterator.remove();
        }
    }

    @Override
    protected void initPlants() {
        if (this.names == null || this.names.size() == 0) {
            return;
        }
        for (String name : this.names) {
            Item seed = (Item)Item.field_150901_e.func_82594_a("plantmegapack:seed" + name);
            if (seed == null || !(seed instanceof ItemSeeds)) continue;
            try {
                if (name.equalsIgnoreCase("Corn") || name.equalsIgnoreCase("Cassava")) {
                    CropPlantHandler.registerPlant(new CropPlantPMPDouble((ItemSeeds)seed));
                    continue;
                }
                CropPlantHandler.registerPlant(new CropPlantPMPSingle((ItemSeeds)seed));
            }
            catch (Exception e) {
                if (!ConfigurationHandler.debug) continue;
                e.printStackTrace();
            }
        }
    }

    @Override
    protected String modId() {
        return MOD_ID;
    }
}

