/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming.mutation;

import com.InfinityRaider.AgriCraft.farming.mutation.Mutation;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCrop;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class CrossOverResult {
    private final Item seed;
    private final int meta;
    private final double chance;
    private int growth;
    private int gain;
    private int strength;

    public CrossOverResult(Item seed, int meta, double chance) {
        this.seed = seed;
        this.meta = meta;
        this.chance = chance;
    }

    public static CrossOverResult fromTileEntityCrop(TileEntityCrop crop) {
        Item seed = crop.getSeedStack().func_77973_b();
        int meta = crop.getSeedStack().func_77960_j();
        double chance = SeedHelper.getSpreadChance(seed, meta);
        return new CrossOverResult(seed, meta, chance);
    }

    public static CrossOverResult fromMutation(Mutation mutation) {
        Item seed = mutation.getResult().func_77973_b();
        int meta = mutation.getResult().func_77960_j();
        return new CrossOverResult(seed, meta, mutation.getChance());
    }

    public ItemStack toStack() {
        ItemStack stack = new ItemStack(this.seed, 1, this.meta);
        NBTTagCompound tag = new NBTTagCompound();
        SeedHelper.setNBT(tag, (short)this.growth, (short)this.gain, (short)this.strength, false);
        stack.field_77990_d = tag;
        return stack;
    }

    public Item getSeed() {
        return this.seed;
    }

    public int getMeta() {
        return this.meta;
    }

    public double getChance() {
        return this.chance;
    }

    public int getGain() {
        return this.gain;
    }

    public int getGrowth() {
        return this.growth;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStats(int growth, int gain, int strength) {
        this.growth = growth;
        this.gain = gain;
        this.strength = strength;
    }
}

