/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming.mutation;

import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.farming.mutation.CrossOverResult;
import com.InfinityRaider.AgriCraft.farming.mutation.Mutation;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCrop;
import com.InfinityRaider.AgriCraft.utility.IOHelper;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class MutationHandler {
    private static List<Mutation> mutations;
    private static boolean isSyncing;

    public static void init() {
        String[] data = IOHelper.getLinesArrayFromData(ConfigurationHandler.readMutationData());
        mutations = new ArrayList<Mutation>();
        LogHelper.info("Registered Mutations:");
        for (String line : data) {
            Mutation mutation = MutationHandler.readMutation(line);
            if (mutation == null || mutations.contains(mutation)) continue;
            mutations.add(mutation);
            LogHelper.info(" - " + mutation.getFormula());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void syncFromServer(Mutation mutation, boolean finished) {
        if (!isSyncing) {
            LogHelper.info("Receiving mutations from server");
            mutations = new ArrayList<Mutation>();
            isSyncing = true;
        }
        mutations.add(mutation);
        if (finished) {
            isSyncing = false;
            LogHelper.info("Successfully received mutations from server");
        }
    }

    private static Mutation readMutation(String input) {
        Mutation mutation = null;
        String[] data = IOHelper.getData(input);
        if (data.length != 1 && data.length != 3) {
            LogHelper.info("Error when reading mutation: invalid number of arguments. (line: " + input + ")");
            return mutation;
        }
        String mutationData = data[0];
        int indexEquals = mutationData.indexOf(61);
        int indexPlus = mutationData.indexOf(43);
        if (indexEquals <= 0 || indexPlus <= indexEquals) {
            LogHelper.info("Error when reading mutation: mutation is not defined correctly. (line: " + input + ")");
            return mutation;
        }
        ItemStack resultStack = IOHelper.getStack(mutationData.substring(0, indexEquals));
        ItemStack parentStack1 = IOHelper.getStack(mutationData.substring(indexEquals + 1, indexPlus));
        ItemStack parentStack2 = IOHelper.getStack(mutationData.substring(indexPlus + 1));
        if (!CropPlantHandler.isValidSeed(resultStack)) {
            LogHelper.info("Error when reading mutation: resulting stack is not correct. (line: " + input + ")");
            return mutation;
        }
        if (!CropPlantHandler.isValidSeed(parentStack1)) {
            LogHelper.info("Error when reading mutation: first parent stack is not correct. (line: " + input + ")");
            return mutation;
        }
        if (!CropPlantHandler.isValidSeed(parentStack2)) {
            LogHelper.info("Error when reading mutation: second parent stack is not correct. (line: " + input + ")");
            return mutation;
        }
        try {
            mutation = new Mutation(resultStack, parentStack1, parentStack2);
        }
        catch (Exception e) {
            LogHelper.debug("Caught exception when trying to add mutation: " + resultStack.func_77977_a() + "=" + parentStack1.func_77977_a() + "+" + parentStack2.func_77977_a() + ", this seed is not registered");
        }
        return mutation;
    }

    public static Mutation[] getCrossOvers(List<TileEntityCrop> crops) {
        TileEntityCrop[] parents = MutationHandler.getParents(crops);
        ArrayList<Mutation> list = new ArrayList<Mutation>();
        switch (parents.length) {
            case 2: {
                list.addAll(MutationHandler.getMutationsFromParent(parents[0], parents[1]));
                break;
            }
            case 3: {
                list.addAll(MutationHandler.getMutationsFromParent(parents[0], parents[1]));
                list.addAll(MutationHandler.getMutationsFromParent(parents[0], parents[2]));
                list.addAll(MutationHandler.getMutationsFromParent(parents[1], parents[2]));
                break;
            }
            case 4: {
                list.addAll(MutationHandler.getMutationsFromParent(parents[0], parents[1]));
                list.addAll(MutationHandler.getMutationsFromParent(parents[0], parents[2]));
                list.addAll(MutationHandler.getMutationsFromParent(parents[0], parents[3]));
                list.addAll(MutationHandler.getMutationsFromParent(parents[1], parents[2]));
                list.addAll(MutationHandler.getMutationsFromParent(parents[1], parents[3]));
                list.addAll(MutationHandler.getMutationsFromParent(parents[2], parents[3]));
            }
        }
        return MutationHandler.cleanMutationArray(list.toArray(new Mutation[list.size()]));
    }

    private static TileEntityCrop[] getParents(List<TileEntityCrop> input) {
        ArrayList<TileEntityCrop> list = new ArrayList<TileEntityCrop>();
        for (TileEntityCrop crop : input) {
            if (crop == null || !crop.isMature()) continue;
            list.add(crop);
        }
        return list.toArray(new TileEntityCrop[list.size()]);
    }

    private static ArrayList<Mutation> getMutationsFromParent(TileEntityCrop parent1, TileEntityCrop parent2) {
        Item seed1 = parent1.getSeedStack().func_77973_b();
        Item seed2 = parent2.getSeedStack().func_77973_b();
        int meta1 = parent1.getSeedStack().func_77960_j();
        int meta2 = parent2.getSeedStack().func_77960_j();
        ArrayList<Mutation> list = new ArrayList<Mutation>();
        for (Mutation mutation : mutations) {
            ItemStack parent1Stack = mutation.getParents()[0];
            ItemStack parent2Stack = mutation.getParents()[1];
            if (seed1 == parent1Stack.func_77973_b() && seed2 == parent2Stack.func_77973_b() && meta1 == parent1Stack.func_77960_j() && meta2 == parent2Stack.func_77960_j()) {
                list.add(mutation);
            }
            if (seed1 != parent2Stack.func_77973_b() || seed2 != parent1Stack.func_77973_b() || meta1 != parent2Stack.func_77960_j() || meta2 != parent1Stack.func_77960_j()) continue;
            list.add(mutation);
        }
        return list;
    }

    public static void setResultStats(CrossOverResult result, List<TileEntityCrop> input, boolean mutation) {
        TileEntityCrop[] parents = MutationHandler.getParents(input);
        int size = parents.length;
        int[] growth = new int[size];
        int[] gain = new int[size];
        int[] strength = new int[size];
        for (int i = 0; i < size; ++i) {
            int multiplier = ConfigurationHandler.spreadingDifficulty;
            if (multiplier > 1) {
                multiplier = MutationHandler.canInheritStats(result.getSeed(), result.getMeta(), parents[i].getSeedStack().func_77973_b(), parents[i].getSeedStack().func_77960_j()) ? 1 : (multiplier == 3 ? 0 : -1);
            }
            growth[i] = multiplier * parents[i].getGrowth();
            gain[i] = multiplier * parents[i].getGain();
            strength[i] = multiplier * parents[i].getStrength();
        }
        int meanGrowth = MutationHandler.getMean(growth);
        int meanGain = MutationHandler.getMean(gain);
        int meanStrength = MutationHandler.getMean(strength);
        int divisor = mutation ? ConfigurationHandler.cropStatDivisor : 1;
        result.setStats(MutationHandler.calculateStats(meanGrowth, size, divisor), MutationHandler.calculateStats(meanGain, size, divisor), MutationHandler.calculateStats(meanStrength, size, divisor));
    }

    private static int getMean(int[] input) {
        int sum = 0;
        int total = input.length;
        int mean = 0;
        if (total > 0) {
            for (int nr : input) {
                if (nr >= 0) {
                    sum += nr;
                    continue;
                }
                --total;
            }
            if (total > 0) {
                mean = Math.round((float)sum / (float)total);
            }
        }
        return mean;
    }

    private static int calculateStats(int input, int neighbours, int divisor) {
        if (neighbours == 1 && ConfigurationHandler.singleSpreadsIncrement) {
            neighbours = 2;
        }
        int newStat = Math.max(1, (input + (int)Math.round((double)Math.abs(neighbours - 1) * Math.random())) / divisor);
        return Math.min(newStat, ConfigurationHandler.cropStatCap);
    }

    private static boolean canInheritStats(Item child, int childMeta, Item seed, int seedMeta) {
        boolean b;
        boolean bl = b = child == seed && childMeta == seedMeta;
        if (!b) {
            for (Mutation mutation : MutationHandler.getMutationsFromChild(child, childMeta)) {
                if (mutation == null) continue;
                ItemStack parent1Stack = mutation.getParents()[0];
                ItemStack parent2Stack = mutation.getParents()[1];
                if (parent1Stack.func_77973_b() == seed && parent1Stack.func_77960_j() == seedMeta) {
                    b = true;
                    break;
                }
                if (parent2Stack.func_77973_b() != seed || parent2Stack.func_77960_j() != seedMeta) continue;
                b = true;
                break;
            }
        }
        return b;
    }

    private static Mutation[] cleanMutationArray(Mutation[] input) {
        ArrayList<Mutation> list = new ArrayList<Mutation>();
        for (Mutation mutation : input) {
            if (mutation.getResult() == null) continue;
            list.add(mutation);
        }
        return list.toArray(new Mutation[list.size()]);
    }

    public static Mutation[] getMutations() {
        return mutations.toArray(new Mutation[mutations.size()]);
    }

    public static Mutation[] getMutationsFromParent(ItemStack stack) {
        ArrayList<Mutation> list = new ArrayList<Mutation>();
        for (Mutation mutation : mutations) {
            ItemStack parent1Stack = mutation.getParents()[0];
            ItemStack parent2Stack = mutation.getParents()[1];
            if (parent1Stack.func_77973_b() == stack.func_77973_b() && parent1Stack.func_77960_j() == stack.func_77960_j()) {
                list.add(new Mutation(mutation));
            }
            if (parent2Stack.func_77973_b() != stack.func_77973_b() || parent2Stack.func_77960_j() != stack.func_77960_j() || parent2Stack.func_77973_b() == parent1Stack.func_77973_b() && parent2Stack.func_77960_j() == parent1Stack.func_77960_j()) continue;
            list.add(new Mutation(mutation));
        }
        return list.toArray(new Mutation[list.size()]);
    }

    public static Mutation[] getMutationsFromChild(Item seed, int meta) {
        return MutationHandler.getMutationsFromChild(new ItemStack(seed, 1, meta));
    }

    public static Mutation[] getMutationsFromChild(ItemStack stack) {
        ArrayList<Mutation> list = new ArrayList<Mutation>();
        if (CropPlantHandler.isValidSeed(stack)) {
            for (Mutation mutation : mutations) {
                if (mutation.getResult().func_77973_b() != stack.func_77973_b() || mutation.getResult().func_77960_j() != stack.func_77960_j()) continue;
                list.add(new Mutation(mutation));
            }
        }
        return list.toArray(new Mutation[list.size()]);
    }

    public static List<Mutation> removeMutationsByResult(ItemStack result) {
        ArrayList<Mutation> removedMutations = new ArrayList<Mutation>();
        Iterator<Mutation> iter = mutations.iterator();
        while (iter.hasNext()) {
            Mutation mutation = iter.next();
            if (!mutation.getResult().func_77969_a(result)) continue;
            iter.remove();
            removedMutations.add(mutation);
        }
        return removedMutations;
    }

    public static void add(Mutation mutation) {
        mutations.add(mutation);
    }

    public static void remove(Mutation mutation) {
        mutations.remove(mutation);
    }

    public static void addAll(Collection<? extends Mutation> mutationsToAdd) {
        mutations.addAll(mutationsToAdd);
    }

    static {
        isSyncing = false;
    }
}

