/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.items;

import com.InfinityRaider.AgriCraft.blocks.BlockCrop;
import com.InfinityRaider.AgriCraft.items.ItemAgricraft;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCrop;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemHandRake
extends ItemAgricraft {
    private static final int WOOD_VARIANT_META = 0;
    private static final int IRON_VARIANT_META = 1;
    private static final Random random = new Random();
    private final IIcon[] icons = new IIcon[2];

    public ItemHandRake() {
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    @Override
    protected String getInternalName() {
        return "handRake";
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null || !(te instanceof TileEntityCrop)) {
            return false;
        }
        TileEntityCrop crop = (TileEntityCrop)te;
        if (crop.hasWeed()) {
            int weedGrowthStage = world.func_72805_g(x, y, z);
            int newWeedGrowthStage = this.calculateGrowthStage(stack.func_77960_j(), weedGrowthStage);
            crop.updateWeed(newWeedGrowthStage);
            return true;
        }
        if (crop.hasPlant()) {
            ((BlockCrop)world.func_147439_a(x, y, z)).canUproot(world, x, y, z);
        }
        return true;
    }

    private int calculateGrowthStage(int toolMeta, int currentWeedMeta) {
        if (toolMeta == 1) {
            return 0;
        }
        return Math.max(random.nextInt(currentWeedMeta / 2 + 1) - 1, 0) + currentWeedMeta / 2;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
    }

    public String func_77667_c(ItemStack itemStack) {
        String base = super.func_77667_c(itemStack);
        if (itemStack.func_77960_j() == 0) {
            return base + ".wood";
        }
        if (itemStack.func_77960_j() == 1) {
            return base + ".iron";
        }
        throw new IllegalArgumentException("Unsupported meta value of " + itemStack.func_77960_j() + " for ItemHandRake.");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        list.add(StatCollector.func_74838_a((String)"agricraft_tooltip.handRake"));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        LogHelper.debug("registering icon for: " + this.func_77658_a());
        this.icons[0] = reg.func_94245_a(this.func_77658_a().substring(this.func_77658_a().indexOf(46) + 1) + "_wood");
        this.icons[1] = reg.func_94245_a(this.func_77658_a().substring(this.func_77658_a().indexOf(46) + 1) + "_iron");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (meta <= 1) {
            return this.icons[meta];
        }
        return null;
    }
}

