/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.proxy;

import codechicken.nei.api.API;
import com.InfinityRaider.AgriCraft.blocks.BlockAgriCraft;
import com.InfinityRaider.AgriCraft.compatibility.NEI.NEIConfig;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.handler.ItemToolTipHandler;
import com.InfinityRaider.AgriCraft.init.Blocks;
import com.InfinityRaider.AgriCraft.proxy.CommonProxy;
import com.InfinityRaider.AgriCraft.renderers.blocks.RenderBlockBase;
import com.InfinityRaider.AgriCraft.renderers.player.renderhooks.RenderPlayerHooks;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    @Override
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public World getWorldByDimensionId(int dimension) {
        return FMLClientHandler.instance().getServer().func_71218_a(dimension);
    }

    @Override
    public Entity getEntityById(World world, int id) {
        return world.func_73045_a(id);
    }

    @Override
    public void registerRenderers() {
        for (Field field : Blocks.class.getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(BlockAgriCraft.class)) continue;
            try {
                Object obj = field.get(null);
                if (obj == null) continue;
                ((BlockAgriCraft)((Object)obj)).getRenderer();
            }
            catch (IllegalAccessException e) {
                LogHelper.printStackTrace(e);
            }
        }
        if (!ConfigurationHandler.disableWorldGen && ConfigurationHandler.villagerEnabled) {
            VillagerRegistry.instance().registerVillagerSkin(78943, new ResourceLocation("textures/entity/villager/farmer.png"));
        }
        LogHelper.debug("Renderers registered");
    }

    @Override
    public void registerEventHandlers() {
        super.registerEventHandlers();
        ItemToolTipHandler itemToolTipHandler = new ItemToolTipHandler();
        MinecraftForge.EVENT_BUS.register((Object)itemToolTipHandler);
        RenderPlayerHooks renderPlayerHooks = new RenderPlayerHooks();
        MinecraftForge.EVENT_BUS.register((Object)renderPlayerHooks);
    }

    @Override
    public void initNEI() {
        NEIConfig configNEI = new NEIConfig();
        configNEI.loadConfig();
    }

    @Override
    public void hideItemInNEI(ItemStack stack) {
        for (ModContainer modContainer : Loader.instance().getActiveModList()) {
            if (!modContainer.getModId().equalsIgnoreCase("NotEnoughItems")) continue;
            API.hideItem((ItemStack)stack);
        }
    }

    @Override
    public int getRenderId(Block block) {
        return RenderBlockBase.getRenderId(block);
    }

    @Override
    public void registerVillagerSkin(int id, String resource) {
        VillagerRegistry.instance().registerVillagerSkin(id, new ResourceLocation("AgriCraft".toLowerCase(), resource));
    }

    @Override
    public void initConfiguration(FMLPreInitializationEvent event) {
        super.initConfiguration(event);
        ConfigurationHandler.initClientConfigs(event);
    }
}

