/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity;

import com.InfinityRaider.AgriCraft.utility.LogHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public final class MultiBlockComponent {
    public static final MultiBlockComponent DEFAULT_COMPONENT = new MultiBlockComponent(0, 0, 0, 0, 0, 0, 1, 1, 1);
    public final int anchorX;
    public final int anchorY;
    public final int anchorZ;
    public final int posX;
    public final int posY;
    public final int posZ;
    public final int sizeX;
    public final int sizeY;
    public final int sizeZ;
    public final int size;
    public final boolean isController;
    public final boolean isPartOfMultiBlock;

    public MultiBlockComponent(int anchorX, int anchorY, int anchorZ, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ) {
        this.anchorX = anchorX;
        this.anchorY = anchorY;
        this.anchorZ = anchorZ;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.size = sizeX * sizeY * sizeZ;
        this.isController = posX == 0 && posY == 0 && posZ == 0;
        this.isPartOfMultiBlock = this.size > 1;
        LogHelper.debug("Component formed at (" + this.posX + "," + this.posY + "," + this.posZ + ").");
        LogHelper.debug("Anchor: (" + this.anchorX + "," + this.anchorY + "," + this.anchorZ + ").");
    }

    public final boolean isPartner(MultiBlockComponent component) {
        return this.anchorX == component.anchorX && this.anchorY == component.anchorY && this.anchorZ == component.anchorZ;
    }

    public boolean hasNeighbour(ForgeDirection direction) {
        if (direction != null && direction != ForgeDirection.UNKNOWN) {
            return this.posX + direction.offsetX > -1 && this.posX + direction.offsetX < this.sizeX && this.posY + direction.offsetY > -1 && this.posY + direction.offsetY < this.sizeY && this.posZ + direction.offsetZ > -1 && this.posZ + direction.offsetZ < this.sizeZ;
        }
        return false;
    }

    public static final MultiBlockComponent readFromNBT(NBTTagCompound tag) {
        if (MultiBlockComponent.validateNBT(tag)) {
            LogHelper.debug("Reading MultiBlockComponent from NBT.");
            return new MultiBlockComponent(tag.func_74762_e("anchorX"), tag.func_74762_e("anchorY"), tag.func_74762_e("anchorZ"), tag.func_74762_e("posX"), tag.func_74762_e("posY"), tag.func_74762_e("posZ"), tag.func_74762_e("sizeX"), tag.func_74762_e("sizeY"), tag.func_74762_e("sizeZ"));
        }
        return null;
    }

    public final void writeToNBT(NBTTagCompound tag) {
        if (this.isPartOfMultiBlock) {
            tag.func_74768_a("anchorX", this.anchorX);
            tag.func_74768_a("anchorY", this.anchorY);
            tag.func_74768_a("anchorZ", this.anchorZ);
            tag.func_74768_a("posX", this.posX);
            tag.func_74768_a("posY", this.posY);
            tag.func_74768_a("posZ", this.posZ);
            tag.func_74768_a("sizeX", this.sizeX);
            tag.func_74768_a("sizeY", this.sizeY);
            tag.func_74768_a("sizeZ", this.sizeZ);
        }
    }

    public static final boolean validateNBT(NBTTagCompound tag) {
        return tag.func_74764_b("anchorX") && tag.func_74764_b("anchorY") && tag.func_74764_b("anchorZ") && tag.func_74764_b("posX") && tag.func_74764_b("posY") && tag.func_74764_b("posZ") && tag.func_74764_b("sizeX") && tag.func_74764_b("sizeY") && tag.func_74764_b("sizeZ");
    }
}

