/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity;

import com.InfinityRaider.AgriCraft.blocks.BlockCrop;
import com.InfinityRaider.AgriCraft.compatibility.ModHelper;
import com.InfinityRaider.AgriCraft.compatibility.computercraft.ComputerCraftHelper;
import com.InfinityRaider.AgriCraft.compatibility.computercraft.method.IMethod;
import com.InfinityRaider.AgriCraft.compatibility.computercraft.method.MethodException;
import com.InfinityRaider.AgriCraft.tileentity.TileEntitySeedAnalyzer;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(modid="ComputerCraft", iface="dan200.computercraft.api.peripheral.IPeripheral")
public class TileEntityPeripheral
extends TileEntitySeedAnalyzer
implements IPeripheral {
    private static IMethod[] methods;
    private boolean mayAnalyze = false;
    @SideOnly(value=Side.CLIENT)
    private HashMap<ForgeDirection, Integer> timers;
    @SideOnly(value=Side.CLIENT)
    private HashMap<ForgeDirection, Boolean> activeSides;
    public static final ForgeDirection[] VALID_DIRECTIONS;
    public static final int MAX = 60;

    public TileEntityPeripheral() {
        this.initMethods();
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74757_a("ac_Flag", this.mayAnalyze);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.mayAnalyze = tag.func_74764_b("ac_Flag") && tag.func_74767_n("ac_Flag");
    }

    private void initMethods() {
        if (methods == null && ModHelper.allowIntegration("ComputerCraft")) {
            methods = ComputerCraftHelper.getMethods();
        }
    }

    public IMethod[] getMethods() {
        this.initMethods();
        return methods;
    }

    @Override
    public void func_145845_h() {
        if (this.mayAnalyze) {
            if (this.hasSpecimen() && !this.isSpecimenAnalyzed()) {
                super.func_145845_h();
            } else {
                this.reset();
            }
        }
        if (this.field_145850_b.field_72995_K) {
            this.checkSides();
            for (ForgeDirection dir : VALID_DIRECTIONS) {
                int timer = this.timers.get(dir);
                timer = (timer += this.isSideActive(dir) ? 1 : -1) < 0 ? 0 : timer;
                timer = timer > 60 ? 60 : timer;
                this.timers.put(dir, timer);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getTimer(ForgeDirection dir) {
        return this.timers.get(dir);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isSideActive(ForgeDirection dir) {
        return this.activeSides.containsKey(dir) && this.activeSides.get(dir) != false;
    }

    @SideOnly(value=Side.CLIENT)
    private void checkSides() {
        for (ForgeDirection dir : VALID_DIRECTIONS) {
            this.checkSide(dir);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void checkSide(ForgeDirection dir) {
        if (this.timers == null) {
            this.timers = new HashMap();
        }
        if (!this.timers.containsKey(dir)) {
            this.timers.put(dir, 0);
        }
        if (this.activeSides == null) {
            this.activeSides = new HashMap();
        }
        this.activeSides.put(dir, this.isCrop(dir));
    }

    private boolean isCrop(ForgeDirection dir) {
        return this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ) instanceof BlockCrop;
    }

    public void startAnalyzing() {
        if (!this.mayAnalyze && this.hasSpecimen() && !this.isSpecimenAnalyzed()) {
            this.mayAnalyze = true;
            this.markForUpdate();
        }
    }

    @Override
    public void analyze() {
        super.analyze();
        this.reset();
    }

    private void reset() {
        if (this.mayAnalyze) {
            this.mayAnalyze = false;
            this.markForUpdate();
        }
    }

    @Override
    public boolean isRotatable() {
        return false;
    }

    public String getType() {
        return "agricraft_peripheral";
    }

    public String[] getMethodNames() {
        String[] names = new String[methods.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = methods[i].getName();
        }
        return names;
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        IMethod calledMethod = methods[method];
        try {
            return calledMethod.call(this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getJournal(), computer, context, arguments);
        }
        catch (MethodException e) {
            throw new LuaException(e.getDescription());
        }
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    public boolean equals(IPeripheral other) {
        return other instanceof TileEntityPeripheral;
    }

    static {
        VALID_DIRECTIONS = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
    }
}

