/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity.irrigation;

import com.InfinityRaider.AgriCraft.api.v1.IDebuggable;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.network.MessageSyncFluidLevel;
import com.InfinityRaider.AgriCraft.network.NetworkWrapperAgriCraft;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCustomWood;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.IIrrigationComponent;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.TileEntityTank;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.TileEntityValve;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityChannel
extends TileEntityCustomWood
implements IIrrigationComponent,
IDebuggable {
    public static final int FORGE_DIRECTION_OFFSET = 2;
    public static final ForgeDirection[] validDirections = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
    private IIrrigationComponent[] neighbours = new IIrrigationComponent[4];
    protected int ticksSinceNeighbourCheck = 0;
    protected static final int NEIGHBOUR_CHECK_DELAY = 1024;
    protected static final int MIN = 5;
    protected static final int MAX = 12;
    protected static final int HEIGHT = 7;
    protected static final int DISCRETE_MAX = 16;
    protected static final int ABSOLUTE_MAX = ConfigurationHandler.channelCapacity;
    protected static final float DISCRETE_FACTOR = 16.0f / (float)ABSOLUTE_MAX;
    protected static final float SCALE_FACTOR = (float)ABSOLUTE_MAX / 16.0f;
    private int lvl;
    private int lastDiscreteLvl = 0;

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.lvl > 0) {
            tag.func_74768_a("level", this.lvl);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.lvl = tag.func_74764_b("level") ? tag.func_74762_e("level") : 0;
        super.func_145839_a(tag);
    }

    @Override
    public int getFluidLevel() {
        return this.lvl;
    }

    @Override
    public int getCapacity() {
        return ABSOLUTE_MAX;
    }

    @Override
    public void setFluidLevel(int lvl) {
        if (lvl >= 0 && lvl <= ABSOLUTE_MAX && lvl != this.lvl) {
            this.lvl = lvl;
            this.syncFluidLevel();
        }
    }

    @Override
    public int pushFluid(int amount) {
        if (!this.field_145850_b.field_72995_K && amount >= 0 && this.canAccept()) {
            int room = this.getCapacity() - this.getFluidLevel();
            if (room >= amount) {
                this.setFluidLevel(this.getFluidLevel() + amount);
                amount = 0;
            } else if (room > 0) {
                this.setFluidLevel(this.getCapacity());
                amount -= room;
            }
        }
        return amount;
    }

    @Override
    public int pullFluid(int amount) {
        if (!this.field_145850_b.field_72995_K && amount >= 0 && this.canProvide()) {
            if (amount <= this.getFluidLevel()) {
                this.setFluidLevel(this.getFluidLevel() - amount);
            } else {
                amount = this.getFluidLevel();
                this.setFluidLevel(0);
            }
        }
        return amount;
    }

    @Override
    public boolean canConnectTo(IIrrigationComponent component) {
        return (component instanceof TileEntityTank || component instanceof TileEntityChannel) && this.isSameMaterial((TileEntityCustomWood)((Object)component));
    }

    @Override
    public boolean canAccept() {
        return this.lvl < ABSOLUTE_MAX;
    }

    @Override
    public boolean canProvide() {
        return this.lvl > 0;
    }

    @Override
    public float getFluidHeight() {
        return 5.0f + 7.0f * (float)this.lvl / (float)ABSOLUTE_MAX;
    }

    public final void updateNeighbours() {
        if (this.ticksSinceNeighbourCheck == 0) {
            this.findNeighbours();
        }
        this.ticksSinceNeighbourCheck = (this.ticksSinceNeighbourCheck + 1) % 1024;
    }

    public final void findNeighbours() {
        for (int i = 0; i < validDirections.length; ++i) {
            IIrrigationComponent neighbour;
            ForgeDirection dir = validDirections[i];
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            this.neighbours[i] = !(te instanceof IIrrigationComponent) ? null : ((neighbour = (IIrrigationComponent)te).canConnectTo(this) || this.canConnectTo(neighbour) ? neighbour : null);
        }
        this.ticksSinceNeighbourCheck = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasNeighbourCheck(ForgeDirection direction) {
        if (this.field_145850_b == null) {
            return false;
        }
        TileEntity tileEntityAt = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
        return tileEntityAt != null && tileEntityAt instanceof IIrrigationComponent && this.isSameMaterial((TileEntityCustomWood)tileEntityAt);
    }

    @SideOnly(value=Side.SERVER)
    public boolean hasNeighbour(ForgeDirection direction) {
        int ordinal = direction.ordinal() - 2;
        return ordinal >= 0 && ordinal < this.neighbours.length && this.neighbours[ordinal] != null;
    }

    public IIrrigationComponent getNeighbor(ForgeDirection direction) {
        if (this.field_145850_b == null) {
            return null;
        }
        if (direction.offsetY == 0 && direction.offsetX + direction.offsetZ != 0) {
            TileEntity tileEntityAt = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d, this.field_145849_e + direction.offsetZ);
            return tileEntityAt instanceof IIrrigationComponent ? (IIrrigationComponent)tileEntityAt : null;
        }
        return null;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateNeighbours();
            int totalLvl = 0;
            int nr = 1;
            int updatedLevel = this.getFluidLevel();
            for (IIrrigationComponent component : this.neighbours) {
                if (component == null) continue;
                if (component instanceof TileEntityChannel) {
                    if (component instanceof TileEntityValve && ((TileEntityValve)component).isPowered()) continue;
                    totalLvl += ((TileEntityChannel)component).lvl;
                    ++nr;
                    continue;
                }
                TileEntityTank tank = (TileEntityTank)component;
                int Y = tank.getComponent().posY;
                float y_c = (float)(16 * Y) + this.getFluidHeight();
                float y_t = tank.getFluidHeight();
                float y1 = 5.0f + (float)(16 * Y);
                float y2 = 12.0f + (float)(16 * Y);
                int V_tot = tank.getFluidLevel() + this.lvl;
                if (y_c == y_t) continue;
                if (y_t <= y1) {
                    updatedLevel = 0;
                    tank.setFluidLevel(V_tot);
                    continue;
                }
                if (y_t >= y2) {
                    updatedLevel = ABSOLUTE_MAX;
                    tank.setFluidLevel(V_tot - ABSOLUTE_MAX);
                    continue;
                }
                int tankYSize = tank.getComponent().sizeY;
                int C = tank.getCapacity();
                float enumerator = (float)V_tot + ((float)ABSOLUTE_MAX * y1 / (y2 - y1) + 2.0f * (float)C / (float)(16 * tankYSize - 2));
                float denominator = (float)ABSOLUTE_MAX / (y2 - y1) + (float)C / (float)(16 * tankYSize - 2);
                float y = enumerator / denominator;
                int channelVolume = (int)Math.floor((float)ABSOLUTE_MAX * (y - y1) / (y2 - y1));
                int tankVolume = (int)Math.ceil((float)C * (y - 2.0f) / (float)(16 * tankYSize - 2));
                updatedLevel = channelVolume;
                tank.setFluidLevel(tankVolume);
            }
            int rest = (totalLvl += updatedLevel) % nr;
            int newLvl = totalLvl / nr;
            if (nr > 1) {
                for (IIrrigationComponent component : this.neighbours) {
                    if (!(component instanceof TileEntityChannel) || component instanceof TileEntityValve && ((TileEntityValve)component).isPowered()) continue;
                    int lvl = rest == 0 ? newLvl : newLvl + 1;
                    rest = rest == 0 ? 0 : rest - 1;
                    component.setFluidLevel(lvl);
                }
            }
            this.setFluidLevel(newLvl + rest);
        }
    }

    @Override
    public void syncFluidLevel() {
        int newDiscreteLvl;
        if (!this.field_145850_b.field_72995_K && (newDiscreteLvl = this.getDiscreteFluidLevel()) != this.lastDiscreteLvl) {
            this.lastDiscreteLvl = newDiscreteLvl;
            MessageSyncFluidLevel msg = new MessageSyncFluidLevel(this.lvl, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0);
            NetworkWrapperAgriCraft.wrapper.sendToAllAround((IMessage)msg, point);
        }
    }

    public int getDiscreteFluidLevel() {
        int discreteFluidLevel = Math.round(DISCRETE_FACTOR * (float)this.lvl);
        if (discreteFluidLevel == 0 && this.lvl > 0) {
            discreteFluidLevel = 1;
        }
        return discreteFluidLevel;
    }

    @Override
    public void addDebugInfo(List<String> list) {
        list.add("CHANNEL:");
        super.addDebugInfo(list);
        list.add("  - FluidLevel: " + this.getFluidLevel() + "/" + ABSOLUTE_MAX);
        list.add("  - FluidHeight: " + this.getFluidHeight());
        list.add("  - Connections: ");
        for (ForgeDirection dir : validDirections) {
            if (!this.hasNeighbour(dir)) continue;
            list.add("      - " + dir.name());
        }
    }

    @Override
    public void addWailaInformation(List information) {
        super.addWailaInformation(information);
        information.add(StatCollector.func_74838_a((String)"agricraft_tooltip.waterLevel") + ": " + this.getFluidLevel() + "/" + ABSOLUTE_MAX);
    }
}

