/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity.irrigation;

import com.InfinityRaider.AgriCraft.api.v1.IDebuggable;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.network.MessageSyncFluidLevel;
import com.InfinityRaider.AgriCraft.network.NetworkWrapperAgriCraft;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityMultiBlock;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.IIrrigationComponent;
import com.InfinityRaider.AgriCraft.tileentity.irrigation.TileEntityChannel;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityTank
extends TileEntityMultiBlock
implements IFluidHandler,
IIrrigationComponent,
IDebuggable {
    public static final int SYNC_DELTA = 500;
    public static final int DISCRETE_MAX = 16;
    public static final int SINGLE_CAPACITY = 8000;
    private int fluidLevel = 0;
    private int lastDiscreteLvl = 0;

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.fluidLevel > 0) {
            tag.func_74768_a("level", this.fluidLevel);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (this.getComponent().isController && tag.func_74764_b("level")) {
            this.fluidLevel = tag.func_74762_e("level");
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            BiomeGenBase biome;
            if (this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.field_145850_b.func_72896_J() && !this.getComponent().hasNeighbour(ForgeDirection.UP) && (biome = this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e)) != BiomeGenBase.field_76769_d && biome != BiomeGenBase.field_76786_s) {
                this.setFluidLevel(this.getFluidLevel() + 1);
            }
            if (ConfigurationHandler.fillFromFlowingWater && (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == Blocks.field_150355_j || this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == Blocks.field_150358_i)) {
                this.setFluidLevel(this.getFluidLevel() + 5);
            }
        }
    }

    @Override
    public void syncFluidLevel() {
        int newDiscreteLvl = this.getDiscreteFluidLevel();
        if (newDiscreteLvl != this.lastDiscreteLvl) {
            this.lastDiscreteLvl = newDiscreteLvl;
            MessageSyncFluidLevel msg = new MessageSyncFluidLevel(this.fluidLevel, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0);
            NetworkWrapperAgriCraft.wrapper.sendToAllAround((IMessage)msg, point);
        }
    }

    public boolean isConnectedToChannel(ForgeDirection direction) {
        TileEntity tile;
        if (this.field_145850_b != null && direction != ForgeDirection.UNKNOWN && direction.offsetY == 0 && (tile = this.func_145831_w().func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ)) instanceof TileEntityChannel) {
            return ((TileEntityChannel)tile).isSameMaterial(this);
        }
        return false;
    }

    @Override
    public boolean canJoinMultiBlock(TileEntity tileEntity) {
        return tileEntity instanceof TileEntityTank && ((TileEntityTank)tileEntity).isSameMaterial(this);
    }

    @Override
    public void addBlock() {
        if (!this.getComponent().isController) {
            this.setFluidLevel(this.getFluidLevel() + this.fluidLevel);
            this.fluidLevel = 0;
        }
    }

    @Override
    public void breakMultiPart(TileEntityMultiBlock controller) {
        if (!(controller instanceof TileEntityTank)) {
            LogHelper.error("The tank controller isn't the right type of multiblock! How is this possible?");
            return;
        }
        TileEntityTank tank = (TileEntityTank)controller;
        this.fluidLevel = tank.getFluidLevel() / tank.getComponent().size;
    }

    public FluidStack getContents() {
        return new FluidStack(FluidRegistry.WATER, this.getFluidLevel());
    }

    @Override
    public int getFluidLevel() {
        TileEntity te;
        if (!this.getComponent().isController && (te = this.field_145850_b.func_147438_o(this.getComponent().anchorX, this.getComponent().anchorY, this.getComponent().anchorZ)) instanceof TileEntityTank) {
            return ((TileEntityTank)te).fluidLevel;
        }
        return this.fluidLevel;
    }

    public int getDiscreteFluidLevel() {
        float discreteFactor = 16.0f / (8000.0f * (float)this.getComponent().sizeX * (float)this.getComponent().sizeZ);
        int discreteFluidLevel = Math.round(discreteFactor * (float)this.getFluidLevel());
        if (discreteFluidLevel < 2 && this.getFluidLevel() > 0) {
            discreteFluidLevel = 2;
        }
        return discreteFluidLevel;
    }

    @Override
    public float getFluidHeight() {
        return this.getDiscreteFluidLevel();
    }

    @Override
    public int pushFluid(int amount) {
        if (!this.field_145850_b.field_72995_K && this.canAccept() && amount >= 0) {
            int room = this.getCapacity() - this.getFluidLevel();
            if (room >= amount) {
                this.setFluidLevel(this.getFluidLevel() + amount);
                amount = 0;
            } else if (room > 0) {
                this.setFluidLevel(this.getCapacity());
                amount -= room;
            }
        }
        return amount;
    }

    @Override
    public int pullFluid(int amount) {
        if (!this.field_145850_b.field_72995_K && this.canProvide() && amount >= 0) {
            if (amount <= this.getFluidLevel()) {
                this.setFluidLevel(this.getFluidLevel() - amount);
            } else {
                amount = this.getFluidLevel();
                this.setFluidLevel(0);
            }
        }
        return amount;
    }

    @Override
    public void setFluidLevel(int lvl) {
        if (lvl != this.getFluidLevel()) {
            int n = lvl = lvl > this.getCapacity() ? this.getCapacity() : lvl;
            if (!(this.field_145850_b.func_147438_o(this.getComponent().anchorX, this.getComponent().anchorY, this.getComponent().anchorZ) instanceof TileEntityTank)) {
                return;
            }
            TileEntityTank tank = (TileEntityTank)this.field_145850_b.func_147438_o(this.getComponent().anchorX, this.getComponent().anchorY, this.getComponent().anchorZ);
            if (tank != null) {
                tank.fluidLevel = lvl;
                if (!tank.field_145850_b.field_72995_K) {
                    tank.syncFluidLevel();
                }
            }
        }
    }

    @Override
    public boolean canConnectTo(IIrrigationComponent component) {
        return false;
    }

    @Override
    public int getCapacity() {
        return 8000 * this.getComponent().size;
    }

    @Override
    public boolean canAccept() {
        return this.getFluidLevel() < this.getCapacity();
    }

    @Override
    public boolean canProvide() {
        return this.getFluidLevel() > 0;
    }

    public boolean isEmpty() {
        return this.getFluidLevel() == 0;
    }

    public int fill(ForgeDirection from, int amount, boolean doFill) {
        return this.fill(from, new FluidStack(FluidRegistry.WATER, amount), doFill);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || !this.canFill(from, resource.getFluid())) {
            return 0;
        }
        int filled = Math.min(resource.amount, this.getCapacity() - this.getFluidLevel());
        if (doFill && !this.field_145850_b.field_72995_K) {
            this.setFluidLevel(this.getFluidLevel() + filled);
        }
        return filled;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.canDrain(from, resource.getFluid())) {
            return null;
        }
        int drained = Math.min(resource.amount, this.getFluidLevel());
        if (doDrain && !this.field_145850_b.field_72995_K) {
            this.setFluidLevel(this.getFluidLevel() - drained);
        }
        return new FluidStack(FluidRegistry.WATER, drained);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(from, new FluidStack(FluidRegistry.WATER, maxDrain), doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER && this.canAccept();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.WATER && this.canProvide();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] info = new FluidTankInfo[]{new FluidTankInfo(this.getContents(), this.getCapacity())};
        return info;
    }

    @Override
    public void addDebugInfo(List<String> list) {
        super.addDebugInfo(list);
        list.add("TANK:");
        list.add("Tank: (single capacity: 8000)");
        list.add("  - FluidLevel: " + this.getFluidLevel() + "/" + this.getCapacity());
        list.add("  - Water level is on layer " + (int)Math.floor(((float)this.getFluidLevel() - 0.1f) / (float)(this.getCapacity() * this.getComponent().sizeX * this.getComponent().sizeZ)) + ".");
        list.add("  - Water height is " + this.getFluidHeight());
    }

    @Override
    public void addWailaInformation(List information) {
        super.addWailaInformation(information);
        information.add(StatCollector.func_74838_a((String)"agricraft_tooltip.waterLevel") + ": " + this.getFluidLevel() + "/" + this.getCapacity());
    }
}

