/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.tileentity.storage;

import com.InfinityRaider.AgriCraft.api.v1.IDebuggable;
import com.InfinityRaider.AgriCraft.network.MessageTileEntitySeedStorage;
import com.InfinityRaider.AgriCraft.network.NetworkWrapperAgriCraft;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCustomWood;
import com.InfinityRaider.AgriCraft.tileentity.storage.ISeedStorageControllable;
import com.InfinityRaider.AgriCraft.tileentity.storage.ISeedStorageController;
import com.InfinityRaider.AgriCraft.tileentity.storage.SeedStorageSlot;
import com.InfinityRaider.AgriCraft.utility.NBTHelper;
import com.InfinityRaider.AgriCraft.utility.SeedHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySeedStorage
extends TileEntityCustomWood
implements ISeedStorageControllable,
IDebuggable {
    public ForgeDirection direction;
    private Item lockedSeed;
    private int lockedSeedMeta;
    private Map<Integer, SeedStorageSlot> slots = new HashMap<Integer, SeedStorageSlot>();
    private ISeedStorageController controller;

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.direction != null) {
            tag.func_74774_a("direction", (byte)this.direction.ordinal());
        }
        if (this.lockedSeed != null) {
            NBTTagCompound seedTag = new NBTTagCompound();
            ItemStack seedStack = new ItemStack(this.lockedSeed, 1, this.lockedSeedMeta);
            seedStack.func_77955_b(seedTag);
            tag.func_74782_a("seed", (NBTBase)seedTag);
            if (this.slots != null) {
                NBTTagList tagList = new NBTTagList();
                for (Map.Entry<Integer, SeedStorageSlot> entry : this.slots.entrySet()) {
                    if (entry == null || entry.getValue() == null) continue;
                    SeedStorageSlot slot = entry.getValue();
                    NBTTagCompound stackTag = slot.getTag();
                    NBTTagCompound slotTag = new NBTTagCompound();
                    slotTag.func_74768_a("count", slot.count);
                    slotTag.func_74777_a("growth", stackTag.func_74765_d("growth"));
                    slotTag.func_74777_a("gain", stackTag.func_74765_d("gain"));
                    slotTag.func_74777_a("strength", stackTag.func_74765_d("strength"));
                    slotTag.func_74768_a("id", slot.getId());
                    tagList.func_74742_a((NBTBase)slotTag);
                }
                tag.func_74782_a("agricraftInv", (NBTBase)tagList);
            }
        }
        if (this.hasController()) {
            NBTHelper.addCoordsToNBT(this.controller.getCoordinates(), tag);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        int[] coords;
        super.func_145839_a(tag);
        if (tag.func_74764_b("direction")) {
            this.setDirection(tag.func_74771_c("direction"));
        }
        this.slots = new HashMap<Integer, SeedStorageSlot>();
        if (tag.func_74764_b("seed")) {
            ItemStack seedStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("seed"));
            this.lockedSeed = seedStack.func_77973_b();
            this.lockedSeedMeta = seedStack.func_77960_j();
            if (tag.func_74764_b("agricraftInv")) {
                NBTTagList tagList = tag.func_150295_c("agricraftInv", 10);
                int invId = this.getControllableID();
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound slotTag = tagList.func_150305_b(i);
                    NBTTagCompound stackTag = new NBTTagCompound();
                    SeedHelper.setNBT(stackTag, slotTag.func_74765_d("growth"), slotTag.func_74765_d("gain"), slotTag.func_74765_d("strength"), true);
                    int id = slotTag.func_74762_e("id");
                    this.slots.put(id, new SeedStorageSlot(stackTag, slotTag.func_74762_e("count"), id, invId));
                }
            }
        } else {
            this.lockedSeed = null;
            this.lockedSeedMeta = 0;
        }
        if ((coords = NBTHelper.getCoordsFromNBT(tag)) != null && coords.length == 3) {
            this.controller = (ISeedStorageController)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean func_145842_c(int id, int data) {
        if (this.field_145850_b.field_72995_K) {
            this.func_70298_a(id, data);
        }
        return true;
    }

    public void setDirection(int direction) {
        this.direction = ForgeDirection.getOrientation((int)direction);
    }

    public void syncSlotToClient(SeedStorageSlot slot) {
        NetworkWrapperAgriCraft.wrapper.sendToDimension((IMessage)new MessageTileEntitySeedStorage(this.field_145851_c, this.field_145848_d, this.field_145849_e, slot), this.field_145850_b.field_73011_w.field_76574_g);
        this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e).func_76630_e();
    }

    @Override
    public boolean addStackToInventory(ItemStack stack) {
        boolean success = false;
        if (!SeedHelper.isAnalyzedSeed(stack)) {
            return false;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.hasLockedSeed() && this.lockedSeed == stack.func_77973_b() && this.lockedSeedMeta == stack.func_77960_j()) {
                for (Map.Entry<Integer, SeedStorageSlot> entry : this.slots.entrySet()) {
                    if (entry.getValue() == null || !ItemStack.func_77970_a((ItemStack)entry.getValue().getStack(this.lockedSeed, this.lockedSeedMeta), (ItemStack)stack)) continue;
                    ItemStack newStack = stack.func_77946_l();
                    newStack.field_77994_a += entry.getValue().count;
                    this.func_70299_a(entry.getKey(), newStack);
                    success = true;
                    break;
                }
                if (!success) {
                    if (this.slots.size() == 0) {
                        this.func_70299_a(0, stack);
                        success = true;
                    } else {
                        int slotId = this.getFirstFreeSlot();
                        if (slotId >= 0) {
                            this.func_70299_a(slotId, stack);
                            success = true;
                        }
                    }
                }
            } else {
                this.setLockedSeed(stack.func_77973_b(), stack.func_77960_j());
                this.func_70299_a(0, stack);
                success = true;
            }
        }
        return success;
    }

    public int getFirstFreeSlot() {
        for (int i = 0; i < 1000; ++i) {
            if (this.slots.containsKey(i)) continue;
            return i;
        }
        return -1;
    }

    public ArrayList<ItemStack> getInventory() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.hasLockedSeed()) {
            for (Map.Entry<Integer, SeedStorageSlot> entries : this.slots.entrySet()) {
                if (entries == null || entries.getValue() == null) continue;
                stacks.add(entries.getValue().getStack(this.lockedSeed, this.lockedSeedMeta));
            }
        }
        return stacks;
    }

    @Override
    public List<SeedStorageSlot> getSlots(Item seed, int meta) {
        ArrayList<SeedStorageSlot> list = new ArrayList<SeedStorageSlot>();
        if (this.lockedSeed != null && this.lockedSeed == seed && this.lockedSeedMeta == meta) {
            list = new ArrayList<SeedStorageSlot>(this.slots.values());
        }
        return list;
    }

    @Override
    public int[] getControllerCoords() {
        return this.controller != null ? this.controller.getCoordinates() : null;
    }

    @Override
    public int[] getCoords() {
        return new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Override
    public ISeedStorageController getController() {
        return this.controller;
    }

    @Override
    public boolean hasController() {
        return this.controller != null;
    }

    @Override
    public boolean hasLockedSeed() {
        return this.lockedSeed != null;
    }

    @Override
    public void setLockedSeed(Item seed, int meta) {
        if (!this.hasLockedSeed()) {
            this.lockedSeed = seed;
            this.lockedSeedMeta = meta;
            this.markForUpdate();
        }
    }

    @Override
    public void clearLockedSeed() {
        if (this.slots.size() == 0) {
            this.lockedSeed = null;
            this.lockedSeedMeta = 0;
            this.markForUpdate();
        }
    }

    @Override
    public ItemStack getLockedSeed() {
        return new ItemStack(this.lockedSeed, 1, this.lockedSeedMeta);
    }

    @Override
    public int getControllableID() {
        int id = -1;
        if (this.hasController()) {
            id = this.getController().getControllableID(this);
        }
        return id;
    }

    public int func_70302_i_() {
        return this.slots.size() + 1;
    }

    public ItemStack func_70301_a(int slot) {
        SeedStorageSlot slotAt;
        ItemStack stackInSlot = null;
        if (this.slots != null && (slotAt = this.slots.get(slot %= 1000)) != null) {
            stackInSlot = slotAt.getStack(this.lockedSeed, this.lockedSeedMeta);
        }
        return stackInSlot;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (!this.field_145850_b.field_72995_K) {
            slot %= 1000;
            ItemStack stackInSlot = null;
            if (this.slots != null) {
                SeedStorageSlot slotAt = this.slots.get(slot);
                if (slotAt != null) {
                    stackInSlot = slotAt.getStack(this.lockedSeed, this.lockedSeedMeta);
                    stackInSlot.field_77994_a = Math.min(amount, slotAt.count);
                    if (slotAt.count <= amount) {
                        this.slots.remove(slot);
                        slotAt.count = 0;
                    } else {
                        slotAt.count -= amount;
                    }
                }
                this.syncSlotToClient(slotAt);
            }
            return stackInSlot;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        slot %= 1000;
        ItemStack stackInSlot = null;
        if (this.slots != null) {
            stackInSlot = this.func_70301_a(slot).func_77946_l();
            this.slots.remove(slot);
        }
        return stackInSlot;
    }

    public void func_70299_a(int slot, ItemStack inputStack) {
        if (this.func_94041_b(slot %= 1000, inputStack)) {
            SeedStorageSlot slotAt = this.slots.get(slot);
            if (slotAt != null) {
                slotAt.count = inputStack.field_77994_a;
                if (slotAt.count <= 0) {
                    this.slots.remove(slot);
                }
            } else {
                slotAt = new SeedStorageSlot(inputStack.func_77978_p(), inputStack.field_77994_a, slot, this.getControllableID());
                if (slotAt.count > 0) {
                    this.slots.put(slot, slotAt);
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                this.syncSlotToClient(slotAt);
            } else {
                this.markForUpdate();
            }
        }
    }

    public String func_145825_b() {
        return "AgriCraft".toLowerCase() + ":" + "seedStorage";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return Integer.MAX_VALUE;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (!SeedHelper.isAnalyzedSeed(stack)) {
            return false;
        }
        if (this.hasLockedSeed()) {
            if (stack.func_77973_b() == this.lockedSeed && stack.func_77960_j() == this.lockedSeedMeta && SeedHelper.isAnalyzedSeed(stack)) {
                SeedStorageSlot slotAt = this.slots.get(slot);
                return slotAt == null || ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.func_70301_a(slot));
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    public void addDebugInfo(List<String> list) {
        String info = this.lockedSeed == null ? "null" : this.getLockedSeed().func_82833_r();
        int size = this.slots == null ? 0 : this.slots.size();
        list.add("Locked Seed: " + info);
        list.add("Number of seeds: " + size);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }
}

