/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.utility;

import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class RenderHelper {
    public static ResourceLocation getResource(Block block, int meta) {
        return RenderHelper.getBlockResource(RenderHelper.getIcon(block, meta));
    }

    public static ResourceLocation getResource(Item item, int meta) {
        return RenderHelper.getItemResource(RenderHelper.getIcon(item, meta));
    }

    public static IIcon getIcon(Item item, int meta) {
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).field_150939_a.func_149691_a(3, meta);
        }
        return item.func_77617_a(meta);
    }

    public static IIcon getIcon(Block block, int meta) {
        return block.func_149691_a(0, meta);
    }

    public static ResourceLocation getBlockResource(IIcon icon) {
        if (icon == null) {
            return null;
        }
        String path = icon.func_94215_i();
        String domain = path.substring(0, path.indexOf(":") + 1);
        String file = path.substring(path.indexOf(58) + 1);
        return new ResourceLocation(domain + "textures/blocks/" + file + ".png");
    }

    public static ResourceLocation getItemResource(IIcon icon) {
        if (icon == null) {
            return null;
        }
        String path = icon.func_94215_i();
        String domain = path.substring(0, path.indexOf(":") + 1);
        String file = path.substring(path.indexOf(58) + 1);
        return new ResourceLocation(domain + "textures/items/" + file + ".png");
    }

    public static boolean isLeverFacingBlock(int leverMeta, ForgeDirection direction) {
        switch (direction) {
            case EAST: {
                return leverMeta % 8 == 1;
            }
            case WEST: {
                return leverMeta % 8 == 2;
            }
            case SOUTH: {
                return leverMeta % 8 == 3;
            }
            case NORTH: {
                return leverMeta % 8 == 4;
            }
        }
        return false;
    }

    @Deprecated
    public static ForgeDirection convertDirection(char axis, int direction) {
        if (axis == 'x') {
            if (direction > 0) {
                return ForgeDirection.EAST;
            }
            return ForgeDirection.WEST;
        }
        if (axis == 'y') {
            if (direction > 0) {
                return ForgeDirection.UP;
            }
            return ForgeDirection.DOWN;
        }
        if (axis == 'z') {
            if (direction > 0) {
                return ForgeDirection.SOUTH;
            }
            return ForgeDirection.NORTH;
        }
        return ForgeDirection.UNKNOWN;
    }

    @Deprecated
    public static char getAxis(ForgeDirection direction) {
        switch (direction) {
            case EAST: 
            case WEST: {
                return 'x';
            }
            case UP: 
            case DOWN: {
                return 'y';
            }
            case SOUTH: 
            case NORTH: {
                return 'z';
            }
        }
        return '?';
    }

    @Deprecated
    public static int getMagnitude(ForgeDirection direction) {
        return direction.offsetX + direction.offsetY + direction.offsetZ;
    }

    public static float[] rotatePrism(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, ForgeDirection direction) {
        float[] adj = new float[6];
        switch (direction) {
            default: {
                adj[0] = minX;
                adj[1] = minY;
                adj[2] = minZ;
                adj[3] = maxX;
                adj[4] = maxY;
                adj[5] = maxZ;
                break;
            }
            case EAST: {
                adj[0] = 16.0f - maxZ;
                adj[1] = minY;
                adj[2] = minX;
                adj[3] = 16.0f - minZ;
                adj[4] = maxY;
                adj[5] = maxX;
                break;
            }
            case SOUTH: {
                adj[0] = minX;
                adj[1] = minY;
                adj[2] = 16.0f - maxZ;
                adj[3] = maxX;
                adj[4] = maxY;
                adj[5] = 16.0f - minZ;
                break;
            }
            case WEST: {
                adj[0] = minZ;
                adj[1] = minY;
                adj[2] = minX;
                adj[3] = maxZ;
                adj[4] = maxY;
                adj[5] = maxX;
                break;
            }
            case UP: {
                adj[0] = minX;
                adj[1] = 16.0f - maxZ;
                adj[2] = minY;
                adj[3] = maxX;
                adj[4] = 16.0f - minZ;
                adj[5] = maxY;
            }
            case DOWN: {
                adj[0] = minX;
                adj[1] = minZ;
                adj[2] = minY;
                adj[3] = maxX;
                adj[4] = maxZ;
                adj[5] = maxY;
            }
        }
        return adj;
    }

    public static void addScaledVertexWithUV(Tessellator tessellator, float x, float y, float z, float u, float v) {
        tessellator.func_78374_a((double)(x * 0.0625f), (double)(y * 0.0625f), (double)(z * 0.0625f), (double)(u * 0.0625f), (double)(v * 0.0625f));
    }

    public static void addScaledVertexWithUV(Tessellator tessellator, float x, float y, float z, float u, float v, IIcon icon) {
        tessellator.func_78374_a((double)(x * 0.0625f), (double)(y * 0.0625f), (double)(z * 0.0625f), (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
    }

    public static String splitInLines(FontRenderer fontRendererObj, String input, float maxWidth, float scale) {
        maxWidth /= scale;
        String notProcessed = input;
        String output = "";
        while ((float)fontRendererObj.func_78256_a(notProcessed) > maxWidth) {
            int index = 0;
            if (notProcessed == null || notProcessed.equals("")) continue;
            while (notProcessed.length() - 1 > index && (float)fontRendererObj.func_78256_a(notProcessed.substring(0, index)) < maxWidth) {
                index = index + 1 < notProcessed.length() ? index + 1 : index;
            }
            while (index > 0 && notProcessed.charAt(index) != ' ') {
                --index;
            }
            output = output.equals("") ? output : output + '\n';
            output = output + notProcessed.substring(0, index);
            notProcessed = notProcessed.length() > index + 1 ? notProcessed.substring(index + 1) : notProcessed;
        }
        return output + '\n' + notProcessed;
    }
}

