/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.redlogic;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.compat.CompatUtils;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;

public class SchematicRLWire
extends SchematicTile {
    private static final byte[] shiftMatrix = new byte[]{0, 1, 5, 4, 2, 3};

    private int rotateMask(int mask) {
        int newMask = mask & 0xFFFFFFC3;
        for (int i = 2; i < 6; ++i) {
            if ((mask & 1 << i) == 0) continue;
            newMask |= 1 << shiftMatrix[i];
        }
        return newMask;
    }

    public void rotateLeft(IBuilderContext context) {
        super.rotateLeft(context);
        if (this.tileNBT != null) {
            this.tileNBT.func_74774_a("mask", (byte)this.rotateMask(this.tileNBT.func_74771_c("mask")));
            if (this.tileNBT.func_74764_b("jcmc")) {
                this.tileNBT.func_74774_a("jcmc", (byte)this.rotateMask(this.tileNBT.func_74771_c("jcmc")));
            }
        }
    }

    public void storeRequirements(IBuilderContext context, int x, int y, int z) {
        int maskSize = this.tileNBT.func_74764_b("jcmc") ? 1 : 0;
        byte mask = this.tileNBT.func_74771_c("mask");
        while (mask != 0) {
            mask = (byte)(mask & mask - 1);
            ++maskSize;
        }
        this.storedRequirements = new ItemStack[1];
        this.storedRequirements[0] = new ItemStack(this.block, maskSize, (int)this.tileNBT.func_74771_c("type"));
    }

    public void initializeFromObjectAt(IBuilderContext context, int x, int y, int z) {
        super.initializeFromObjectAt(context, x, y, z);
        if (this.tileNBT != null) {
            this.tileNBT.func_82580_o("cmc");
            this.tileNBT.func_82580_o("ccc");
            this.tileNBT.func_82580_o("notifyQueued");
        }
    }

    public void placeInWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
        super.placeInWorld(context, x, y, z, stacks);
        for (int xo = -1; xo < 2; ++xo) {
            for (int yo = -1; yo < 2; ++yo) {
                for (int zo = -1; zo < 2; ++zo) {
                    if (xo == yo && xo == zo && yo == zo || (xo == 1 || xo == -1) && (yo == 1 || yo == -1) && (zo == 1 || zo == -1)) continue;
                    int xs = x + xo;
                    int ys = y + yo;
                    int zs = z + zo;
                    if (!context.world().func_147439_a(xs, ys, zs).equals(this.block)) continue;
                    context.world().func_147460_e(xs, ys, zs, this.block);
                }
            }
        }
    }

    public Schematic.BuildingStage getBuildStage() {
        return Schematic.BuildingStage.SUPPORTED;
    }

    public void postProcessing(IBuilderContext context, int x, int y, int z) {
    }

    public boolean isAlreadyBuilt(IBuilderContext context, int x, int y, int z) {
        if (this.block != context.world().func_147439_a(x, y, z)) {
            return false;
        }
        NBTTagCompound tag = CompatUtils.getTileNBT((IBlockAccess)context.world(), x, y, z);
        return tag.func_74771_c("type") == this.tileNBT.func_74771_c("type") && tag.func_74764_b("jcmc") == this.tileNBT.func_74764_b("jcmc");
    }
}

