/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class BlueprintCraftingRecipe {
    public static ArrayList<String> blueprintCategories = new ArrayList();
    public static ArrayListMultimap<String, BlueprintCraftingRecipe> recipeList = ArrayListMultimap.create();
    public static HashMap<String, ItemStack> villagerPrices = new HashMap();
    public ItemStack output;
    public Object[] inputs;

    public BlueprintCraftingRecipe(ItemStack output, Object[] inputs) {
        this.output = output;
        this.inputs = new Object[inputs.length];
        for (int io = 0; io < inputs.length; ++io) {
            this.inputs[io] = ApiUtils.convertToValidRecipeInput(inputs[io]);
        }
    }

    public boolean matchesRecipe(ItemStack[] query) {
        return this.getMaxCrafted(query) > 0;
    }

    public int getMaxCrafted(ItemStack[] query) {
        ArrayList<Object> inputList = new ArrayList<Object>();
        for (Object i : this.inputs) {
            if (i == null) continue;
            inputList.add(i instanceof ItemStack ? ((ItemStack)i).func_77946_l() : i);
        }
        ArrayList<ItemStack> queryList = new ArrayList<ItemStack>();
        for (ItemStack q : query) {
            if (q == null) continue;
            queryList.add(q.func_77946_l());
        }
        Iterator inputIt = inputList.iterator();
        int maxCrafted = 0;
        while (inputIt.hasNext()) {
            int supplied = 0;
            Object o = inputIt.next();
            Iterator queryIt = queryList.iterator();
            while (queryIt.hasNext()) {
                int taken;
                ItemStack stack = (ItemStack)queryIt.next();
                if (!ApiUtils.stackMatchesObject(stack, o)) continue;
                if (o instanceof ItemStack) {
                    taken = stack.field_77994_a / ((ItemStack)o).field_77994_a;
                    if (taken <= 0) continue;
                    stack.field_77994_a -= taken;
                    if (stack.field_77994_a <= 0) {
                        queryIt.remove();
                    }
                    supplied += taken;
                    continue;
                }
                taken = stack.field_77994_a;
                stack.field_77994_a -= taken;
                if (stack.field_77994_a <= 0) {
                    queryIt.remove();
                }
                supplied += taken;
            }
            if (supplied <= 0) {
                return 0;
            }
            maxCrafted = maxCrafted == 0 ? supplied : Math.min(maxCrafted, supplied);
        }
        return maxCrafted;
    }

    public void consumeInputs(ItemStack[] query, int crafted) {
        ArrayList<Object> inputList = new ArrayList<Object>();
        for (Object i : this.inputs) {
            if (i == null) continue;
            inputList.add(i instanceof ItemStack ? ((ItemStack)i).func_77946_l() : i);
        }
        Iterator inputIt = inputList.iterator();
        block1: while (inputIt.hasNext()) {
            Object o = inputIt.next();
            int inputSize = (o instanceof ItemStack ? ((ItemStack)o).field_77994_a : 1) * crafted;
            for (int i = 0; i < query.length; ++i) {
                if (query[i] == null || !ApiUtils.stackMatchesObject(query[i], o)) continue;
                int taken = Math.min(query[i].field_77994_a, inputSize);
                query[i].field_77994_a -= taken;
                if (query[i].field_77994_a <= 0) {
                    query[i] = null;
                }
                if ((inputSize -= taken) > 0) continue;
                inputIt.remove();
                continue block1;
            }
        }
    }

    public ArrayList<Object> getFormattedInputs() {
        LinkedHashMap<Object, Integer> sumMap = new LinkedHashMap<Object, Integer>();
        for (Object o : this.inputs) {
            if (o == null) continue;
            boolean isNew = true;
            for (Object ss : sumMap.keySet()) {
                if (ss instanceof ItemStack && o instanceof ItemStack) {
                    if (!OreDictionary.itemMatches((ItemStack)((ItemStack)ss), (ItemStack)((ItemStack)o), (boolean)true)) continue;
                    isNew = false;
                    sumMap.put(ss, (Integer)sumMap.get(ss) + ((ItemStack)o).field_77994_a);
                    continue;
                }
                if (!ss.equals(o)) continue;
                isNew = false;
                sumMap.put(ss, (Integer)sumMap.get(ss) + 1);
            }
            if (!isNew) continue;
            sumMap.put(o, o instanceof ItemStack ? ((ItemStack)o).field_77994_a : 1);
        }
        ArrayList<Object> formattedInputs = new ArrayList<Object>();
        for (Map.Entry e : sumMap.entrySet()) {
            Object ss = e.getKey();
            if (ss instanceof ItemStack) {
                formattedInputs.add(Utils.copyStackWithAmount((ItemStack)ss, (Integer)e.getValue()));
                continue;
            }
            if (!(ss instanceof ArrayList)) continue;
            ArrayList<ItemStack> oreListCopy = new ArrayList<ItemStack>();
            for (ItemStack oreStack : (ArrayList)ss) {
                oreListCopy.add(Utils.copyStackWithAmount(oreStack, (Integer)e.getValue()));
            }
            formattedInputs.add(oreListCopy);
        }
        return formattedInputs;
    }

    public static void addRecipe(String blueprintCategory, ItemStack output, Object ... inputs) {
        recipeList.put((Object)blueprintCategory, (Object)new BlueprintCraftingRecipe(output, inputs));
        if (!blueprintCategories.contains(blueprintCategory)) {
            blueprintCategories.add(blueprintCategory);
        }
    }

    public static BlueprintCraftingRecipe[] findRecipes(String blueprintCategory) {
        if (recipeList.containsKey((Object)blueprintCategory)) {
            List list = recipeList.get((Object)blueprintCategory);
            return list.toArray(new BlueprintCraftingRecipe[list.size()]);
        }
        return new BlueprintCraftingRecipe[0];
    }

    public static void addVillagerTrade(String blueprintCategory, ItemStack villagerPrice) {
        villagerPrices.put(blueprintCategory, villagerPrice);
    }
}

