/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CrusherRecipe {
    public final String oreInputString;
    public final Object input;
    public final ItemStack output;
    public final int energy;
    public ItemStack[] secondaryOutput;
    public float[] secondaryChance;
    public static ArrayList<CrusherRecipe> recipeList = new ArrayList();

    public CrusherRecipe(ItemStack output, Object input, int energy) {
        this.output = output;
        this.input = ApiUtils.convertToValidRecipeInput(input);
        this.oreInputString = input instanceof String ? (String)input : null;
        this.energy = energy;
    }

    public CrusherRecipe addToSecondaryOutput(Object ... outputs) {
        int i;
        if (outputs.length % 2 != 0) {
            return this;
        }
        ArrayList<ItemStack> newSecondaryOutput = new ArrayList<ItemStack>();
        ArrayList<Float> newSecondaryChance = new ArrayList<Float>();
        if (this.secondaryOutput != null) {
            for (i = 0; i < this.secondaryOutput.length; ++i) {
                newSecondaryOutput.add(this.secondaryOutput[i * 2]);
                newSecondaryChance.add(Float.valueOf(this.secondaryChance[i * 2 + 1]));
            }
        }
        for (i = 0; i < outputs.length / 2; ++i) {
            ItemStack ss;
            if (outputs[i * 2] == null) continue;
            Object o = ApiUtils.convertToValidRecipeInput(outputs[i * 2]);
            Object object = o instanceof ItemStack ? (ItemStack)o : (ss = o instanceof ArrayList ? (ItemStack)((ArrayList)o).get(0) : null);
            if (ss == null) continue;
            newSecondaryOutput.add(ss);
            newSecondaryChance.add((Float)outputs[i * 2 + 1]);
        }
        this.secondaryOutput = newSecondaryOutput.toArray(new ItemStack[newSecondaryOutput.size()]);
        this.secondaryChance = new float[newSecondaryChance.size()];
        i = 0;
        for (Float f : newSecondaryChance) {
            this.secondaryChance[i++] = f.floatValue();
        }
        return this;
    }

    public static CrusherRecipe addRecipe(ItemStack output, Object input, int energy) {
        CrusherRecipe r = new CrusherRecipe(output, input, energy);
        if (r.input != null) {
            recipeList.add(r);
        }
        return r;
    }

    public static CrusherRecipe findRecipe(ItemStack input) {
        for (CrusherRecipe recipe : recipeList) {
            if (!ApiUtils.stackMatchesObject(input, recipe.input)) continue;
            return recipe;
        }
        return null;
    }

    public static List<CrusherRecipe> removeRecipes(ItemStack stack) {
        ArrayList<CrusherRecipe> list = new ArrayList<CrusherRecipe>();
        Iterator<CrusherRecipe> it = recipeList.iterator();
        while (it.hasNext()) {
            CrusherRecipe ir = it.next();
            if (!OreDictionary.itemMatches((ItemStack)ir.output, (ItemStack)stack, (boolean)true)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }
}

