/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.energy;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.IESaveData;
import com.google.common.collect.ArrayListMultimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ImmersiveNetHandler {
    public static ImmersiveNetHandler INSTANCE;
    public HashMap<Integer, ArrayListMultimap<ChunkCoordinates, Connection>> directConnections = new HashMap();
    public ArrayListMultimap<ChunkCoordinates, AbstractConnection> indirectConnections = ArrayListMultimap.create();

    private ArrayListMultimap<ChunkCoordinates, Connection> getMultimap(int dimension) {
        if (this.directConnections.get(dimension) == null) {
            ArrayListMultimap mm = ArrayListMultimap.create();
            this.directConnections.put(dimension, (ArrayListMultimap<ChunkCoordinates, Connection>)mm);
        }
        return this.directConnections.get(dimension);
    }

    public void addConnection(World world, ChunkCoordinates node, ChunkCoordinates connection, int distance, WireType cableType) {
        this.getMultimap(world.field_73011_w.field_76574_g).get((Object)node).add(new Connection(node, connection, cableType, distance));
        this.getMultimap(world.field_73011_w.field_76574_g).get((Object)connection).add(new Connection(connection, node, cableType, distance));
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.indirectConnections.clear();
        }
        IESaveData.setDirty(world.field_73011_w.field_76574_g);
    }

    public void addConnection(World world, ChunkCoordinates node, Connection con) {
        this.getMultimap(world.field_73011_w.field_76574_g).put((Object)node, (Object)con);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.indirectConnections.clear();
        }
        IESaveData.setDirty(world.field_73011_w.field_76574_g);
    }

    public Set<Integer> getRelevantDimensions() {
        return this.directConnections.keySet();
    }

    public Collection<Connection> getAllConnections(World world) {
        return this.getMultimap(world.field_73011_w.field_76574_g).values();
    }

    public List<Connection> getConnections(World world, ChunkCoordinates node) {
        return this.getMultimap(world.field_73011_w.field_76574_g).get((Object)node);
    }

    public void clearAllConnections(World world) {
        this.getMultimap(world.field_73011_w.field_76574_g).clear();
    }

    public void clearConnectionsOriginatingFrom(ChunkCoordinates node, World world) {
        this.getMultimap(world.field_73011_w.field_76574_g).removeAll((Object)node);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.indirectConnections.clear();
        }
    }

    public void resetCachedIndirectConnections() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.indirectConnections.clear();
        }
    }

    public void clearAllConnectionsFor(ChunkCoordinates node, World world) {
        this.getMultimap(world.field_73011_w.field_76574_g).removeAll((Object)node);
        IImmersiveConnectable iic = ApiUtils.toIIC(node, world);
        if (iic != null) {
            iic.removeCable(null);
        }
        Iterator it = this.getMultimap(world.field_73011_w.field_76574_g).values().iterator();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            if (!node.equals((Object)con.start) && !node.equals((Object)con.end)) continue;
            it.remove();
            iic = ApiUtils.toIIC(con.end, world);
            if (iic != null) {
                iic.removeCable(con);
            }
            if ((iic = ApiUtils.toIIC(con.start, world)) != null) {
                iic.removeCable(con);
            }
            if (!node.equals((Object)con.end)) continue;
            double dx = (double)node.field_71574_a + 0.5 + (double)Math.signum(con.start.field_71574_a - con.end.field_71574_a);
            double dy = (double)node.field_71572_b + 0.5 + (double)Math.signum(con.start.field_71572_b - con.end.field_71572_b);
            double dz = (double)node.field_71573_c + 0.5 + (double)Math.signum(con.start.field_71573_c - con.end.field_71573_c);
            world.func_72838_d((Entity)new EntityItem(world, dx, dy, dz, con.cableType.getWireCoil()));
        }
        IESaveData.setDirty(world.field_73011_w.field_76574_g);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.indirectConnections.clear();
        }
    }

    public void clearAllConnectionsFor(ChunkCoordinates node, World world, TargetingInfo target) {
        WireType type;
        IImmersiveConnectable iic = ApiUtils.toIIC(node, world);
        WireType wireType = type = target == null ? null : iic.getCableLimiter(target);
        if (type == null) {
            return;
        }
        Iterator it = this.getMultimap(world.field_73011_w.field_76574_g).values().iterator();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            if (con.cableType != type || !node.equals((Object)con.start) && !node.equals((Object)con.end)) continue;
            it.remove();
            ApiUtils.toIIC(con.end, world).removeCable(con);
            ApiUtils.toIIC(con.start, world).removeCable(con);
            if (!node.equals((Object)con.end)) continue;
            double dx = (double)node.field_71574_a + 0.5 + (double)Math.signum(con.start.field_71574_a - con.end.field_71574_a);
            double dy = (double)node.field_71572_b + 0.5 + (double)Math.signum(con.start.field_71572_b - con.end.field_71572_b);
            double dz = (double)node.field_71573_c + 0.5 + (double)Math.signum(con.start.field_71573_c - con.end.field_71573_c);
            world.func_72838_d((Entity)new EntityItem(world, dx, dy, dz, con.cableType.getWireCoil()));
        }
        IESaveData.setDirty(world.field_73011_w.field_76574_g);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.indirectConnections.clear();
        }
    }

    public List<AbstractConnection> getIndirectEnergyConnections(ChunkCoordinates node, World world) {
        if (this.indirectConnections.containsKey((Object)node)) {
            return this.indirectConnections.get((Object)node);
        }
        ArrayList<IImmersiveConnectable> openList = new ArrayList<IImmersiveConnectable>();
        ArrayList<AbstractConnection> closedList = new ArrayList<AbstractConnection>();
        ArrayList<ChunkCoordinates> checked = new ArrayList<ChunkCoordinates>();
        HashMap<ChunkCoordinates, ChunkCoordinates> backtracker = new HashMap<ChunkCoordinates, ChunkCoordinates>();
        checked.add(node);
        for (Connection con : this.getConnections(world, node)) {
            if (ApiUtils.toIIC(con.end, world) == null) continue;
            openList.add(ApiUtils.toIIC(con.end, world));
            backtracker.put(con.end, node);
        }
        IImmersiveConnectable next = null;
        int closedListMax = 1200;
        while (closedList.size() < 1200 && !openList.isEmpty()) {
            next = (IImmersiveConnectable)openList.get(0);
            if (!checked.contains(ApiUtils.toCC(next))) {
                if (next.isEnergyOutput()) {
                    ChunkCoordinates last = ApiUtils.toCC(next);
                    WireType averageType = null;
                    int distance = 0;
                    ArrayList<Connection> connectionParts = new ArrayList<Connection>();
                    block2: while (last != null) {
                        ChunkCoordinates prev = last;
                        if ((last = (ChunkCoordinates)backtracker.get(last)) == null) continue;
                        for (Connection conB : this.getConnections(world, prev)) {
                            if (!conB.end.equals((Object)last)) continue;
                            connectionParts.add(conB);
                            distance += conB.length;
                            if (averageType != null && conB.cableType.getTransferRate() >= averageType.getTransferRate()) continue block2;
                            averageType = conB.cableType;
                            continue block2;
                        }
                    }
                    closedList.add(new AbstractConnection(ApiUtils.toCC(node), ApiUtils.toCC(next), averageType, distance, connectionParts.toArray(new Connection[connectionParts.size()])));
                }
                for (Connection con : this.getConnections(world, ApiUtils.toCC(next))) {
                    if (!next.allowEnergyToPass(con) || ApiUtils.toIIC(con.end, world) == null || checked.contains(con.end) || openList.contains(ApiUtils.toIIC(con.end, world))) continue;
                    openList.add(ApiUtils.toIIC(con.end, world));
                    backtracker.put(con.end, ApiUtils.toCC(next));
                }
                checked.add(ApiUtils.toCC(next));
            }
            openList.remove(0);
        }
        Collections.sort(closedList);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            this.indirectConnections.putAll((Object)node, closedList);
        }
        return closedList;
    }

    public static class AbstractConnection
    extends Connection
    implements Comparable<AbstractConnection> {
        public Connection[] subConnections;

        public AbstractConnection(ChunkCoordinates start, ChunkCoordinates end, WireType cableType, int length, Connection ... subConnections) {
            super(start, end, cableType, length);
            this.subConnections = subConnections;
        }

        @Override
        public int compareTo(AbstractConnection con) {
            int distComp = Integer.compare(this.length, con.length);
            int cableComp = -1 * Integer.compare(this.cableType.getTransferRate(), con.cableType.getTransferRate());
            if (distComp == 0) {
                return cableComp;
            }
            return distComp;
        }

        public float getAverageLossRate() {
            float f = 0.0f;
            for (Connection c : this.subConnections) {
                f = (float)((double)f + (double)((float)c.length / (float)c.cableType.getMaxLength()) * c.cableType.getLossRatio());
            }
            return f;
        }
    }

    public static class Connection {
        public ChunkCoordinates start;
        public ChunkCoordinates end;
        public WireType cableType;
        public int length;
        public Vec3[] catenaryVertices;

        public Connection(ChunkCoordinates start, ChunkCoordinates end, WireType cableType, int length) {
            this.start = start;
            this.end = end;
            this.cableType = cableType;
            this.length = length;
        }

        public Vec3[] getSubVertices(World world) {
            if (this.catenaryVertices == null) {
                Vec3 vStart = Vec3.func_72443_a((double)this.start.field_71574_a, (double)this.start.field_71572_b, (double)this.start.field_71573_c);
                Vec3 vEnd = Vec3.func_72443_a((double)this.end.field_71574_a, (double)this.end.field_71572_b, (double)this.end.field_71573_c);
                Vec3.func_72443_a((double)this.end.field_71574_a, (double)this.end.field_71572_b, (double)this.end.field_71573_c);
                IImmersiveConnectable iicStart = ApiUtils.toIIC(this.start, world);
                IImmersiveConnectable iicEnd = ApiUtils.toIIC(this.end, world);
                if (iicStart != null) {
                    vStart = ApiUtils.addVectors(vStart, iicStart.getConnectionOffset(this));
                }
                if (iicEnd != null) {
                    vEnd = ApiUtils.addVectors(vEnd, iicEnd.getConnectionOffset(this));
                }
                this.catenaryVertices = ApiUtils.getConnectionCatenary(this, vStart, vEnd);
            }
            return this.catenaryVertices;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Connection)) {
                return false;
            }
            Connection con = (Connection)o;
            boolean n0 = this.start.equals((Object)con.start) && this.end.equals((Object)con.end);
            boolean n1 = this.start.equals((Object)con.end) && this.end.equals((Object)con.start);
            return n0 || n1;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.start != null) {
                tag.func_74783_a("start", new int[]{this.start.field_71574_a, this.start.field_71572_b, this.start.field_71573_c});
            }
            if (this.end != null) {
                tag.func_74783_a("end", new int[]{this.end.field_71574_a, this.end.field_71572_b, this.end.field_71573_c});
            }
            tag.func_74778_a("cableType", this.cableType.getUniqueName());
            tag.func_74768_a("length", this.length);
            return tag;
        }

        public static Connection readFromNBT(NBTTagCompound tag) {
            if (tag == null) {
                return null;
            }
            int[] iStart = tag.func_74759_k("start");
            ChunkCoordinates start = new ChunkCoordinates(iStart[0], iStart[1], iStart[2]);
            int[] iEnd = tag.func_74759_k("end");
            ChunkCoordinates end = new ChunkCoordinates(iEnd[0], iEnd[1], iEnd[2]);
            WireType type = ApiUtils.getWireTypeFromNBT(tag, "cableType");
            if (start != null && end != null) {
                return new Connection(start, end, type, tag.func_74762_e("length"));
            }
            return null;
        }
    }
}

