/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.blocks.ItemBlockIEBase;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockIEBase
extends BlockContainer {
    public String name;
    public String[] subNames;
    public final IIcon[][] icons;
    protected final int iconDimensions;

    protected BlockIEBase(String name, Material mat, int iconDimensions, Class<? extends ItemBlockIEBase> itemBlock, String ... subNames) {
        super(mat);
        this.adjustSound();
        this.subNames = subNames;
        this.name = name;
        this.iconDimensions = iconDimensions;
        this.icons = new IIcon[subNames.length][iconDimensions];
        this.func_149663_c("ImmersiveEngineering." + name);
        GameRegistry.registerBlock((Block)this, itemBlock, (String)name);
        this.func_149647_a(ImmersiveEngineering.creativeTab);
    }

    void adjustSound() {
        if (this.field_149764_J == Material.field_151574_g) {
            this.field_149762_H = Block.field_149788_p;
        } else if (this.field_149764_J == Material.field_151593_r || this.field_149764_J == Material.field_151580_n) {
            this.field_149762_H = Block.field_149775_l;
        } else if (this.field_149764_J == Material.field_151592_s || this.field_149764_J == Material.field_151588_w) {
            this.field_149762_H = Block.field_149778_k;
        } else if (this.field_149764_J == Material.field_151577_b || this.field_149764_J == Material.field_151590_u || this.field_149764_J == Material.field_151585_k || this.field_149764_J == Material.field_151582_l) {
            this.field_149762_H = Block.field_149779_h;
        } else if (this.field_149764_J == Material.field_151578_c) {
            this.field_149762_H = Block.field_149767_g;
        } else if (this.field_149764_J == Material.field_151573_f) {
            this.field_149762_H = Block.field_149777_j;
        } else if (this.field_149764_J == Material.field_151595_p) {
            this.field_149762_H = Block.field_149776_m;
        } else if (this.field_149764_J == Material.field_151597_y) {
            this.field_149762_H = Block.field_149773_n;
        } else if (this.field_149764_J == Material.field_151576_e) {
            this.field_149762_H = Block.field_149769_e;
        } else if (this.field_149764_J == Material.field_151575_d || this.field_149764_J == Material.field_151570_A) {
            this.field_149762_H = Block.field_149766_f;
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.subNames.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta < this.icons.length) {
            return this.icons[meta][this.getSideForTexture(side)];
        }
        return null;
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < this.icons.length) {
            return this.icons[meta][this.getSideForTexture(side)];
        }
        return null;
    }

    protected int getSideForTexture(int side) {
        if (this.iconDimensions == 2) {
            return side == 0 || side == 1 ? 0 : 1;
        }
        if (this.iconDimensions == 4) {
            return side < 2 ? side : (side == 2 || side == 3 ? 2 : 3);
        }
        return Math.min(side, this.iconDimensions - 1);
    }

    public abstract boolean allowHammerHarvest(int var1);

    public boolean isToolEffective(String type, int metadata) {
        if ("IE_HAMMER".equals(type) && this.allowHammerHarvest(metadata)) {
            return true;
        }
        return super.isToolEffective(type, metadata);
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        if (this.func_149688_o().func_76229_l()) {
            return true;
        }
        ItemStack stack = player.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b().getToolClasses(stack).contains("IE_HAMMER") && this.allowHammerHarvest(meta)) {
            return this.getHarvestLevel(meta) < stack.func_77973_b().getHarvestLevel(stack, "IE_HAMMER");
        }
        return super.canHarvestBlock(player, meta);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 vec0, Vec3 vec1) {
        return super.func_149731_a(world, x, y, z, vec0, vec1);
    }

    protected MovingObjectPosition rayTraceAgainstBox(int x, int y, int z, Vec3 vec0, Vec3 vec1, double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        Vec3 vecMinX = vec0.func_72429_b(vec1, this.field_149759_B);
        Vec3 vecMaxX = vec0.func_72429_b(vec1, this.field_149755_E);
        Vec3 vecMinY = vec0.func_72435_c(vec1, this.field_149760_C);
        Vec3 vecMaxY = vec0.func_72435_c(vec1, this.field_149756_F);
        Vec3 vecMinZ = vec0.func_72434_d(vec1, this.field_149754_D);
        Vec3 vecMaxZ = vec0.func_72434_d(vec1, this.field_149757_G);
        if (!this.func_149654_a(vecMinX)) {
            vecMinX = null;
        }
        if (!this.func_149654_a(vecMaxX)) {
            vecMaxX = null;
        }
        if (!this.func_149687_b(vecMinY)) {
            vecMinY = null;
        }
        if (!this.func_149687_b(vecMaxY)) {
            vecMaxY = null;
        }
        if (!this.func_149661_c(vecMinZ)) {
            vecMinZ = null;
        }
        if (!this.func_149661_c(vecMaxZ)) {
            vecMaxZ = null;
        }
        Vec3 vec38 = null;
        if (vecMinX != null && (vec38 == null || vec0.func_72436_e(vecMinX) < vec0.func_72436_e(vec38))) {
            vec38 = vecMinX;
        }
        if (vecMaxX != null && (vec38 == null || vec0.func_72436_e(vecMaxX) < vec0.func_72436_e(vec38))) {
            vec38 = vecMaxX;
        }
        if (vecMinY != null && (vec38 == null || vec0.func_72436_e(vecMinY) < vec0.func_72436_e(vec38))) {
            vec38 = vecMinY;
        }
        if (vecMaxY != null && (vec38 == null || vec0.func_72436_e(vecMaxY) < vec0.func_72436_e(vec38))) {
            vec38 = vecMaxY;
        }
        if (vecMinZ != null && (vec38 == null || vec0.func_72436_e(vecMinZ) < vec0.func_72436_e(vec38))) {
            vec38 = vecMinZ;
        }
        if (vecMaxZ != null && (vec38 == null || vec0.func_72436_e(vecMaxZ) < vec0.func_72436_e(vec38))) {
            vec38 = vecMaxZ;
        }
        if (vec38 == null) {
            return null;
        }
        int b0 = -1;
        if (vec38 == vecMinX) {
            b0 = 4;
        }
        if (vec38 == vecMaxX) {
            b0 = 5;
        }
        if (vec38 == vecMinY) {
            b0 = 0;
        }
        if (vec38 == vecMaxY) {
            b0 = 1;
        }
        if (vec38 == vecMinZ) {
            b0 = 2;
        }
        if (vec38 == vecMaxZ) {
            b0 = 3;
        }
        return new MovingObjectPosition(x, y, z, b0, vec38.func_72441_c((double)x, (double)y, (double)z));
    }

    protected boolean func_149654_a(Vec3 vec) {
        return vec == null ? false : vec.field_72448_b >= this.field_149760_C && vec.field_72448_b <= this.field_149756_F && vec.field_72449_c >= this.field_149754_D && vec.field_72449_c <= this.field_149757_G;
    }

    protected boolean func_149687_b(Vec3 vec) {
        return vec == null ? false : vec.field_72450_a >= this.field_149759_B && vec.field_72450_a <= this.field_149755_E && vec.field_72449_c >= this.field_149754_D && vec.field_72449_c <= this.field_149757_G;
    }

    protected boolean func_149661_c(Vec3 vec) {
        return vec == null ? false : vec.field_72450_a >= this.field_149759_B && vec.field_72450_a <= this.field_149755_E && vec.field_72448_b >= this.field_149760_C && vec.field_72448_b <= this.field_149756_F;
    }

    public static class BlockIESimple
    extends BlockIEBase {
        public BlockIESimple(String name, Material mat, Class<? extends ItemBlockIEBase> itemBlock, String ... subNames) {
            super(name, mat, 1, itemBlock, subNames);
        }

        @Override
        public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
            return true;
        }

        @Override
        public boolean func_149662_c() {
            return true;
        }

        @Override
        public boolean func_149686_d() {
            return true;
        }

        public void func_149651_a(IIconRegister iconRegister) {
            for (int i = 0; i < this.subNames.length; ++i) {
                this.icons[i][0] = iconRegister.func_94245_a("immersiveengineering:" + this.name + "_" + this.subNames[i]);
            }
        }

        public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
            return null;
        }

        @Override
        public boolean allowHammerHarvest(int metadata) {
            return false;
        }
    }
}

