/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.aquatweaks.api.IAquaConnectable;
import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.render.BlockRenderWoodenDevices;
import blusunrize.immersiveengineering.common.blocks.BlockIEBase;
import blusunrize.immersiveengineering.common.blocks.wooden.ItemBlockWoodenDevices;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityModWorkbench;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWatermill;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWindmill;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWindmillAdvanced;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenCrate;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWoodenPost;
import blusunrize.immersiveengineering.common.util.Utils;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="blusunrize.aquatweaks.api.IAquaConnectable", modid="AquaTweaks")
public class BlockWoodenDevices
extends BlockIEBase
implements IAquaConnectable {
    public BlockWoodenDevices() {
        super("woodenDevice", Material.field_151575_d, 1, ItemBlockWoodenDevices.class, "post", "watermill", "windmill", "windmillAdvanced", "crate", "modificationWorkbench");
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
    }

    @Override
    public boolean allowHammerHarvest(int meta) {
        return true;
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.subNames.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        for (int i = 0; i < this.subNames.length; ++i) {
            this.icons[i][0] = iconRegister.func_94245_a("immersiveengineering:" + (i == 0 ? "woodenPost" : (i == 4 ? "woodenCrate" : (i == 5 ? "workbench" : "treatedWood"))));
        }
    }

    public int func_149645_b() {
        return BlockRenderWoodenDevices.renderID;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityWoodenPost) {
            byte type = ((TileEntityWoodenPost)world.func_147438_o((int)x, (int)y, (int)z)).type;
            switch (type) {
                case 0: {
                    this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 1.0f, 0.75f);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    float fd = 0.4375f;
                    float fu = 1.0f;
                    if (this.canArmConnectToBlock(world, x, y - 1, z, true)) {
                        fd = 0.0f;
                        if (!this.canArmConnectToBlock(world, x, y + 1, z, false)) {
                            fu = 0.5625f;
                        }
                    }
                    this.func_149676_a(type == 7 ? 0.0f : 0.3125f, fd, type == 5 ? 0.0f : 0.3125f, type == 6 ? 1.0f : 0.6875f, fu, type == 4 ? 1.0f : 0.6875f);
                    break;
                }
                default: {
                    this.func_149676_a(this.isPost(world, x - 1, y, z, 6) ? 0.0f : 0.3125f, 0.0f, this.isPost(world, x, y, z - 1, 4) ? 0.0f : 0.3125f, this.isPost(world, x + 1, y, z, 7) ? 1.0f : 0.6875f, 1.0f, this.isPost(world, x, y, z + 1, 5) ? 1.0f : 0.6875f);
                    break;
                }
            }
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    boolean isPost(IBlockAccess world, int x, int y, int z, int type) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityWoodenPost) {
            return ((TileEntityWoodenPost)world.func_147438_o((int)x, (int)y, (int)z)).type == type;
        }
        return world.func_147439_a(x, y, z) == this && world.func_72805_g(x, y, z) == 0;
    }

    boolean canArmConnectToBlock(IBlockAccess world, int x, int y, int z, boolean down) {
        if (world.func_147437_c(x, y, z)) {
            return false;
        }
        world.func_147439_a(x, y, z).func_149719_a(world, x, y, z);
        return down ? world.func_147439_a(x, y, z).func_149669_A() >= 1.0 : world.func_147439_a(x, y, z).func_149665_z() <= 0.0;
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return world.func_147438_o(x, y, z) instanceof TileEntityWoodenPost;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityWoodenPost && Utils.isHammer(player.func_71045_bC())) {
            byte type = ((TileEntityWoodenPost)world.func_147438_o((int)x, (int)y, (int)z)).type;
            if (type == 3) {
                ForgeDirection fd = ForgeDirection.getOrientation((int)side);
                ForgeDirection rot0 = fd.getRotation(ForgeDirection.UP);
                ForgeDirection rot1 = rot0.getOpposite();
                if (!world.func_147437_c(x + fd.offsetX, y + fd.offsetY, z + fd.offsetZ)) {
                    return false;
                }
                if (world.func_147438_o(x + rot0.offsetX, y + rot0.offsetY, z + rot0.offsetZ) instanceof TileEntityWoodenPost && ((TileEntityWoodenPost)world.func_147438_o((int)(x + rot0.offsetX), (int)(y + rot0.offsetY), (int)(z + rot0.offsetZ))).type - 2 == rot0.ordinal()) {
                    return false;
                }
                if (world.func_147438_o(x + rot1.offsetX, y + rot1.offsetY, z + rot1.offsetZ) instanceof TileEntityWoodenPost && ((TileEntityWoodenPost)world.func_147438_o((int)(x + rot1.offsetX), (int)(y + rot1.offsetY), (int)(z + rot1.offsetZ))).type - 2 == rot1.ordinal()) {
                    return false;
                }
                world.func_147465_d(x + fd.offsetX, y, z + fd.offsetZ, (Block)this, 0, 3);
                if (world.func_147438_o(x + fd.offsetX, y, z + fd.offsetZ) instanceof TileEntityWoodenPost) {
                    ((TileEntityWoodenPost)world.func_147438_o((int)(x + fd.offsetX), (int)y, (int)(z + fd.offsetZ))).type = (byte)(2 + side);
                }
            } else if (type == 4 || type == 5 || type == 6 || type == 7) {
                world.func_147468_f(x, y, z);
            }
            return true;
        }
        if (world.func_147438_o(x, y, z) instanceof TileEntityWindmillAdvanced && Utils.getDye(player.func_71045_bC()) >= 0 && ((TileEntityWindmillAdvanced)world.func_147438_o((int)x, (int)y, (int)z)).facing == side) {
            int f = ((TileEntityWindmillAdvanced)world.func_147438_o((int)x, (int)y, (int)z)).facing;
            float w = f == 2 ? 1.0f - hitX : (f == 3 ? hitX : (f == 4 ? hitZ : 1.0f - hitZ));
            double r = Math.sqrt(((double)w - 0.5) * ((double)w - 0.5) + ((double)hitY - 0.5) * ((double)hitY - 0.5));
            double ax = Math.toDegrees(Math.acos(((double)w - 0.5) / r));
            double ay = Math.toDegrees(Math.asin(((double)hitY - 0.5) / r));
            double a = (ay < 0.0 ? 360.0 - ax : ax) + 22.25;
            int sel = (4 - (int)(a / 45.0) + 6) % 8;
            if (((TileEntityWindmillAdvanced)world.func_147438_o((int)x, (int)y, (int)z)).dye[sel] == Utils.getDye(player.func_71045_bC())) {
                return false;
            }
            ((TileEntityWindmillAdvanced)world.func_147438_o((int)x, (int)y, (int)z)).dye[sel] = (byte)Utils.getDye(player.func_71045_bC());
            if (!player.field_71075_bZ.field_75098_d) {
                --player.func_71045_bC().field_77994_a;
            }
            return true;
        }
        if (!player.func_70093_af() && world.func_147438_o(x, y, z) instanceof TileEntityWoodenCrate) {
            if (!world.field_72995_K) {
                player.openGui((Object)ImmersiveEngineering.instance, 4, world, x, y, z);
            }
            return true;
        }
        if (!player.func_70093_af() && world.func_147438_o(x, y, z) instanceof TileEntityModWorkbench) {
            TileEntityModWorkbench tile = (TileEntityModWorkbench)world.func_147438_o(x, y, z);
            if (tile.dummy) {
                int zz;
                int f = tile.facing;
                int off = tile.dummyOffset;
                int xx = x - (f < 4 ? off : 0);
                if (world.func_147438_o(xx, y, zz = z - (f > 3 ? off : 0)) instanceof TileEntityModWorkbench) {
                    tile = (TileEntityModWorkbench)world.func_147438_o(xx, y, zz);
                }
            }
            if (!world.field_72995_K) {
                player.openGui((Object)ImmersiveEngineering.instance, 9, world, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
            }
            return true;
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int zz;
        int yy;
        int[] off;
        int f;
        int xx;
        if (world.func_147438_o(x, y, z) instanceof TileEntityWatermill && world.func_147438_o(xx = x - ((f = ((TileEntityWatermill)world.func_147438_o((int)x, (int)y, (int)z)).facing) == 2 || f == 3 ? off[0] : 0), yy = y - (off = ((TileEntityWatermill)world.func_147438_o((int)x, (int)y, (int)z)).offset)[1], zz = z - (f == 2 || f == 3 ? 0 : off[0])) instanceof TileEntityWatermill) {
            ((TileEntityWatermill)world.func_147438_o(xx, yy, zz)).resetRotationVec();
        }
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        if (!world.field_72995_K && world.func_147438_o(x, y, z) instanceof TileEntityWoodenCrate) {
            ItemStack stack = new ItemStack((Block)this, 1, meta);
            NBTTagCompound tag = new NBTTagCompound();
            ((TileEntityWoodenCrate)world.func_147438_o(x, y, z)).writeInv(tag, true);
            if (!tag.func_82582_d()) {
                stack.func_77982_d(tag);
            }
            world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack));
        }
    }

    public void onBlockExploded(World world, int x, int y, int z, Explosion explosion) {
        if (!world.field_72995_K && world.func_147438_o(x, y, z) instanceof TileEntityWoodenCrate) {
            ItemStack stack = new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
            NBTTagCompound tag = new NBTTagCompound();
            ((TileEntityWoodenCrate)world.func_147438_o(x, y, z)).writeInv(tag, true);
            if (!tag.func_82582_d()) {
                stack.func_77982_d(tag);
            }
            world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack));
        }
        super.onBlockExploded(world, x, y, z, explosion);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (metadata == 0 || metadata == 4) {
            return ret;
        }
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            ret.add(new ItemStack(item, 1, this.func_149692_a(metadata)));
        }
        return ret;
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        int zz;
        int f;
        if (world.func_147438_o(x, y, z) instanceof TileEntityWoodenPost) {
            int yy = y;
            byte type = ((TileEntityWoodenPost)world.func_147438_o((int)x, (int)y, (int)z)).type;
            switch (type) {
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    return;
                }
            }
            yy -= ((TileEntityWoodenPost)world.func_147438_o((int)x, (int)y, (int)z)).type;
            for (int i = 0; i <= 3; ++i) {
                world.func_147468_f(x, yy + i, z);
                if (i != 3) continue;
                for (ForgeDirection fd : new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST}) {
                    if (!(world.func_147438_o(x + fd.offsetX, yy + i, z + fd.offsetZ) instanceof TileEntityWoodenPost) || ((TileEntityWoodenPost)world.func_147438_o((int)(x + fd.offsetX), (int)(yy + i), (int)(z + fd.offsetZ))).type <= 3) continue;
                    world.func_147468_f(x + fd.offsetX, yy + i, z + fd.offsetZ);
                }
            }
            if (type == 0 && !world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots) {
                world.func_72838_d((Entity)new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack((Block)this, 1, 0)));
            }
        }
        if (world.func_147438_o(x, y, z) instanceof TileEntityWatermill) {
            int[] off = ((TileEntityWatermill)world.func_147438_o((int)x, (int)y, (int)z)).offset;
            f = ((TileEntityWatermill)world.func_147438_o((int)x, (int)y, (int)z)).facing;
            int xx = x - (f == 2 || f == 3 ? off[0] : 0);
            int yy = y - off[1];
            zz = z - (f == 2 || f == 3 ? 0 : off[0]);
            if ((off[0] != 0 || off[1] != 0) && world.func_147437_c(xx, yy, zz)) {
                return;
            }
            world.func_147468_f(xx, yy, zz);
            for (int hh = -2; hh <= 2; ++hh) {
                int r = hh < -1 || hh > 1 ? 1 : 2;
                for (int ww = -r; ww <= r; ++ww) {
                    world.func_147468_f(xx + (f == 2 || f == 3 ? ww : 0), yy + hh, zz + (f == 2 || f == 3 ? 0 : ww));
                }
            }
        }
        if (world.func_147438_o(x, y, z) instanceof TileEntityModWorkbench) {
            int xx;
            TileEntityModWorkbench tile = (TileEntityModWorkbench)world.func_147438_o(x, y, z);
            f = tile.facing;
            int off = tile.dummyOffset;
            if (tile.dummy) {
                off *= -1;
            }
            if (world.func_147438_o(xx = x + (f < 4 ? off : 0), y, zz = z + (f > 3 ? off : 0)) instanceof TileEntityModWorkbench) {
                world.func_147468_f(xx, y, zz);
            }
            if (!world.field_72995_K && !tile.dummy) {
                for (int i = 0; i < tile.func_70302_i_(); ++i) {
                    ItemStack stack = tile.func_70301_a(i);
                    if (stack == null) continue;
                    float fx = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    float fz = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + fx), (double)y + 0.5, (double)((float)z + fz), stack);
                    entityitem.field_70159_w = world.field_73012_v.nextGaussian() * 0.05;
                    entityitem.field_70181_x = world.field_73012_v.nextGaussian() * 0.05 + 0.2;
                    entityitem.field_70179_y = world.field_73012_v.nextGaussian() * 0.05;
                    if (stack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityWoodenPost();
            }
            case 1: {
                return new TileEntityWatermill();
            }
            case 2: {
                return new TileEntityWindmill();
            }
            case 3: {
                return new TileEntityWindmillAdvanced();
            }
            case 4: {
                return new TileEntityWoodenCrate();
            }
            case 5: {
                return new TileEntityModWorkbench();
            }
        }
        return null;
    }

    @Optional.Method(modid="AquaTweaks")
    public boolean shouldRenderFluid(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta == 0;
    }

    @Optional.Method(modid="AquaTweaks")
    public boolean canConnectTo(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        return meta == 0;
    }
}

