/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    static String[] dyeNames = new String[]{"Black", "Red", "Green", "Brown", "Blue", "Purple", "Cyan", "LightGray", "Gray", "Pink", "Lime", "Yellow", "LightBlue", "Magenta", "Orange", "White"};
    static Method m_getHarvestLevel = null;

    public static boolean compareToOreName(ItemStack stack, String oreName) {
        for (int oid : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)oid).equals(oreName)) continue;
            return true;
        }
        return false;
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        if (o instanceof ItemStack) {
            return OreDictionary.itemMatches((ItemStack)((ItemStack)o), (ItemStack)stack, (boolean)false);
        }
        if (o instanceof ArrayList) {
            for (Object io : (ArrayList)o) {
                if (!(io instanceof ItemStack) || !OreDictionary.itemMatches((ItemStack)((ItemStack)io), (ItemStack)stack, (boolean)false)) continue;
                return true;
            }
        } else if (o instanceof ItemStack[]) {
            for (ItemStack io : (ItemStack[])o) {
                if (!OreDictionary.itemMatches((ItemStack)io, (ItemStack)stack, (boolean)false)) continue;
                return true;
            }
        } else if (o instanceof String) {
            return Utils.compareToOreName(stack, (String)o);
        }
        return false;
    }

    public static ItemStack copyStackWithAmount(ItemStack stack, int amount) {
        ItemStack s2 = stack.func_77946_l();
        s2.field_77994_a = amount;
        return s2;
    }

    public static int getDye(ItemStack stack) {
        if (stack == null) {
            return -1;
        }
        if (stack.func_77973_b().equals(Items.field_151100_aR)) {
            return stack.func_77960_j();
        }
        for (int dye = 0; dye < dyeNames.length; ++dye) {
            if (!Utils.compareToOreName(stack, "dye" + dyeNames[dye])) continue;
            return dye;
        }
        return -1;
    }

    public static ChunkCoordinates toCC(Object object) {
        if (object instanceof ChunkCoordinates) {
            return (ChunkCoordinates)object;
        }
        if (object instanceof TileEntity) {
            return new ChunkCoordinates(((TileEntity)object).field_145851_c, ((TileEntity)object).field_145848_d, ((TileEntity)object).field_145849_e);
        }
        return null;
    }

    public static IImmersiveConnectable toIIC(Object object, World world) {
        if (object instanceof IImmersiveConnectable) {
            return (IImmersiveConnectable)object;
        }
        if (object instanceof ChunkCoordinates && world != null && world.func_147438_o(((ChunkCoordinates)object).field_71574_a, ((ChunkCoordinates)object).field_71572_b, ((ChunkCoordinates)object).field_71573_c) instanceof IImmersiveConnectable) {
            return (IImmersiveConnectable)world.func_147438_o(((ChunkCoordinates)object).field_71574_a, ((ChunkCoordinates)object).field_71572_b, ((ChunkCoordinates)object).field_71573_c);
        }
        return null;
    }

    public static String formatDouble(double d, String s) {
        DecimalFormat df = new DecimalFormat(s);
        return df.format(d);
    }

    public static String toCamelCase(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String getHarvestLevelName(int lvl) {
        if (Loader.isModLoaded((String)"TConstruct")) {
            try {
                Class<?> clazz;
                if (m_getHarvestLevel == null && (clazz = Class.forName("tconstruct.library.util")) != null) {
                    m_getHarvestLevel = clazz.getDeclaredMethod("getHarvestLevelName", Integer.TYPE);
                }
                if (m_getHarvestLevel != null) {
                    return (String)m_getHarvestLevel.invoke(null, lvl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return StatCollector.func_74838_a((String)("desc.ImmersiveEngineering.info.mininglvl." + Math.max(-1, Math.min(lvl, 6))));
    }

    public static boolean tilePositionMatch(TileEntity tile0, TileEntity tile1) {
        return tile0.field_145851_c == tile1.field_145851_c && tile0.field_145848_d == tile1.field_145848_d && tile0.field_145849_e == tile1.field_145849_e;
    }

    public static MovingObjectPosition getMovingObjectPositionFromPlayer(World world, EntityLivingBase living, boolean bool) {
        float f = 1.0f;
        float f1 = living.field_70127_C + (living.field_70125_A - living.field_70127_C) * f;
        float f2 = living.field_70126_B + (living.field_70177_z - living.field_70126_B) * f;
        double d0 = living.field_70169_q + (living.field_70165_t - living.field_70169_q) * (double)f;
        double d1 = living.field_70167_r + (living.field_70163_u - living.field_70167_r) * (double)f + (double)(world.field_72995_K ? living.func_70047_e() - (living instanceof EntityPlayer ? ((EntityPlayer)living).getDefaultEyeHeight() : 0.0f) : living.func_70047_e());
        double d2 = living.field_70166_s + (living.field_70161_v - living.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 5.0;
        if (living instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)living).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, bool, !bool, false);
    }

    public static boolean canBlocksSeeOther(World world, ChunkCoordinates cc0, ChunkCoordinates cc1, Vec3 pos0, Vec3 pos1) {
        MovingObjectPosition mop = world.func_72933_a(pos0, pos1);
        return mop == null || mop.field_72311_b == cc0.field_71574_a && mop.field_72312_c == cc0.field_71572_b && mop.field_72309_d == cc0.field_71573_c || mop.field_72311_b == cc1.field_71574_a && mop.field_72312_c == cc1.field_71572_b && mop.field_72309_d == cc1.field_71573_c;
    }

    public static boolean isHammer(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b().getToolClasses(stack).contains("IE_HAMMER");
    }

    public static Vec3 getFlowVector(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) instanceof BlockFluidBase) {
            return ((BlockFluidBase)world.func_147439_a(x, y, z)).getFlowVector((IBlockAccess)world, x, y, z);
        }
        if (!(world.func_147439_a(x, y, z) instanceof BlockLiquid)) {
            return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        }
        BlockLiquid block = (BlockLiquid)world.func_147439_a(x, y, z);
        Vec3 vec3 = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        Material mat = block.func_149688_o();
        int l = Utils.getEffectiveFlowDecay((IBlockAccess)world, x, y, z, mat);
        for (int i1 = 0; i1 < 4; ++i1) {
            int i2;
            int l1;
            int j1 = x;
            int k1 = z;
            if (i1 == 0) {
                j1 = x - 1;
            }
            if (i1 == 1) {
                k1 = z - 1;
            }
            if (i1 == 2) {
                ++j1;
            }
            if (i1 == 3) {
                ++k1;
            }
            if ((l1 = Utils.getEffectiveFlowDecay((IBlockAccess)world, j1, y, k1, mat)) < 0) {
                if (world.func_147439_a(j1, y, k1).func_149688_o().func_76230_c() || (l1 = Utils.getEffectiveFlowDecay((IBlockAccess)world, j1, y - 1, k1, mat)) < 0) continue;
                i2 = l1 - (l - 8);
                vec3 = vec3.func_72441_c((double)((j1 - x) * i2), (double)((y - y) * i2), (double)((k1 - z) * i2));
                continue;
            }
            if (l1 < 0) continue;
            i2 = l1 - l;
            vec3 = vec3.func_72441_c((double)((j1 - x) * i2), (double)((y - y) * i2), (double)((k1 - z) * i2));
        }
        if (world.func_72805_g(x, y, z) >= 8) {
            boolean flag = false;
            if (flag || block.func_149747_d((IBlockAccess)world, x, y, z - 1, 2)) {
                flag = true;
            }
            if (flag || block.func_149747_d((IBlockAccess)world, x, y, z + 1, 3)) {
                flag = true;
            }
            if (flag || block.func_149747_d((IBlockAccess)world, x - 1, y, z, 4)) {
                flag = true;
            }
            if (flag || block.func_149747_d((IBlockAccess)world, x + 1, y, z, 5)) {
                flag = true;
            }
            if (flag || block.func_149747_d((IBlockAccess)world, x, y + 1, z - 1, 2)) {
                flag = true;
            }
            if (flag || block.func_149747_d((IBlockAccess)world, x, y + 1, z + 1, 3)) {
                flag = true;
            }
            if (flag || block.func_149747_d((IBlockAccess)world, x - 1, y + 1, z, 4)) {
                flag = true;
            }
            if (flag || block.func_149747_d((IBlockAccess)world, x + 1, y + 1, z, 5)) {
                flag = true;
            }
            if (flag) {
                vec3 = vec3.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
            }
        }
        vec3 = vec3.func_72432_b();
        return vec3;
    }

    static int getEffectiveFlowDecay(IBlockAccess world, int x, int y, int z, Material mat) {
        if (world.func_147439_a(x, y, z).func_149688_o() != mat) {
            return -1;
        }
        int l = world.func_72805_g(x, y, z);
        if (l >= 8) {
            l = 0;
        }
        return l;
    }

    public static Vec3 addVectors(Vec3 vec0, Vec3 vec1) {
        return vec0.func_72441_c(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c);
    }

    public static Collection<ItemStack> getContainersFilledWith(FluidStack fluidStack) {
        ArrayList<ItemStack> containers = new ArrayList<ItemStack>();
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!data.fluid.containsFluid(fluidStack)) continue;
            containers.add(data.filledContainer);
        }
        return containers;
    }

    public static String nameFromStack(ItemStack stack) {
        if (stack == null) {
            return "";
        }
        try {
            return GameData.getItemRegistry().func_148750_c((Object)stack.func_77973_b());
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public static ItemStack insertStackIntoInventory(IInventory inventory, ItemStack stack, int side) {
        if (stack == null || inventory == null) {
            return null;
        }
        int stackSize = stack.field_77994_a;
        if (inventory instanceof ISidedInventory) {
            int i;
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int[] slots = sidedInv.func_94128_d(side);
            if (slots == null) {
                return stack;
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                ItemStack existingStack;
                if (!sidedInv.func_102007_a(slots[i], stack, side) || !OreDictionary.itemMatches((ItemStack)(existingStack = inventory.func_70301_a(slots[i])), (ItemStack)stack, (boolean)true) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack)) continue;
                stack = Utils.addToOccupiedSlot((IInventory)sidedInv, slots[i], stack, existingStack);
            }
            for (i = 0; i < slots.length && stack != null; ++i) {
                if (inventory.func_70301_a(slots[i]) != null || !sidedInv.func_102007_a(slots[i], stack, side)) continue;
                stack = Utils.addToEmptyInventorySlot((IInventory)sidedInv, slots[i], stack);
            }
        } else {
            int i;
            int invSize = inventory.func_70302_i_();
            for (i = 0; i < invSize && stack != null; ++i) {
                ItemStack existingStack = inventory.func_70301_a(i);
                if (!OreDictionary.itemMatches((ItemStack)existingStack, (ItemStack)stack, (boolean)true) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack)) continue;
                stack = Utils.addToOccupiedSlot(inventory, i, stack, existingStack);
            }
            for (i = 0; i < invSize && stack != null; ++i) {
                if (inventory.func_70301_a(i) != null) continue;
                stack = Utils.addToEmptyInventorySlot(inventory, i, stack);
            }
        }
        if (stack == null || stack.field_77994_a != stackSize) {
            inventory.func_70296_d();
        }
        return stack;
    }

    public static ItemStack addToEmptyInventorySlot(IInventory inventory, int slot, ItemStack stack) {
        if (!inventory.func_94041_b(slot, stack)) {
            return stack;
        }
        int stackLimit = inventory.func_70297_j_();
        inventory.func_70299_a(slot, Utils.copyStackWithAmount(stack, Math.min(stack.field_77994_a, stackLimit)));
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    public static ItemStack addToOccupiedSlot(IInventory inventory, int slot, ItemStack stack, ItemStack existingStack) {
        int stackLimit = Math.min(inventory.func_70297_j_(), stack.func_77976_d());
        if (stack.field_77994_a + existingStack.field_77994_a > stackLimit) {
            int stackDiff = stackLimit - existingStack.field_77994_a;
            existingStack.field_77994_a = stackLimit;
            stack.field_77994_a -= stackDiff;
            inventory.func_70299_a(slot, existingStack);
            return stack;
        }
        existingStack.field_77994_a += Math.min(stack.field_77994_a, stackLimit);
        inventory.func_70299_a(slot, existingStack);
        return stackLimit >= stack.field_77994_a ? null : stack.func_77979_a(stack.field_77994_a - stackLimit);
    }

    public static boolean canInsertStackIntoInventory(IInventory inventory, ItemStack stack, int side) {
        if (stack == null || inventory == null) {
            return false;
        }
        if (inventory instanceof ISidedInventory) {
            ISidedInventory sidedInv = (ISidedInventory)inventory;
            int[] slots = sidedInv.func_94128_d(side);
            if (slots == null) {
                return false;
            }
            for (int i = 0; i < slots.length && stack != null; ++i) {
                if (!sidedInv.func_102007_a(slots[i], stack, side) || !sidedInv.func_94041_b(slots[i], stack)) continue;
                ItemStack existingStack = inventory.func_70301_a(slots[i]);
                if (existingStack == null) {
                    return true;
                }
                if (!OreDictionary.itemMatches((ItemStack)existingStack, (ItemStack)stack, (boolean)true) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack) || existingStack.field_77994_a + stack.field_77994_a >= inventory.func_70297_j_() || existingStack.field_77994_a + stack.field_77994_a >= existingStack.func_77976_d()) continue;
                return true;
            }
        } else {
            int invSize = inventory.func_70302_i_();
            for (int i = 0; i < invSize && stack != null; ++i) {
                if (!inventory.func_94041_b(i, stack)) continue;
                ItemStack existingStack = inventory.func_70301_a(i);
                if (existingStack == null) {
                    return true;
                }
                if (!OreDictionary.itemMatches((ItemStack)existingStack, (ItemStack)stack, (boolean)true) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack) || existingStack.field_77994_a + stack.field_77994_a >= inventory.func_70297_j_() || existingStack.field_77994_a + stack.field_77994_a >= existingStack.func_77976_d()) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack fillFluidContainer(FluidTank tank, ItemStack containerIn, ItemStack containerOut) {
        if (tank.getFluidAmount() > 0 && containerIn != null) {
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)containerIn)) {
                ItemStack filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)tank.getFluid(), (ItemStack)containerIn);
                if (filledContainer != null) {
                    FluidStack fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledContainer);
                    if (fs.amount <= tank.getFluidAmount() && (containerOut == null || OreDictionary.itemMatches((ItemStack)containerOut, (ItemStack)filledContainer, (boolean)true))) {
                        tank.drain(fs.amount, true);
                        return filledContainer;
                    }
                }
            } else if (containerIn.func_77973_b() instanceof IFluidContainerItem) {
                int space;
                IFluidContainerItem iContainer = (IFluidContainerItem)containerIn.func_77973_b();
                int available = tank.getFluidAmount();
                if (available >= (space = iContainer.getCapacity(containerIn) - (iContainer.getFluid(containerIn) == null ? 0 : iContainer.getFluid((ItemStack)containerIn).amount)) && iContainer.fill(containerIn, tank.getFluid(), false) == space) {
                    ItemStack filledContainer = Utils.copyStackWithAmount(containerIn, 1);
                    int filled = iContainer.fill(filledContainer, tank.getFluid(), true);
                    if (containerOut == null || OreDictionary.itemMatches((ItemStack)containerOut, (ItemStack)filledContainer, (boolean)true) && ItemStack.func_77970_a((ItemStack)filledContainer, (ItemStack)containerOut)) {
                        tank.drain(filled, true);
                        return filledContainer;
                    }
                } else {
                    int filled = iContainer.fill(containerIn, tank.getFluid(), true);
                    tank.drain(filled, true);
                }
            }
        }
        return null;
    }

    public static ItemStack drainFluidContainer(FluidTank tank, ItemStack containerIn, ItemStack containerOut) {
        ItemStack emptyContainer;
        FluidStack fs;
        if (containerIn != null && FluidContainerRegistry.isFilledContainer((ItemStack)containerIn) && (fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)containerIn)) != null && tank.getFluidAmount() + fs.amount <= tank.getCapacity() && (emptyContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)containerIn)) != null && tank.fill(fs, true) == fs.amount) {
            return emptyContainer;
        }
        return null;
    }
}

