/*
 * Decompiled with CFR 0.152.
 */
package yuuto.enhancedinventories.client;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import yuuto.enhancedinventories.EnhancedInventories;
import yuuto.enhancedinventories.WoodTypes;
import yuuto.enhancedinventories.client.models.ModelLockerDouble;
import yuuto.enhancedinventories.client.models.ModelLockerSingle;
import yuuto.enhancedinventories.tile.TileLocker;

public class RendererLocker
extends TileEntitySpecialRenderer {
    static ModelLockerDouble doubleLockerRenderer = new ModelLockerDouble();
    static ModelLockerSingle singleLockerRenderer = new ModelLockerSingle();
    static ResourceLocation singleChestFrame = new ResourceLocation("enhancedinventories", "textures/uvs/normalLockerFrame.png");
    static ResourceLocation doubleChestFrame = new ResourceLocation("enhancedinventories", "textures/uvs/doubleLockerFrame.png");
    static ResourceLocation doubleRefinedLocation;
    static ResourceLocation singleRefinedLocation;

    public RendererLocker() {
        if (EnhancedInventories.refinedRelocation) {
            singleRefinedLocation = new ResourceLocation("enhancedinventories", "textures/uvs/refinedRelocation/normalLocker.png");
            doubleRefinedLocation = new ResourceLocation("enhancedinventories", "textures/uvs/refinedRelocation/doubleLocker.png");
        }
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float f) {
        if (!(tile instanceof TileLocker)) {
            return;
        }
        TileLocker locker = (TileLocker)tile;
        if (locker.getPartner() != null) {
            this.renderDouble((TileLocker)tile, x, y, z, f, 0);
            this.renderDouble((TileLocker)tile, x, y, z, f, 1);
            if (((TileLocker)tile).sortingChest) {
                this.renderDouble((TileLocker)tile, x, y, z, f, 2);
            }
        } else if (!locker.getTopSides().contains(locker.getPartnerDir())) {
            this.renderSingle((TileLocker)tile, x, y, z, f, 0);
            this.renderSingle((TileLocker)tile, x, y, z, f, 1);
            if (((TileLocker)tile).sortingChest) {
                this.renderSingle((TileLocker)tile, x, y, z, f, 2);
            }
        }
    }

    void renderSingle(TileLocker chest, double x, double y, double z, float f, int pass) {
        int i = chest.getOrientation().ordinal();
        int short1 = 0;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.502));
        switch (pass) {
            case 0: {
                this.func_147499_a(WoodTypes.getWoodType(chest.woodType).getTexture(0));
                break;
            }
            case 1: {
                if (chest.getType().hasTexture()) {
                    this.func_147499_a(chest.getType().getTexture(2));
                    break;
                }
                this.func_147499_a(singleChestFrame);
                GL11.glColor4f((float)chest.getType().r(), (float)chest.getType().g(), (float)chest.getType().b(), (float)1.0f);
                break;
            }
            case 2: {
                this.func_147499_a(singleRefinedLocation);
                break;
            }
        }
        if (i == 2) {
            short1 = 90;
        }
        if (i == 3) {
            short1 = -90;
        }
        if (i == 4) {
            short1 = 180;
        }
        if (i == 5) {
            short1 = 0;
        }
        GL11.glRotatef((float)short1, (float)0.0f, (float)1.0f, (float)0.0f);
        float f1 = chest.prevLidAngle + (chest.lidAngle - chest.prevLidAngle) * f;
        f1 = 1.0f - f1;
        f1 = 1.0f - f1 * f1 * f1;
        singleLockerRenderer.setRotation(-(f1 * (float)Math.PI / 2.0f) * 57.295776f);
        if (chest.reversed) {
            singleLockerRenderer.renderAllReversed();
        } else {
            singleLockerRenderer.renderAll();
        }
        GL11.glPopMatrix();
    }

    void renderDouble(TileLocker chest, double x, double y, double z, float f, int pass) {
        int i = chest.getOrientation().ordinal();
        int short1 = 0;
        GL11.glPushMatrix();
        switch (pass) {
            case 0: {
                this.func_147499_a(WoodTypes.getWoodType(chest.woodType).getTexture(0));
                break;
            }
            case 1: {
                if (chest.getType().hasTexture()) {
                    this.func_147499_a(chest.getType().getTexture(3));
                    break;
                }
                this.func_147499_a(doubleChestFrame);
                GL11.glColor4f((float)chest.getType().r(), (float)chest.getType().g(), (float)chest.getType().b(), (float)1.0f);
                break;
            }
            case 2: {
                this.func_147499_a(doubleRefinedLocation);
                break;
            }
        }
        GL11.glEnable((int)32826);
        if (chest.getPartnerDir() == ForgeDirection.UP) {
            GL11.glTranslated((double)(x + 0.49375), (double)(y + 1.0), (double)(z + 0.50825));
        }
        if (chest.getPartnerDir() == ForgeDirection.DOWN) {
            GL11.glTranslated((double)(x + 0.49375), (double)(y - 0.0), (double)(z + 0.50825));
        }
        if (i == 2) {
            short1 = 90;
        }
        if (i == 3) {
            short1 = -90;
        }
        if (i == 4) {
            short1 = 180;
        }
        if (i == 5) {
            short1 = 0;
        }
        GL11.glRotatef((float)short1, (float)0.0f, (float)1.0f, (float)0.0f);
        float f1 = chest.prevLidAngle + (chest.lidAngle - chest.prevLidAngle) * f;
        f1 = 1.0f - f1;
        f1 = 1.0f - f1 * f1 * f1;
        doubleLockerRenderer.setRotation(-(f1 * (float)Math.PI / 2.0f) * 57.295776f);
        if (chest.reversed) {
            doubleLockerRenderer.renderAllReversed();
        } else {
            doubleLockerRenderer.renderAll();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
    }
}

