/*
 * Decompiled with CFR 0.152.
 */
package yuuto.enhancedinventories.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import yuuto.enhancedinventories.ColorHelper;
import yuuto.enhancedinventories.EInventoryMaterial;
import yuuto.enhancedinventories.EnhancedInventories;
import yuuto.enhancedinventories.WoodTypes;
import yuuto.enhancedinventories.compat.modules.VanillaModule;
import yuuto.enhancedinventories.tile.TileImprovedChest;
import yuuto.yuutolib.item.ModItemMulti;

public class ItemChestConverter
extends ModItemMulti {
    public ItemChestConverter() {
        super(EnhancedInventories.tab, "EnhancedInventories", "chestConverter", ".Stone", ".Iron", ".Gold", ".Diamond", ".Emerald", ".Obsidian", ".Copper", ".Tin", ".Silver", ".Bronze", ".Steel", ".Platinum", ".Alumite", ".Cobalt", ".Ardite", ".Manyullyn");
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List results, boolean bool) {
        super.func_77624_a(stack, player, results, bool);
        if (stack.func_77942_o()) {
            results.add(I18n.func_135052_a((String)ColorHelper.WOOL_NAMES[stack.func_77978_p().func_74762_e("wool")], (Object[])new Object[0]));
            WoodTypes.getWoodType(stack.func_77978_p().func_74779_i("woodType")).addInformation(stack, player, results, bool);
            if (stack.func_77978_p().func_74767_n("hopper")) {
                results.add(I18n.func_135052_a((String)"upgrade.hopper", (Object[])new Object[0]));
            }
            if (stack.func_77978_p().func_74767_n("redstone")) {
                results.add(I18n.func_135052_a((String)"upgrade.redstone", (Object[])new Object[0]));
            }
            if (stack.func_77978_p().func_74767_n("alt")) {
                results.add(I18n.func_135052_a((String)"upgrade.alt", (Object[])new Object[0]));
            }
            if (stack.func_77978_p().func_74762_e("wool") == 6 && this.isPinkWood(stack)) {
                results.add(I18n.func_135052_a((String)"easterEgg.pink", (Object[])new Object[0]));
            }
        } else {
            results.add(I18n.func_135052_a((String)ColorHelper.WOOL_NAMES[0], (Object[])new Object[0]));
            VanillaModule.OAK.addInformation(stack, player, results, bool);
        }
    }

    public boolean isPinkWood(ItemStack stack) {
        return stack.func_77978_p().func_74779_i("woodType").matches("wood:Natura:planks:0");
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int X, int Y, int Z, int side, float hitX, float hitY, float hitZ) {
        System.out.println("item use");
        if (world.field_72995_K || !player.func_70093_af()) {
            System.out.println("Client");
            return false;
        }
        if (!stack.func_77942_o()) {
            return false;
        }
        System.out.println("Server");
        TileEntity tile = world.func_147438_o(X, Y, Z);
        if (!(tile instanceof TileEntityChest)) {
            return false;
        }
        System.out.println("passed check");
        TileEntityChest oldTile = (TileEntityChest)tile;
        TileImprovedChest newTile = new TileImprovedChest(EInventoryMaterial.values()[stack.func_77960_j()]);
        newTile.woodType = stack.func_77978_p().func_74779_i("woodType");
        newTile.woolType = stack.func_77978_p().func_74762_e("wool");
        newTile.hopper = stack.func_77978_p().func_74767_n("hopper");
        newTile.alt = stack.func_77978_p().func_74767_n("alt");
        newTile.redstone = stack.func_77978_p().func_74767_n("redstone");
        if (!ItemChestConverter.canUpgrade(newTile, world, X, Y, Z)) {
            return false;
        }
        ItemStack[] stacks = new ItemStack[oldTile.func_70302_i_()];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = oldTile.func_70301_a(i);
            oldTile.func_70299_a(i, null);
        }
        newTile.setContents(stacks, false);
        newTile.setOrientation(ForgeDirection.getOrientation((int)world.func_72805_g(X, Y, Z)));
        boolean trapped = world.func_147439_a(X, Y, Z).func_149744_f();
        world.func_147468_f(X, Y, Z);
        world.func_147465_d(X, Y, Z, (Block)EnhancedInventories.improvedChest, 0, 3);
        world.func_147455_a(X, Y, Z, (TileEntity)newTile);
        world.func_72921_c(X, Y, Z, stack.func_77960_j(), 3);
        newTile.checkConnections();
        newTile.markDirty(true);
        if (!player.field_71075_bZ.field_75098_d && stack.field_77994_a > 0) {
            --stack.field_77994_a;
            if (trapped) {
                player.field_71071_by.func_70441_a(new ItemStack(Blocks.field_150447_bR));
            } else {
                player.field_71071_by.func_70441_a(new ItemStack((Block)Blocks.field_150486_ae));
            }
            player.field_71069_bz.func_75142_b();
        }
        return true;
    }

    public static boolean canUpgrade(TileImprovedChest newTile, World world, int x, int y, int z) {
        List<ForgeDirection> dirs = newTile.getValidConnectionSides();
        int chests = 0;
        for (ForgeDirection dir : dirs) {
            TileImprovedChest inv;
            TileEntity tile = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if (tile == null || !(tile instanceof TileImprovedChest) || !(inv = (TileImprovedChest)tile).isValidForConnection(newTile)) continue;
            if (inv.getPartner() != null) {
                return false;
            }
            ++chests;
        }
        return chests <= true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List subItems) {
        Random rand = new Random();
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("woodType", WoodTypes.getWoodTypes().get(rand.nextInt(WoodTypes.getWoodTypes().size())).id());
        nbt.func_74774_a("wool", (byte)rand.nextInt(16));
        for (int ix = 0; ix < this.subNames.length; ++ix) {
            ItemStack stack = new ItemStack((Item)this, 1, ix);
            stack.func_77982_d((NBTTagCompound)nbt.func_74737_b());
            subItems.add(stack);
        }
    }
}

