/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.reactor;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.common.Mekanism;
import mekanism.common.util.LangUtils;
import mekanism.generators.common.tile.reactor.TileEntityReactorBlock;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")
public class TileEntityReactorLogicAdapter
extends TileEntityReactorBlock
implements IPeripheral {
    public ReactorLogic logicType = ReactorLogic.DISABLED;
    public boolean activeCooled;
    public boolean prevOutputting;

    public TileEntityReactorLogicAdapter() {
        this.fullName = "ReactorLogicAdapter";
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            boolean outputting = this.checkMode();
            if (outputting != this.prevOutputting) {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            }
            this.prevOutputting = outputting;
        }
    }

    public boolean isFrame() {
        return false;
    }

    public boolean checkMode() {
        if (this.field_145850_b.field_72995_K) {
            return this.prevOutputting;
        }
        if (this.getReactor() == null || !this.getReactor().isFormed()) {
            return false;
        }
        switch (this.logicType) {
            case DISABLED: {
                return false;
            }
            case READY: {
                return this.getReactor().getPlasmaTemp() >= this.getReactor().getIgnitionTemperature(this.activeCooled);
            }
            case CAPACITY: {
                return this.getReactor().getPlasmaTemp() >= this.getReactor().getMaxPlasmaTemperature(this.activeCooled);
            }
            case DEPLETED: {
                return this.getReactor().getDeuteriumTank().getStored() < this.getReactor().getInjectionRate() / 2 || this.getReactor().getTritiumTank().getStored() < this.getReactor().getInjectionRate() / 2;
            }
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.logicType = ReactorLogic.values()[nbtTags.func_74762_e("logicType")];
        this.activeCooled = nbtTags.func_74767_n("activeCooled");
    }

    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74768_a("logicType", this.logicType.ordinal());
        nbtTags.func_74757_a("activeCooled", this.activeCooled);
    }

    public void handlePacketData(ByteBuf dataStream) {
        if (!this.field_145850_b.field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.activeCooled = !this.activeCooled;
            } else if (type == 1) {
                this.logicType = ReactorLogic.values()[dataStream.readInt()];
            }
            return;
        }
        super.handlePacketData(dataStream);
        this.logicType = ReactorLogic.values()[dataStream.readInt()];
        this.activeCooled = dataStream.readBoolean();
        this.prevOutputting = dataStream.readBoolean();
    }

    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.logicType.ordinal());
        data.add(this.activeCooled);
        data.add(this.prevOutputting);
        return data;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return this.func_145825_b();
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return this == other;
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"isIgnited", "canIgnite", "getPlasmaHeat", "getMaxPlasmaHeat", "getCaseHeat", "getMaxCaseHeat", "getInjectionRate", "setInjectionRate", "hasFuel"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (this.getReactor() == null || !this.getReactor().isFormed()) {
            return new Object[]{"Unformed."};
        }
        switch (method) {
            case 0: {
                return new Object[]{this.getReactor().isBurning()};
            }
            case 1: {
                return new Object[]{this.getReactor().getPlasmaTemp() >= this.getReactor().getIgnitionTemperature(this.activeCooled)};
            }
            case 2: {
                return new Object[]{this.getReactor().getPlasmaTemp()};
            }
            case 3: {
                return new Object[]{this.getReactor().getMaxPlasmaTemperature(this.activeCooled)};
            }
            case 4: {
                return new Object[]{this.getReactor().getCaseTemp()};
            }
            case 5: {
                return new Object[]{this.getReactor().getMaxCasingTemperature(this.activeCooled)};
            }
            case 6: {
                return new Object[]{this.getReactor().getInjectionRate()};
            }
            case 7: {
                if (arguments[0] instanceof Integer) {
                    this.getReactor().setInjectionRate(((Integer)arguments[0]).intValue());
                    return new Object[]{"Injection rate set."};
                }
                return new Object[]{"Invalid parameters."};
            }
            case 8: {
                return new Object[]{this.getReactor().getDeuteriumTank().getStored() >= this.getReactor().getInjectionRate() / 2 && this.getReactor().getTritiumTank().getStored() >= this.getReactor().getInjectionRate() / 2};
            }
        }
        Mekanism.logger.error("Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }

    public static enum ReactorLogic {
        DISABLED("disabled", new ItemStack(Items.field_151016_H)),
        READY("ready", new ItemStack(Items.field_151137_ax)),
        CAPACITY("capacity", new ItemStack(Items.field_151137_ax)),
        DEPLETED("depleted", new ItemStack(Items.field_151137_ax));

        private String name;
        private ItemStack renderStack;

        private ReactorLogic(String s, ItemStack stack) {
            this.name = s;
            this.renderStack = stack;
        }

        public ItemStack getRenderStack() {
            return this.renderStack;
        }

        public String getLocalizedName() {
            return LangUtils.localize((String)("reactor." + this.name));
        }

        public String getDescription() {
            return LangUtils.localize((String)("reactor." + this.name + ".desc"));
        }
    }
}

