/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.api;

import glenn.gasesframework.api.Combustibility;
import glenn.gasesframework.api.ExtendedGasEffectsBase;
import glenn.gasesframework.api.IGasesFramework;
import glenn.gasesframework.api.ItemKey;
import glenn.gasesframework.api.gastype.GasType;
import glenn.gasesframework.api.gastype.GasTypeAir;
import glenn.gasesframework.api.gastype.GasTypeFire;
import glenn.gasesframework.api.gasworldgentype.GasWorldGenType;
import glenn.gasesframework.api.lanterntype.LanternType;
import glenn.gasesframework.api.mechanical.IGasTransposerHandler;
import glenn.gasesframework.api.reaction.Reaction;
import glenn.gasesframework.api.reaction.ReactionEmpty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class GasesFrameworkAPI {
    public static final String OWNER = "gasesFramework";
    public static final String VERSION = "1.1.2";
    public static final String TARGETVERSION = "1.7.10";
    public static final String PROVIDES = "gasesFrameworkAPI";
    private static HashSet<Block> gasReactiveBlocks = new HashSet();
    private static HashSet<Item> gasReactiveItems = new HashSet();
    private static ArrayList<Reaction> reactions = new ArrayList();
    public static IGasesFramework modInstance;
    public static final ResourceLocation gasOverlayImage;
    public static final ResourceLocation fireOverlayImage;
    public static final ResourceLocation emptyOverlayImage;
    public static final GasType gasTypeAir;
    public static final GasType gasTypeSmoke;
    public static final GasType gasTypeFire;
    public static final LanternType lanternTypeEmpty;
    public static final LanternType lanternTypeGasEmpty;
    public static final LanternType[] lanternTypesGas;
    public static Item gasBottle;
    public static Item gasSamplerIncluder;
    public static Item gasSamplerExcluder;
    public static final DamageSource asphyxiationDamageSource;
    public static CreativeTabs creativeTab;

    public static boolean isModInstalled() {
        return modInstance != null;
    }

    public static void registerIgnitionBlock(Block block) {
        gasReactiveBlocks.add(block);
    }

    public static void unregisterIgnitionBlock(Block block) {
        gasReactiveBlocks.remove(block);
    }

    public static boolean isIgnitionBlock(Block block) {
        return gasReactiveBlocks.contains(block);
    }

    public static void registerIgnitionItem(Item item) {
        gasReactiveItems.add(item);
    }

    public static void unregisterIgnitionItem(Item item) {
        gasReactiveItems.remove(item);
    }

    public static boolean isIgnitionItem(Item item) {
        return gasReactiveItems.contains(item);
    }

    public static void registerReaction(Reaction reaction) {
        if (!reaction.isErroneous()) {
            reactions.add(reaction);
        }
    }

    public static Reaction getReactionForBlocks(World world, Block block1, int block1X, int block1Y, int block1Z, Block block2, int block2X, int block2Y, int block2Z) {
        for (Reaction reaction : reactions) {
            if (!reaction.is(world, block1, block1X, block1Y, block1Z, block2, block2X, block2Y, block2Z)) continue;
            return reaction;
        }
        return new ReactionEmpty();
    }

    public static void addSpecialFurnaceRecipe(ItemStack ingredient, ItemStack result, int cookTime, int exp) {
        if (GasesFrameworkAPI.isModInstalled()) {
            modInstance.addSpecialFurnaceRecipe(ingredient, result, cookTime, exp);
        }
    }

    public static boolean canFillWithGas(World world, int x, int y, int z, GasType type) {
        return modInstance.canFillWithGas(world, x, y, z, type);
    }

    public static boolean fillWithGas(World world, Random random, int x, int y, int z, GasType type) {
        return modInstance.fillWithGas(world, random, x, y, z, type);
    }

    public static void placeGas(World world, int x, int y, int z, GasType type, int volume) {
        modInstance.placeGas(world, x, y, z, type, volume);
    }

    public static void ignite(World world, int x, int y, int z, Random random) {
        modInstance.ignite(world, x, y, z, random);
    }

    public static GasType getGasType(World world, int x, int y, int z) {
        return modInstance.getGasType(world, x, y, z);
    }

    public static GasType getGasPipeType(World world, int x, int y, int z) {
        return modInstance.getGasPipeType(world, x, y, z);
    }

    public static int getGasVolume(World world, int x, int y, int z) {
        return modInstance.getGasVolume(world, x, y, z);
    }

    public static float getGasExplosionPowerFactor() {
        return modInstance.getGasExplosionPowerFactor();
    }

    public static int getFireSmokeAmount() {
        return modInstance.getFireSmokeAmount();
    }

    public static Block registerGasType(GasType type) {
        if (GasesFrameworkAPI.isModInstalled()) {
            return modInstance.registerGasType(type);
        }
        return null;
    }

    public static Block registerGasType(GasType type, CreativeTabs creativeTab) {
        if (GasesFrameworkAPI.isModInstalled()) {
            return modInstance.registerGasType(type, creativeTab);
        }
        return null;
    }

    public static Block registerLanternType(LanternType type) {
        if (GasesFrameworkAPI.isModInstalled()) {
            return modInstance.registerLanternType(type);
        }
        return null;
    }

    public static Block registerLanternType(LanternType type, CreativeTabs creativeTab) {
        if (GasesFrameworkAPI.isModInstalled()) {
            return modInstance.registerLanternType(type, creativeTab);
        }
        return null;
    }

    public static void registerGasWorldGenType(GasWorldGenType type, String ... dimensionNames) {
        if (GasesFrameworkAPI.isModInstalled()) {
            modInstance.registerGasWorldGenType(type, dimensionNames);
        }
    }

    public static void registerGasTransposerHandler(IGasTransposerHandler handler) {
        if (GasesFrameworkAPI.isModInstalled()) {
            modInstance.registerGasTransposerHandler(handler);
        }
    }

    static {
        gasOverlayImage = new ResourceLocation("gasesframework:textures/misc/gas_overlay.png");
        fireOverlayImage = new ResourceLocation("gasesframework:textures/misc/fire_overlay.png");
        emptyOverlayImage = new ResourceLocation("gasesframework:textures/misc/empty_overlay.png");
        gasTypeAir = new GasTypeAir();
        gasTypeSmoke = new GasType(true, 1, "smoke", 0x3F3F3F9F, 2, -16, Combustibility.NONE).setEffectRate(ExtendedGasEffectsBase.EffectType.BLINDNESS, 4).setEffectRate(ExtendedGasEffectsBase.EffectType.SUFFOCATION, 4).setEffectRate(ExtendedGasEffectsBase.EffectType.SLOWNESS, 16);
        gasTypeFire = new GasTypeFire();
        lanternTypeEmpty = new LanternType("empty", 0.0f, "gasesframework:lantern_empty", new ItemKey(), null, 0).setInOut();
        lanternTypeGasEmpty = new LanternType("gas_empty", 0.0f, "gasesframework:lantern_gas_empty", new ItemKey(Items.field_151069_bo), lanternTypeEmpty, 0).setInOut();
        lanternTypesGas = new LanternType[]{lanternTypeGasEmpty, new LanternType("gas_1", 1.0f, "gasesframework:lantern_gas_1", new ItemKey(Items.field_151069_bo), lanternTypeGasEmpty, 1), new LanternType("gas_2", 1.0f, "gasesframework:lantern_gas_2", new ItemKey(Items.field_151069_bo), lanternTypeGasEmpty, 2), new LanternType("gas_3", 1.0f, "gasesframework:lantern_gas_3", new ItemKey(Items.field_151069_bo), lanternTypeGasEmpty, 3), new LanternType("gas_4", 1.0f, "gasesframework:lantern_gas_4", new ItemKey(Items.field_151069_bo), lanternTypeGasEmpty, 4), new LanternType("gas_5", 1.0f, "gasesframework:lantern_gas_5", new ItemKey(Items.field_151069_bo), lanternTypeGasEmpty, 5)};
        asphyxiationDamageSource = new DamageSource("gf_asphyxiation");
    }
}

