/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.api;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemKey {
    public final Item item;
    public final int damage;

    public ItemKey() {
        this(null, 0);
    }

    public ItemKey(Item item) {
        this(item, 0);
    }

    public ItemKey(Item item, int damage) {
        this.item = item;
        this.damage = damage;
    }

    public ItemKey(ItemStack itemStack) {
        if (itemStack != null) {
            this.item = itemStack.func_77973_b();
            this.damage = itemStack.func_77960_j();
        } else {
            this.item = null;
            this.damage = 0;
        }
    }

    public ItemStack itemStack() {
        if (this.item != null) {
            return new ItemStack(this.item, 1, this.damage);
        }
        return null;
    }

    public int hashCode() {
        int itemHash = this.item != null ? this.item.hashCode() : 0;
        int damageHash = new Integer(this.damage).hashCode();
        return (itemHash + damageHash) * damageHash + itemHash;
    }

    public boolean equals(Object otherObject) {
        if (otherObject instanceof ItemKey) {
            ItemKey other = (ItemKey)otherObject;
            return this.item == other.item && this.damage == other.damage;
        }
        return false;
    }

    public String toString() {
        if (this.item != null) {
            return "(" + this.item.toString() + ":" + this.damage + ")";
        }
        return "(null:" + this.damage + ")";
    }
}

