/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.common;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.api.ExtendedGasEffectsBase;
import glenn.gasesframework.api.block.MaterialGas;
import glenn.gasesframework.api.gastype.GasType;
import glenn.gasesframework.api.item.IGasEffectProtector;
import glenn.gasesframework.common.block.BlockGas;
import glenn.gasesframework.network.message.MessageGasEffects;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendedGasEffects
extends ExtendedGasEffectsBase {
    private EnumMap<ExtendedGasEffectsBase.EffectType, Integer> prevValues = new EnumMap(ExtendedGasEffectsBase.EffectType.class);
    private EnumMap<ExtendedGasEffectsBase.EffectType, Integer> values = new EnumMap(ExtendedGasEffectsBase.EffectType.class);

    private ExtendedGasEffects(EntityLivingBase entity) {
        super(entity);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        for (Map.Entry<ExtendedGasEffectsBase.EffectType, Integer> entry : this.values.entrySet()) {
            properties.func_74768_a(entry.getKey().name(), entry.getValue().intValue());
        }
        compound.func_74782_a("ExtendedGasEffects", (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = compound.func_74775_l("ExtendedGasEffects");
        Set keys = properties.func_150296_c();
        for (String key : keys) {
            try {
                ExtendedGasEffectsBase.EffectType type = ExtendedGasEffectsBase.EffectType.valueOf(key);
                if (type == null) continue;
                this.set(type, properties.func_74762_e(key));
            }
            catch (IllegalArgumentException e) {}
        }
    }

    public void init(Entity entity, World world) {
    }

    private boolean protect(boolean[] appliedProtectors, IGasEffectProtector[] protectors, GasType gasType, ExtendedGasEffectsBase.EffectType effect) {
        boolean res = false;
        for (int slot = 0; slot < protectors.length; ++slot) {
            IGasEffectProtector protector = protectors[slot];
            if (protector == null || !protector.protect(this.entity, this.entity.func_71124_b(slot), slot, gasType, effect)) continue;
            res = true;
            appliedProtectors[slot] = true;
        }
        return res;
    }

    public void tick() {
        if (!this.entity.field_70170_p.field_72995_K) {
            boolean[] appliedProtectors = new boolean[5];
            IGasEffectProtector[] protectors = new IGasEffectProtector[5];
            for (int slot = 0; slot < 5; ++slot) {
                IGasEffectProtector protector;
                ItemStack itemstack = this.entity.func_71124_b(slot);
                if (itemstack == null || !(itemstack.func_77973_b() instanceof IGasEffectProtector)) continue;
                protectors[slot] = protector = (IGasEffectProtector)itemstack.func_77973_b();
            }
            GasType gasType = null;
            if (this.entity.func_70055_a(MaterialGas.INSTANCE)) {
                int z;
                int y;
                double dy = this.entity.field_70163_u + (double)this.entity.func_70047_e();
                int x = MathHelper.func_76128_c((double)this.entity.field_70165_t);
                Block block = this.entity.field_70170_p.func_147439_a(x, y = MathHelper.func_76128_c((double)dy), z = MathHelper.func_76128_c((double)this.entity.field_70161_v));
                if (block instanceof BlockGas) {
                    gasType = ((BlockGas)block).type;
                }
            }
            int blindnessTimer = this.get(ExtendedGasEffectsBase.EffectType.BLINDNESS);
            int suffocationTimer = this.get(ExtendedGasEffectsBase.EffectType.SUFFOCATION);
            int slownessTimer = this.get(ExtendedGasEffectsBase.EffectType.SLOWNESS);
            if (gasType != null && gasType.getEffectRate(ExtendedGasEffectsBase.EffectType.BLINDNESS) > 0 && !this.protect(appliedProtectors, protectors, gasType, ExtendedGasEffectsBase.EffectType.BLINDNESS)) {
                blindnessTimer += gasType.getEffectRate(ExtendedGasEffectsBase.EffectType.BLINDNESS) + 4;
            }
            blindnessTimer -= 4;
            if (gasType != null && gasType.getEffectRate(ExtendedGasEffectsBase.EffectType.SUFFOCATION) > 0 && !this.protect(appliedProtectors, protectors, gasType, ExtendedGasEffectsBase.EffectType.SUFFOCATION)) {
                if ((suffocationTimer += gasType.getEffectRate(ExtendedGasEffectsBase.EffectType.SUFFOCATION) + 32) > 350 && gasType.getEffectRate(ExtendedGasEffectsBase.EffectType.SLOWNESS) > 0 && !this.protect(appliedProtectors, protectors, gasType, ExtendedGasEffectsBase.EffectType.SLOWNESS)) {
                    slownessTimer += gasType.getEffectRate(ExtendedGasEffectsBase.EffectType.SLOWNESS) + 10;
                }
                if (suffocationTimer > 400) {
                    gasType.onBreathed(this.entity);
                    suffocationTimer -= 32;
                }
            }
            suffocationTimer -= 32;
            slownessTimer -= 10;
            if (blindnessTimer > 500) {
                blindnessTimer = 500;
            } else if (blindnessTimer < 0) {
                blindnessTimer = 0;
            }
            if (suffocationTimer < 0) {
                suffocationTimer = 0;
            }
            if (slownessTimer > 1000) {
                slownessTimer = 1000;
            } else if (slownessTimer < 0) {
                slownessTimer = 0;
            }
            this.set(ExtendedGasEffectsBase.EffectType.BLINDNESS, blindnessTimer);
            this.set(ExtendedGasEffectsBase.EffectType.SUFFOCATION, suffocationTimer);
            this.set(ExtendedGasEffectsBase.EffectType.SLOWNESS, slownessTimer);
            for (int slot = 0; slot < protectors.length; ++slot) {
                if (!appliedProtectors[slot]) continue;
                this.entity.func_70062_b(slot, protectors[slot].getItemstackOnProtect(this.entity, this.entity.func_71124_b(slot), slot, gasType));
            }
            if (this.hasChanged()) {
                GasesFramework.networkWrapper.sendToAllAround((IMessage)new MessageGasEffects(this.entity, (short)blindnessTimer, (short)suffocationTimer, (short)slownessTimer), new NetworkRegistry.TargetPoint(this.entity.field_70170_p.field_73011_w.field_76574_g, this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 50.0));
                this.prevValues = this.values.clone();
            }
        }
    }

    private boolean hasChanged() {
        if (this.values.size() != this.prevValues.size()) {
            return true;
        }
        for (Map.Entry<ExtendedGasEffectsBase.EffectType, Integer> entry : this.values.entrySet()) {
            Integer value = entry.getValue();
            Integer prevValue = this.prevValues.get((Object)entry.getKey());
            if (!(value != null && prevValue != null ? !value.equals(prevValue) : value != null || prevValue != null)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int get(ExtendedGasEffectsBase.EffectType effectType) {
        Integer res = this.values.get((Object)effectType);
        if (res != null) {
            return res;
        }
        return 0;
    }

    @Override
    public int set(ExtendedGasEffectsBase.EffectType effectType, int i) {
        this.values.put(effectType, i);
        return i;
    }

    @Override
    public int increment(ExtendedGasEffectsBase.EffectType effectType, int i) {
        return this.set(effectType, this.get(effectType) + i);
    }

    public static void register(EntityLivingBase entity) {
        entity.registerExtendedProperties("ExtendedGasEffects", (IExtendedEntityProperties)new ExtendedGasEffects(entity));
    }
}

