/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import glenn.gasesframework.api.GasesFrameworkAPI;
import glenn.gasesframework.api.block.IGasPropellor;
import glenn.gasesframework.api.block.IGasReceptor;
import glenn.gasesframework.api.block.ISample;
import glenn.gasesframework.api.gastype.GasType;
import glenn.gasesframework.client.render.RenderBlockGasPump;
import glenn.gasesframework.common.tileentity.TileEntityGasPump;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGasPump
extends Block
implements IGasReceptor,
IGasPropellor,
ITileEntityProvider,
ISample {
    private boolean isBottomUnique;
    public IIcon sideIcon;
    public IIcon bottomIcon;
    public IIcon topIcon;
    public IIcon topIncludingIcon;
    public IIcon topExcludingIcon;
    public IIcon topIndicatorIcon;

    public BlockGasPump(boolean isBottomUnique) {
        super(Material.field_151573_f);
        this.isBottomUnique = isBottomUnique;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemstack) {
        int metadata;
        if (entity.field_70125_A < -45.0f) {
            metadata = 0;
        } else if (entity.field_70125_A > 45.0f) {
            metadata = 1;
        } else {
            int side = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            switch (side) {
                case 0: {
                    metadata = 2;
                    break;
                }
                case 1: {
                    metadata = 5;
                    break;
                }
                case 2: {
                    metadata = 3;
                    break;
                }
                default: {
                    metadata = 4;
                }
            }
        }
        world.func_72921_c(x, y, z, metadata, 2);
    }

    public int func_149645_b() {
        return RenderBlockGasPump.RENDER_ID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.sideIcon = iconRegister.func_94245_a(this.func_149641_N() + "_side");
        this.bottomIcon = iconRegister.func_94245_a(this.func_149641_N() + (this.isBottomUnique ? "_bottom" : "_side"));
        this.topIcon = iconRegister.func_94245_a(this.func_149641_N() + "_top");
        this.topIncludingIcon = iconRegister.func_94245_a(this.func_149641_N() + "_top_including");
        this.topExcludingIcon = iconRegister.func_94245_a(this.func_149641_N() + "_top_excluding");
        this.topIndicatorIcon = iconRegister.func_94245_a(this.func_149641_N() + "_top_indicator");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        ForgeDirection blockDirection = ForgeDirection.UP;
        ForgeDirection sideDirection = ForgeDirection.getOrientation((int)side);
        if (sideDirection == blockDirection) {
            return this.topIcon;
        }
        if (sideDirection == blockDirection.getOpposite()) {
            return this.bottomIcon;
        }
        return this.sideIcon;
    }

    @Override
    public boolean receiveGas(World world, int x, int y, int z, ForgeDirection side, GasType gasType) {
        if (this.canReceiveGas(world, x, y, z, side, gasType)) {
            TileEntityGasPump tileEntity = (TileEntityGasPump)world.func_147438_o(x, y, z);
            tileEntity.containedType = gasType;
            tileEntity.pumpTime /= 2;
            return true;
        }
        return false;
    }

    @Override
    public boolean canReceiveGas(World world, int x, int y, int z, ForgeDirection side, GasType gasType) {
        if (ForgeDirection.getOrientation((int)world.func_72805_g(x, y, z)) != side) {
            TileEntityGasPump tileEntity = (TileEntityGasPump)world.func_147438_o(x, y, z);
            return tileEntity != null && tileEntity.acceptsType(gasType) && (tileEntity.containedType == null || tileEntity.containedType == GasesFrameworkAPI.gasTypeAir);
        }
        return false;
    }

    @Override
    public boolean canPropelGasFromSide(World world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.getOrientation((int)world.func_72805_g(x, y, z));
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityGasPump();
    }

    @Override
    public GasType sampleInteraction(World world, int x, int y, int z, GasType in, boolean excludes, ForgeDirection side) {
        TileEntityGasPump tileEntity = (TileEntityGasPump)world.func_147438_o(x, y, z);
        if (!world.field_72995_K && tileEntity != null) {
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.3f, 0.6f);
            tileEntity.setFilter(in, excludes);
        }
        return in;
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventID, int eventParam) {
        TileEntityGasPump tileEntity = (TileEntityGasPump)world.func_147438_o(x, y, z);
        if (tileEntity == null) {
            return false;
        }
        return tileEntity.blockEvent(eventID, eventParam);
    }

    @Override
    public boolean connectToPipe(IBlockAccess blockaccess, int x, int y, int z, ForgeDirection side) {
        return true;
    }
}

