/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.common.block;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import glenn.gasesframework.api.Combustibility;
import glenn.gasesframework.api.GasesFrameworkAPI;
import glenn.gasesframework.api.ItemKey;
import glenn.gasesframework.api.block.IGasReceptor;
import glenn.gasesframework.api.gastype.GasType;
import glenn.gasesframework.api.lanterntype.LanternType;
import glenn.gasesframework.client.render.RenderBlockLantern;
import glenn.gasesframework.common.block.BlockGasPipe;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLantern
extends Block
implements IGasReceptor {
    public IIcon topIcon;
    public IIcon sideIcon;
    public IIcon sideConnectedIcon;
    public IIcon connectorsIcon;
    public final LanternType type;

    public BlockLantern(LanternType type) {
        super(Material.field_151575_d);
        this.type = type;
        this.func_149711_c(0.25f);
        this.func_149715_a(type.lightLevel);
        this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.625f, 0.75f);
        if (type.expirationRate > 0) {
            this.func_149675_a(true);
        }
        this.func_149658_d(type.textureName);
    }

    public String func_149739_a() {
        return this.type.getUnlocalizedName();
    }

    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.topIcon = iconRegister.func_94245_a("gasesFramework:lantern_top");
        this.sideIcon = iconRegister.func_94245_a("gasesFramework:lantern_side");
        this.sideConnectedIcon = iconRegister.func_94245_a("gasesFramework:lantern_side_connected");
        this.connectorsIcon = iconRegister.func_94245_a("gasesFramework:lantern_connectors");
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (this.type.expirationRate > 0 && random.nextInt(this.type.expirationRate) == 0) {
            int metadata = world.func_72805_g(x, y, z) + 1;
            if (metadata >= 16) {
                world.func_147449_b(x, y, z, this.type.expirationLanternType.block);
            } else {
                world.func_72921_c(x, y, z, metadata, 3);
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        ItemKey itemIn;
        LanternType replacementType;
        ItemStack heldItem;
        ItemStack heldItemOrig = heldItem = entityPlayer.func_71045_bC();
        if (heldItem != null && heldItem.toString().contains("RealisticTorches_TorchLit")) {
            heldItem = new ItemStack(Blocks.field_150478_aa, 1);
        }
        if ((replacementType = LanternType.getLanternTypeByItemIn(itemIn = new ItemKey(heldItem))) == null) {
            replacementType = GasesFrameworkAPI.lanternTypeEmpty;
        }
        world.func_147449_b(x, y, z, replacementType.block);
        if (!entityPlayer.field_71075_bZ.field_75098_d && !itemIn.equals(this.type.itemOut)) {
            Item unlit;
            ItemStack itemStackOut;
            if (heldItemOrig != null && replacementType.accepts(itemIn) && --heldItemOrig.field_77994_a <= 0) {
                entityPlayer.func_71028_bD();
            }
            if ((itemStackOut = this.type.itemOut.itemStack()) != null && itemStackOut.toString().contains("tile.torch") && (unlit = GameRegistry.findItem((String)"RealisticTorches", (String)"TorchUnlit")) != null) {
                itemStackOut = new ItemStack(unlit, 1);
            }
            if (itemStackOut != null && !entityPlayer.field_71071_by.func_70441_a(itemStackOut) && !world.field_72995_K) {
                this.func_149642_a(world, x, y, z, itemStackOut);
            }
        }
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return RenderBlockLantern.RENDER_ID;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        if (!world.field_72995_K && !this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.isValidConnection(world, x - 1, y, z) || this.isValidConnection(world, x + 1, y, z) || this.isValidConnection(world, x, y - 1, z) || this.isValidConnection(world, x, y + 1, z) || this.isValidConnection(world, x, y, z - 1) || this.isValidConnection(world, x, y, z + 1);
    }

    public boolean isValidConnection(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block.func_149662_c() || block instanceof BlockGasPipe;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return this.func_149718_j(world, x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(GasesFrameworkAPI.lanternTypeEmpty.block));
        if (this.type.itemOut != null && this.type.itemOut.item != null) {
            if (this.type.itemOut.item.func_77658_a().contains("tile.torch")) {
                Item unlit = GameRegistry.findItem((String)"RealisticTorches", (String)"TorchUnlit");
                if (unlit != null) {
                    ret.add(new ItemStack(unlit, 1));
                } else {
                    ret.add(new ItemStack(this.type.itemOut.item, 1, this.type.itemOut.damage));
                }
            } else {
                ret.add(new ItemStack(this.type.itemOut.item, 1, this.type.itemOut.damage));
            }
        }
        return ret;
    }

    public Item func_149694_d(World world, int x, int y, int z) {
        if (this.type.expirationLanternType != null) {
            return Item.func_150898_a((Block)this.type.expirationLanternType.block);
        }
        return super.func_149694_d(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        switch (side) {
            case 2: {
                return blockAccess.func_147439_a(x + 1, y, z) instanceof BlockGasPipe ? this.sideConnectedIcon : this.sideIcon;
            }
            case 3: {
                return blockAccess.func_147439_a(x - 1, y, z) instanceof BlockGasPipe ? this.sideConnectedIcon : this.sideIcon;
            }
            case 4: {
                return blockAccess.func_147439_a(x, y, z + 1) instanceof BlockGasPipe ? this.sideConnectedIcon : this.sideIcon;
            }
            case 5: {
                return blockAccess.func_147439_a(x, y, z - 1) instanceof BlockGasPipe ? this.sideConnectedIcon : this.sideIcon;
            }
        }
        return this.topIcon;
    }

    @Override
    public boolean connectToPipe(IBlockAccess blockaccess, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    @Override
    public boolean receiveGas(World world, int x, int y, int z, ForgeDirection side, GasType gasType) {
        if (this.canReceiveGas(world, x, y, z, side, gasType)) {
            world.func_147449_b(x, y, z, GasesFrameworkAPI.lanternTypesGas[gasType.combustibility.burnRate].block);
            return true;
        }
        return false;
    }

    @Override
    public boolean canReceiveGas(World world, int x, int y, int z, ForgeDirection side, GasType gasType) {
        return this.type == GasesFrameworkAPI.lanternTypeGasEmpty && gasType.combustibility != Combustibility.NONE;
    }
}

