/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.common.tileentity;

import glenn.gasesframework.api.GasesFrameworkAPI;
import glenn.gasesframework.api.block.IGasReceptor;
import glenn.gasesframework.api.block.IGasSource;
import glenn.gasesframework.api.gastype.GasType;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityGasPump
extends TileEntity {
    public static final int PUMP_FREQUENCY = 20;
    public static final int PUMP_EVENT = 0;
    public static final int SET_FILTER_EVENT = 1;
    public static final int FAILED_PUMP = 0;
    public static final int SUCCESSFUL_PUMP = 1;
    public int pumpTime = 20;
    public boolean excludes = false;
    public GasType containedType;
    public GasType filterType;

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.pumpTime = tagCompound.func_74762_e("pumpTime");
        this.excludes = tagCompound.func_74767_n("excludes");
        this.containedType = GasType.getGasTypeByID(tagCompound.func_74762_e("containedType"));
        this.filterType = GasType.getGasTypeByID(tagCompound.func_74762_e("filterType"));
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("pumpTime", this.pumpTime);
        tagCompound.func_74757_a("excludes", this.excludes);
        tagCompound.func_74768_a("containedType", this.containedType != null ? this.containedType.gasID : -1);
        tagCompound.func_74768_a("filterType", this.filterType != null ? this.filterType.gasID : -1);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void setFilter(GasType filterType, boolean excludes) {
        if (this.excludes == excludes && this.filterType == filterType) {
            this.excludes = false;
            this.filterType = null;
        } else {
            this.excludes = excludes;
            this.filterType = filterType;
        }
        int eventParam = filterType.gasID & Integer.MAX_VALUE;
        if (excludes) {
            eventParam |= Integer.MIN_VALUE;
        }
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 1, eventParam);
    }

    public boolean acceptsType(GasType gasType) {
        if (this.filterType == null) {
            return true;
        }
        return this.filterType == gasType ^ this.excludes | gasType == GasesFrameworkAPI.gasTypeAir;
    }

    protected boolean canFill() {
        return this.containedType == null || this.containedType == GasesFrameworkAPI.gasTypeAir;
    }

    protected GasType extract() {
        ForgeDirection blockDirection = ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        int[] indices = this.randomIndexArray(this.field_145850_b.field_73012_v);
        int i = 0;
        while (i < 6 & this.containedType == null) {
            IGasSource gasSource;
            int z1;
            int y1;
            int x1;
            Block directionBlock;
            ForgeDirection direction = ForgeDirection.getOrientation((int)indices[i]);
            if (direction != blockDirection && (directionBlock = this.field_145850_b.func_147439_a(x1 = this.field_145851_c + direction.offsetX, y1 = this.field_145848_d + direction.offsetY, z1 = this.field_145849_e + direction.offsetZ)) instanceof IGasSource && this.acceptsType((gasSource = (IGasSource)directionBlock).getGasTypeFromSide(this.field_145850_b, x1, y1, z1, direction.getOpposite()))) {
                return gasSource.takeGasTypeFromSide(this.field_145850_b, x1, y1, z1, direction.getOpposite());
            }
            ++i;
        }
        return GasesFrameworkAPI.gasTypeAir;
    }

    protected boolean pumpToBlock(int x, int y, int z, ForgeDirection direction) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if (block instanceof IGasReceptor) {
            return ((IGasReceptor)block).receiveGas(this.field_145850_b, x, y, z, direction.getOpposite(), this.containedType);
        }
        return GasesFrameworkAPI.fillWithGas(this.field_145850_b, this.field_145850_b.field_73012_v, x, y, z, this.containedType);
    }

    protected boolean pump() {
        if (this.containedType != null) {
            ForgeDirection direction = ForgeDirection.getOrientation((int)this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            if (this.pumpToBlock(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ, direction)) {
                this.containedType = null;
                return true;
            }
            return false;
        }
        return false;
    }

    protected void tick() {
        if (this.canFill()) {
            this.containedType = this.extract();
        }
        if (this.pump()) {
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 0, 1);
        } else {
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 0, 0);
        }
    }

    public boolean isActive() {
        return !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.pumpTime-- <= 0) {
            if (this.isActive()) {
                this.tick();
            }
            this.pumpTime = 20;
        }
    }

    protected int[] randomIndexArray(Random random) {
        int[] array = new int[6];
        int i = 0;
        while (i < 6) {
            int index;
            while (array[index = random.nextInt(6)] != 0) {
            }
            array[index] = i++;
        }
        return array;
    }

    public boolean blockEvent(int eventID, int eventParam) {
        if (this.field_145850_b.field_72995_K) {
            switch (eventID) {
                case 0: {
                    if (eventParam == 1 || eventParam != 0) break;
                    break;
                }
                case 1: {
                    this.excludes = (eventParam & Integer.MIN_VALUE) != 0;
                    this.filterType = GasType.getGasTypeByID(eventParam & Integer.MAX_VALUE);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        }
        return true;
    }
}

