/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.common.tileentity;

import glenn.gasesframework.api.GasesFrameworkAPI;
import glenn.gasesframework.api.block.IGasReceptor;
import glenn.gasesframework.api.gastype.GasType;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityInfiniteGasPump
extends TileEntity {
    public static final int PUMP_FREQUENCY = 20;
    private int pumpTime = 20;
    private GasType[] types = new GasType[6];

    public TileEntityInfiniteGasPump() {
        for (int i = 0; i < this.types.length; ++i) {
            this.types[i] = GasesFrameworkAPI.gasTypeAir;
        }
    }

    public GasType getType(ForgeDirection side) {
        GasType type = this.types[side.ordinal()];
        return type;
    }

    public void setType(GasType newType, ForgeDirection side) {
        int ordinal = side.ordinal();
        if (newType == this.types[ordinal]) {
            newType = GasesFrameworkAPI.gasTypeAir;
        }
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), ordinal, newType != null ? newType.gasID : -1);
        this.types[ordinal] = newType;
    }

    public boolean isActive() {
        return !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.pumpTime-- <= 0) {
            if (this.isActive()) {
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    GasType type = this.getType(side);
                    int x = this.field_145851_c + side.offsetX;
                    int y = this.field_145848_d + side.offsetY;
                    int z = this.field_145849_e + side.offsetZ;
                    Block block = this.field_145850_b.func_147439_a(x, y, z);
                    if (block instanceof IGasReceptor) {
                        IGasReceptor receptor = (IGasReceptor)block;
                        receptor.receiveGas(this.field_145850_b, x, y, z, side.getOpposite(), type);
                        continue;
                    }
                    GasesFrameworkAPI.fillWithGas(this.field_145850_b, this.field_145850_b.field_73012_v, x, y, z, type);
                }
            }
            this.pumpTime = 20;
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.pumpTime = tagCompound.func_74762_e("pumpTime");
        int[] gasIDArray = tagCompound.func_74759_k("types");
        for (int i = 0; i < this.types.length; ++i) {
            this.types[i] = GasType.getGasTypeByID(gasIDArray[i]);
            if (this.types[i] != null) continue;
            this.types[i] = GasesFrameworkAPI.gasTypeAir;
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("pumpTime", this.pumpTime);
        int[] gasIDArray = new int[6];
        for (int i = 0; i < this.types.length; ++i) {
            GasType type = this.types[i];
            gasIDArray[i] = type.gasID;
        }
        tagCompound.func_74783_a("types", gasIDArray);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public boolean blockEvent(int eventID, int eventParam) {
        if (this.field_145850_b.field_72995_K) {
            this.types[eventID] = GasType.getGasTypeByID(eventParam);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }
}

